/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.navops.operator;

import com.rapidminer.connection.ConnectionInformation;
import com.rapidminer.connection.util.ConnectionInformationSelector;
import com.rapidminer.connection.util.ConnectionSelectionProvider;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.extension.navops.connection.NavopsConnHandler;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeText;
import com.rapidminer.parameter.TextType;
import com.rapidminer.tools.LogService;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.json.JSONArray;
import org.json.JSONObject;

public class QueryGraphqlOperator
extends Operator
implements ConnectionSelectionProvider {
    private final OutputPort outputPort = (OutputPort)this.getOutputPorts().createPort("example set");
    private final ConnectionInformationSelector connectionSelector = new ConnectionInformationSelector((Operator)this, "navops_conn:navops-conn");
    public static final String PARAMETER_QUERY_TEXT = "graphql_query";

    public QueryGraphqlOperator(OperatorDescription description) {
        super(description);
        this.connectionSelector.makeDefaultPortTransformation();
        this.getTransformer().addRule(ConnectionInformationSelector.makeConnectionCheckTransformation((ConnectionSelectionProvider)this));
    }

    public void doWork() throws OperatorException {
        ConnectionInformation connection = this.connectionSelector.getConnection();
        Map<String, String> configuration = NavopsConnHandler.getConfiguration(connection, this);
        String token = NavopsConnHandler.getToken(connection, null);
        if (token == null || token.trim().isEmpty()) {
            throw new OperatorException("Authentication token is missing.");
        }
        String navopUrl = configuration.get("url");
        String url = navopUrl + "/graphql-api/query";
        String queryText = this.getParameterAsString(PARAMETER_QUERY_TEXT);
        try {
            String line;
            JSONObject payload = new JSONObject();
            payload.put("query", (Object)queryText);
            HttpURLConnection con = (HttpURLConnection)new URL(url).openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("Authorization", "Bearer " + token);
            con.setRequestProperty("Content-Type", "application/json");
            con.setRequestProperty("Cookie", "navops-token=" + token);
            con.setDoOutput(true);
            OutputStream os = con.getOutputStream();
            os.write(payload.toString().getBytes("UTF-8"));
            os.flush();
            os.close();
            LogService.getRoot().info("GraphQL Request URL: " + url);
            LogService.getRoot().info("GraphQL Request Payload: " + payload.toString());
            BufferedReader reader = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuilder response = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
            reader.close();
            JSONObject responseJson = new JSONObject(response.toString());
            JSONArray edges = responseJson.getJSONObject("data").getJSONObject("inventoryNodes").getJSONArray("edges");
            ArrayList<Object> flatRows = new ArrayList<Object>();
            TreeSet allKeys = new TreeSet();
            for (int i = 0; i < edges.length(); ++i) {
                JSONObject node = edges.getJSONObject(i).getJSONObject("node");
                TreeMap flatMap = new TreeMap();
                this.flattenJson(node, "", flatMap);
                flatRows.add(flatMap);
                allKeys.addAll(flatMap.keySet());
            }
            ArrayList<Attribute> attributes = new ArrayList<Attribute>();
            HashMap<String, Attribute> attrMap = new HashMap<String, Attribute>();
            for (String key : allKeys) {
                Attribute attribute = AttributeFactory.createAttribute((String)key, (int)5);
                attributes.add(attribute);
                attrMap.put(key, attribute);
            }
            MemoryExampleTable table = new MemoryExampleTable(attributes);
            for (Map map : flatRows) {
                double[] data = new double[attributes.size()];
                for (int j = 0; j < attributes.size(); ++j) {
                    String key = ((Attribute)attributes.get(j)).getName();
                    String val = map.getOrDefault(key, null);
                    data[j] = val == null ? Double.NaN : (double)((Attribute)attrMap.get(key)).getMapping().mapString(val);
                }
                table.addDataRow((DataRow)new DoubleArrayDataRow(data));
            }
            this.outputPort.deliver((IOObject)table.createExampleSet());
        }
        catch (Exception e) {
            throw new OperatorException("Failed to perform GraphQL query: " + e.getMessage(), (Throwable)e);
        }
    }

    private void flattenJson(JSONObject obj, String prefix, Map<String, String> out) {
        for (String key : obj.keySet()) {
            String fullKey;
            Object val = obj.get(key);
            String string = fullKey = prefix.isEmpty() ? key : prefix + "." + key;
            if (val instanceof JSONObject) {
                this.flattenJson((JSONObject)val, fullKey, out);
                continue;
            }
            if (val instanceof JSONArray) {
                JSONArray arr = (JSONArray)val;
                for (int i = 0; i < arr.length(); ++i) {
                    Object item = arr.get(i);
                    if (item instanceof JSONObject) {
                        this.flattenJson((JSONObject)item, fullKey + "[" + i + "]", out);
                        continue;
                    }
                    out.put(fullKey + "[" + i + "]", String.valueOf(item));
                }
                continue;
            }
            out.put(fullKey, String.valueOf(val));
        }
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeText(PARAMETER_QUERY_TEXT, "GraphQL query to execute", TextType.PLAIN, true));
        return types;
    }

    public ConnectionInformationSelector getConnectionSelector() {
        return this.connectionSelector;
    }

    public void setConnectionSelector(ConnectionInformationSelector selector) {
    }
}

