/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.navops.operator;

import com.rapidminer.connection.ConnectionInformation;
import com.rapidminer.connection.util.ConnectionInformationSelector;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.extension.navops.connection.PBSGraphQLConnHandler;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeText;
import com.rapidminer.parameter.TextType;
import com.rapidminer.tools.LogService;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.json.JSONArray;
import org.json.JSONObject;

public class QueryPBSGraphqlOperator
extends Operator {
    private final OutputPort outputPort = (OutputPort)this.getOutputPorts().createPort("example set");
    private final ConnectionInformationSelector connectionSelector = new ConnectionInformationSelector((Operator)this, "navops_conn:pbs-graphql-conn");
    public static final String PARAMETER_QUERY_TEXT = "graphql_query";

    public QueryPBSGraphqlOperator(OperatorDescription description) {
        super(description);
    }

    public void doWork() throws OperatorException {
        ConnectionInformation connection = this.connectionSelector.getConnection();
        Map<String, String> config = PBSGraphQLConnHandler.getConfiguration(connection, this);
        String endpointUrl = config.get("url");
        String apiKey = config.get("apikey");
        String queryText = this.getParameterAsString(PARAMETER_QUERY_TEXT);
        try {
            String line;
            JSONObject payload = new JSONObject();
            payload.put("query", (Object)queryText);
            HttpURLConnection con = (HttpURLConnection)new URL(endpointUrl).openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("Authorization", "Bearer " + apiKey);
            con.setRequestProperty("Content-Type", "application/json");
            con.setDoOutput(true);
            OutputStream os = con.getOutputStream();
            os.write(payload.toString().getBytes("UTF-8"));
            os.flush();
            os.close();
            LogService.getRoot().info("PBS GraphQL Request Payload: " + payload.toString());
            BufferedReader reader = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuilder response = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
            reader.close();
            JSONObject responseJson = new JSONObject(response.toString());
            JSONObject dataObj = responseJson.getJSONObject("data");
            String rootKey = (String)dataObj.keys().next();
            JSONObject rootObj = dataObj.getJSONObject(rootKey);
            JSONArray edges = rootObj.optJSONArray("edges");
            if (edges == null) {
                throw new OperatorException("GraphQL response has no 'edges' array under " + rootKey);
            }
            ArrayList<Object> flatRows = new ArrayList<Object>();
            TreeSet allKeys = new TreeSet();
            for (int i = 0; i < edges.length(); ++i) {
                JSONObject node = edges.getJSONObject(i).getJSONObject("node");
                TreeMap flatMap = new TreeMap();
                this.flattenJson(node, "", flatMap);
                flatRows.add(flatMap);
                allKeys.addAll(flatMap.keySet());
            }
            ArrayList<Attribute> attributes = new ArrayList<Attribute>();
            HashMap<String, Attribute> attrMap = new HashMap<String, Attribute>();
            for (String key : allKeys) {
                Attribute attribute = AttributeFactory.createAttribute((String)key, (int)5);
                attributes.add(attribute);
                attrMap.put(key, attribute);
            }
            MemoryExampleTable table = new MemoryExampleTable(attributes);
            for (Map map : flatRows) {
                double[] data = new double[attributes.size()];
                for (int j = 0; j < attributes.size(); ++j) {
                    String key = ((Attribute)attributes.get(j)).getName();
                    String val = map.getOrDefault(key, null);
                    data[j] = val == null ? Double.NaN : (double)((Attribute)attrMap.get(key)).getMapping().mapString(val);
                }
                table.addDataRow((DataRow)new DoubleArrayDataRow(data));
            }
            this.outputPort.deliver((IOObject)table.createExampleSet());
        }
        catch (Exception e) {
            throw new OperatorException("Failed to perform GraphQL query: " + e.getMessage(), (Throwable)e);
        }
    }

    private void flattenJson(JSONObject obj, String prefix, Map<String, String> out) {
        for (String key : obj.keySet()) {
            String fullKey;
            Object val = obj.get(key);
            String string = fullKey = prefix.isEmpty() ? key : prefix + "." + key;
            if (val instanceof JSONObject) {
                this.flattenJson((JSONObject)val, fullKey, out);
                continue;
            }
            if (val instanceof JSONArray) {
                JSONArray arr = (JSONArray)val;
                for (int i = 0; i < arr.length(); ++i) {
                    Object item = arr.get(i);
                    if (item instanceof JSONObject) {
                        this.flattenJson((JSONObject)item, fullKey + "[" + i + "]", out);
                        continue;
                    }
                    out.put(fullKey + "[" + i + "]", String.valueOf(item));
                }
                continue;
            }
            out.put(fullKey, String.valueOf(val));
        }
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeText(PARAMETER_QUERY_TEXT, "GraphQL query to execute", TextType.PLAIN, true));
        return types;
    }
}

