/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.navops.operator;

import com.rapidminer.connection.ConnectionInformation;
import com.rapidminer.connection.util.ConnectionInformationSelector;
import com.rapidminer.connection.util.ConnectionSelectionProvider;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.extension.navops.connection.NavopsConnHandler;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.GenerateNewExampleSetMDRule;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaDataError;
import com.rapidminer.operator.ports.metadata.SimpleMetaDataError;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.tools.LogService;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.json.JSONArray;
import org.json.JSONObject;

public class ResourceReleaseOperator
extends Operator
implements ConnectionSelectionProvider {
    private final OutputPort outputPort = (OutputPort)this.getOutputPorts().createPort("example set");
    private final ConnectionInformationSelector connectionSelector = new ConnectionInformationSelector((Operator)this, "navops_conn:navops-conn");
    private final InputPort nodeInputPort = (InputPort)this.getInputPorts().createPort("node input");

    public ResourceReleaseOperator(OperatorDescription description) {
        super(description);
        this.getTransformer().addRule((MDTransformationRule)new GenerateNewExampleSetMDRule(this.outputPort));
        this.connectionSelector.makeDefaultPortTransformation();
        this.getTransformer().addRule(ConnectionInformationSelector.makeConnectionCheckTransformation((ConnectionSelectionProvider)this));
        this.getTransformer().addRule(new MDTransformationRule(){

            public void transformMD() {
                ExampleSetMetaData metaData = (ExampleSetMetaData)ResourceReleaseOperator.this.nodeInputPort.getMetaData();
                if (metaData != null) {
                    boolean hasNodeUid = false;
                    for (AttributeMetaData attrMeta : metaData.getAllAttributes()) {
                        if (!"node_uid".equalsIgnoreCase(attrMeta.getName())) continue;
                        hasNodeUid = true;
                        break;
                    }
                    if (!hasNodeUid) {
                        ResourceReleaseOperator.this.nodeInputPort.addError((MetaDataError)new SimpleMetaDataError(ProcessSetupError.Severity.ERROR, (Port)ResourceReleaseOperator.this.nodeInputPort, "The input must contain a column named 'node_uid'.", new Object[0]));
                    }
                }
            }
        });
    }

    public void doWork() throws OperatorException {
        ConnectionInformation connection = this.connectionSelector.getConnection();
        Map<String, String> configuration = NavopsConnHandler.getConfiguration(connection, this);
        String token = NavopsConnHandler.getToken(connection, null);
        if (token == null || token.trim().isEmpty()) {
            throw new OperatorException("Authentication token is missing. Please verify your Navops connection credentials.");
        }
        ExampleSet nodeSet = (ExampleSet)this.nodeInputPort.getData(ExampleSet.class);
        Attribute uidAttr = nodeSet.getAttributes().get("node_uid");
        if (uidAttr == null) {
            throw new OperatorException("The input ExampleSet must have a column named 'node_uid'.");
        }
        ArrayList<String> nodeUids = new ArrayList<String>();
        for (Example example : nodeSet) {
            String uid = example.getValueAsString(uidAttr);
            if (uid == null || uid.trim().isEmpty()) continue;
            nodeUids.add(uid.trim());
        }
        if (nodeUids.isEmpty()) {
            throw new OperatorException("The input ExampleSet must contain at least one non-empty node_uid.");
        }
        String navopUrl = configuration.get("url");
        String url = navopUrl + "/api/v1/node-release";
        try {
            String line;
            JSONObject payload = new JSONObject();
            JSONObject object = new JSONObject();
            object.put("node_uids", (Object)new JSONArray(nodeUids));
            payload.put("object", (Object)object);
            URL obj = new URL(url);
            HttpURLConnection con = (HttpURLConnection)obj.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("Authorization", "Bearer " + token);
            con.setRequestProperty("Accept", "application/json");
            con.setRequestProperty("Content-Type", "application/json");
            con.setDoOutput(true);
            LogService.getRoot().log(Level.INFO, "Sending request to URL: " + url);
            LogService.getRoot().log(Level.INFO, "Payload: " + payload.toString(2));
            con.getOutputStream().write(payload.toString().getBytes("UTF-8"));
            int responseCode = con.getResponseCode();
            if (responseCode != 200 && responseCode != 201) {
                throw new OperatorException("Failed to release node(s) on Navops. Received HTTP " + responseCode + " for URL: " + url);
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuilder response = new StringBuilder();
            while ((line = in.readLine()) != null) {
                response.append(line);
            }
            in.close();
            JSONObject jsonResponse = new JSONObject(response.toString());
            LogService.getRoot().log(Level.INFO, "JSON Response: " + jsonResponse.toString(2));
            String requestId = jsonResponse.optString("request_id", "");
            String traceId = jsonResponse.optString("trace_id", "");
            String actionId = jsonResponse.optString("action", "");
            ArrayList<Attribute> attributes = new ArrayList<Attribute>();
            attributes.add(AttributeFactory.createAttribute((String)"request_id", (int)5));
            attributes.add(AttributeFactory.createAttribute((String)"trace_id", (int)5));
            attributes.add(AttributeFactory.createAttribute((String)"action_id", (int)5));
            MemoryExampleTable table = new MemoryExampleTable(attributes);
            double[] values = new double[attributes.size()];
            values[0] = ((Attribute)attributes.get(0)).getMapping().mapString(requestId);
            values[1] = ((Attribute)attributes.get(1)).getMapping().mapString(traceId);
            values[2] = ((Attribute)attributes.get(2)).getMapping().mapString(actionId);
            table.addDataRow((DataRow)new DoubleArrayDataRow(values));
            LogService.getRoot().log(Level.INFO, "UNDEPLOY: " + nodeUids.size() + " node(s).");
            ExampleSet output = table.createExampleSet();
            this.connectionSelector.passDataThrough();
            this.outputPort.deliver((IOObject)output);
        }
        catch (ConnectException ce) {
            throw new OperatorException("Could not connect to Navops API at " + url + ". Please check your network or Navops URL.", (Throwable)ce);
        }
        catch (UnknownHostException uhe) {
            throw new OperatorException("Unknown host: " + uhe.getMessage() + ". Please check your Navops URL.", (Throwable)uhe);
        }
        catch (Exception e) {
            throw new OperatorException("Unexpected error while sending request: " + e.getMessage(), (Throwable)e);
        }
    }

    public List<ParameterType> getParameterTypes() {
        return super.getParameterTypes();
    }

    public ConnectionInformationSelector getConnectionSelector() {
        return this.connectionSelector;
    }

    public void setConnectionSelector(ConnectionInformationSelector selector) {
    }
}

