/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.navops.operator;

import com.rapidminer.connection.ConnectionInformation;
import com.rapidminer.connection.util.ConnectionInformationSelector;
import com.rapidminer.connection.util.ConnectionSelectionProvider;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.extension.navops.connection.NavopsConnHandler;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.GenerateNewExampleSetMDRule;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.tools.LogService;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.json.JSONObject;

public class ResourceRequestOperator
extends Operator
implements ConnectionSelectionProvider {
    private final OutputPort outputPort = (OutputPort)this.getOutputPorts().createPort("example set");
    private final ConnectionInformationSelector connectionSelector = new ConnectionInformationSelector((Operator)this, "navops_conn:navops-conn");
    private final InputPort paramInputPort = (InputPort)this.getInputPorts().createPort("parameter input");

    public ResourceRequestOperator(OperatorDescription description) {
        super(description);
        this.getTransformer().addRule((MDTransformationRule)new GenerateNewExampleSetMDRule(this.outputPort));
        this.connectionSelector.makeDefaultPortTransformation();
        this.getTransformer().addRule(ConnectionInformationSelector.makeConnectionCheckTransformation((ConnectionSelectionProvider)this));
    }

    public void doWork() throws OperatorException {
        ConnectionInformation connection = this.connectionSelector.getConnection();
        Map<String, String> configuration = NavopsConnHandler.getConfiguration(connection, this);
        String token = NavopsConnHandler.getToken(connection, null);
        if (token == null || token.trim().isEmpty()) {
            throw new OperatorException("Authentication token is missing. Please verify your Navops connection credentials.");
        }
        ExampleSet paramSet = (ExampleSet)this.paramInputPort.getData(ExampleSet.class);
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        attributes.add(AttributeFactory.createAttribute((String)"request_id", (int)5));
        attributes.add(AttributeFactory.createAttribute((String)"trace_id", (int)5));
        attributes.add(AttributeFactory.createAttribute((String)"action_id", (int)5));
        MemoryExampleTable table = new MemoryExampleTable(attributes);
        for (Example example : paramSet) {
            try {
                String line;
                String nodeClassUid = example.getValueAsString(paramSet.getAttributes().get("node_class_uid"));
                String clusterUid = example.getValueAsString(paramSet.getAttributes().get("cluster_uid"));
                String instanceType = example.getValueAsString(paramSet.getAttributes().get("instance_type"));
                String countStr = example.getValueAsString(paramSet.getAttributes().get("count"));
                String nodeConfigUid = example.getValueAsString(paramSet.getAttributes().get("node_config_uid"));
                if (nodeClassUid == null || nodeClassUid.trim().isEmpty()) {
                    throw new OperatorException("Missing node class UID.");
                }
                if (clusterUid == null || clusterUid.trim().isEmpty()) {
                    throw new OperatorException("Missing cluster UID.");
                }
                if (nodeConfigUid == null || nodeConfigUid.trim().isEmpty()) {
                    throw new OperatorException("Missing node configuration UID.");
                }
                String navopUrl = configuration.get("url");
                String url = navopUrl + "/api/v1/node-request";
                JSONObject payload = new JSONObject();
                JSONObject object = new JSONObject();
                object.put("node_class_uid", (Object)nodeClassUid);
                object.put("cluster_uid", (Object)clusterUid);
                object.put("node_config_uid", (Object)nodeConfigUid);
                if (countStr != null && !countStr.isEmpty()) {
                    try {
                        int count = (int)Double.parseDouble(countStr);
                        object.put("count", count);
                    }
                    catch (NumberFormatException e) {
                        throw new UserError(null, 123, new Object[]{"Invalid count: " + countStr});
                    }
                }
                if (instanceType != null && !instanceType.isEmpty()) {
                    JSONObject instanceTypeObj = new JSONObject();
                    instanceTypeObj.put("uid", (Object)instanceType);
                    object.put("instance_type", (Object)instanceTypeObj);
                }
                payload.put("object", (Object)object);
                URL obj = new URL(url);
                HttpURLConnection con = (HttpURLConnection)obj.openConnection();
                con.setRequestMethod("POST");
                con.setRequestProperty("Authorization", "Bearer " + token);
                con.setRequestProperty("Accept", "application/json");
                con.setRequestProperty("Content-Type", "application/json");
                con.setDoOutput(true);
                LogService.getRoot().log(Level.INFO, "Sending request to URL: " + url);
                LogService.getRoot().log(Level.INFO, "Payload: " + payload.toString(2));
                con.getOutputStream().write(payload.toString().getBytes("UTF-8"));
                int responseCode = con.getResponseCode();
                if (responseCode != 200 && responseCode != 201) {
                    throw new OperatorException("HTTP " + responseCode + " returned by Navops for URL: " + url);
                }
                BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
                StringBuilder response = new StringBuilder();
                while ((line = in.readLine()) != null) {
                    response.append(line);
                }
                in.close();
                JSONObject jsonResponse = new JSONObject(response.toString());
                LogService.getRoot().log(Level.INFO, "JSON Response: " + jsonResponse.toString(2));
                double[] values = new double[attributes.size()];
                values[0] = ((Attribute)attributes.get(0)).getMapping().mapString(jsonResponse.optString("request_id", ""));
                values[1] = ((Attribute)attributes.get(1)).getMapping().mapString(jsonResponse.optString("trace_id", ""));
                values[2] = ((Attribute)attributes.get(2)).getMapping().mapString(jsonResponse.optString("action", ""));
                DoubleArrayDataRow row = new DoubleArrayDataRow(values);
                table.addDataRow((DataRow)row);
                LogService.getRoot().log(Level.INFO, "DEPLOY: " + countStr + " node(s) of " + instanceType);
            }
            catch (Exception e) {
                LogService.getRoot().log(Level.WARNING, "Failed to process row: " + e.getMessage());
                throw new OperatorException("Error during Navops request: " + e.getMessage(), (Throwable)e);
            }
        }
        ExampleSet output = table.createExampleSet();
        this.connectionSelector.passDataThrough();
        this.outputPort.deliver((IOObject)output);
    }

    public List<ParameterType> getParameterTypes() {
        return super.getParameterTypes();
    }

    public ConnectionInformationSelector getConnectionSelector() {
        return this.connectionSelector;
    }

    public void setConnectionSelector(ConnectionInformationSelector selector) {
    }
}

