/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel;

import com.altair.ai.pel.dictionary.connection.DictionaryHandler;
import com.altair.ai.pel.dictionary.connection.gui.DictionaryGUIProvider;
import com.altair.ai.pel.gui.PythonExtensionsOverviewDialog;
import com.altair.ai.pel.gui.PythonSDKDebugDialog;
import com.altair.ai.pel.loader.PythonExtensionLoader;
import com.altair.ai.pel.loader.PythonExtensionRegistry;
import com.altair.ai.pel.loader.event.PythonExtensionRegistrationEvent;
import com.altair.ai.pel.operator.PythonIOObject;
import com.altair.ai.pel.operator.PythonIOObjectHandler;
import com.altair.ai.pel.operator.PythonIOObjectMetaData;
import com.altair.ai.pel.operator.SerializablePythonIOObject;
import com.altair.ai.pel.python.bridge.PythonBridge;
import com.altair.ai.pel.python.bridge.PythonBridgeStatus;
import com.altair.ai.pel.python.exception.PythonSDKException;
import com.altair.ai.pel.python.settings.PythonSDKSettings;
import com.rapidminer.RapidMiner;
import com.rapidminer.altair.license.StudioConstraintsManager;
import com.rapidminer.connection.ConnectionHandlerRegistry;
import com.rapidminer.connection.gui.ConnectionGUIProvider;
import com.rapidminer.connection.gui.ConnectionGUIRegistry;
import com.rapidminer.connection.util.GenericHandler;
import com.rapidminer.gui.MainFrame;
import com.rapidminer.gui.tools.ProgressThread;
import com.rapidminer.operator.ports.metadata.MetaDataFactory;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.repository.versioned.JsonStorableIOObjectResolver;
import com.rapidminer.tools.DeveloperTools;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ParameterService;
import java.util.Optional;
import java.util.logging.Level;

public final class PluginInitPythonExtensionLoader {
    public static final String EXTENSION_KEY = "rmx_pel";

    private PluginInitPythonExtensionLoader() {
    }

    public static void initPlugin() {
        if (StudioConstraintsManager.isRapidMinerLicense()) {
            LogService.getRoot().log(Level.WARNING, "Python extensions are only available with Altair Units! Disabling Python Extension Loader.");
            return;
        }
        try {
            PythonSDKSettings.updateSettings();
        }
        catch (PythonSDKException e) {
            LogService.getRoot().log(Level.SEVERE, "Python SDK configuration is broken, cannot start.", e);
            return;
        }
        ParameterService.registerParameter((ParameterType)new ParameterTypeBoolean("python_sdk.chain.enable", "", true));
        PythonIOObjectHandler.INSTANCE.register();
        JsonStorableIOObjectResolver.INSTANCE.register(SerializablePythonIOObject.class);
        MetaDataFactory.registerIOObjectMetaData(PythonIOObject.class, PythonIOObjectMetaData.class);
        if (!RapidMiner.getVersion().isAtLeast(DictionaryHandler.DICTIONARY_IN_CORE_VERSION)) {
            ConnectionHandlerRegistry.getInstance().registerHandler((GenericHandler)DictionaryHandler.INSTANCE);
        }
        if (PythonSDKSettings.isPyForceSynchronousLoading()) {
            PluginInitPythonExtensionLoader.initPythonBridge();
        } else {
            ProgressThread progressThread = new ProgressThread("python_bundle.start_python"){

                public void run() {
                    PluginInitPythonExtensionLoader.initPythonBridge();
                }
            };
            progressThread.start();
        }
    }

    public static void initGui(MainFrame mainframe) {
        if (DeveloperTools.shouldDeveloperToolsBeShown()) {
            PythonSDKDebugDialog.registerInHelpMenu(mainframe);
        }
        PythonExtensionsOverviewDialog.registerInExtensionsMenu(mainframe);
        if (!RapidMiner.getVersion().isAtLeast(DictionaryHandler.DICTIONARY_IN_CORE_VERSION)) {
            ConnectionGUIRegistry.INSTANCE.registerGUIProvider((ConnectionGUIProvider)new DictionaryGUIProvider(), DictionaryHandler.INSTANCE.getType());
        }
    }

    public static void initFinalChecks() {
    }

    public static void initPluginManager() {
    }

    private static void initPythonBridge() {
        PythonBridge.INSTANCE.initialize();
        PythonExtensionRegistry.INSTANCE.addEventListener((e, pyExt) -> {
            if (e.getEventType() == PythonExtensionRegistrationEvent.PYTHON_EXTENSION_REGISTERED) {
                LogService.getRoot().log(Level.INFO, () -> String.format("Python extension %s [%s] registered.", pyExt.getName(), pyExt.getVersion().getShortLongVersion()));
            }
        });
        PythonBridgeStatus status = PythonBridge.INSTANCE.getBridgeStatus();
        if (status != PythonBridgeStatus.READY) {
            LogService.getRoot().log(Level.SEVERE, String.format("Python SDK bridge is not ready but in state %s, cannot load Python extensions!", new Object[]{status}));
            return;
        }
        if (PythonSDKSettings.isPyForceSynchronousLoading()) {
            PythonExtensionLoader.loadExtensions(false, Optional.empty(), () -> Boolean.FALSE);
        } else {
            PluginInitPythonExtensionLoader.loadExtensionsInPT();
        }
    }

    private static void loadExtensionsInPT() {
        String i18nKey = "pel.load_extensions";
        ProgressThread pt = new ProgressThread(i18nKey){

            public void run() {
                PythonExtensionLoader.loadExtensions(false, Optional.of(this.getProgressListener()), () -> (this).isCancelled());
            }
        };
        pt.addDependency(new String[]{i18nKey});
        pt.start();
    }
}

