/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.dictionary.connection.gui;

import com.rapidminer.connection.gui.AbstractConnectionGUI;
import com.rapidminer.connection.gui.components.InjectedParameterPlaceholderLabel;
import com.rapidminer.connection.gui.model.ConnectionModel;
import com.rapidminer.connection.gui.model.ConnectionParameterGroupModel;
import com.rapidminer.connection.gui.model.ConnectionParameterModel;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.SwingTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.lang3.StringUtils;

public class DictionarySetupTab
extends JPanel {
    private static final Icon ENCRYPTED_ICON = SwingTools.createIcon((String)"16/password_field.png");
    private static final Icon TEXT_ICON = SwingTools.createIcon((String)"16/text_field.png");
    private final JScrollPane scrollPane;
    private final ConnectionModel model;
    private final ConnectionParameterGroupModel dictionaryGroupModel;
    private final JPanel rowOuterPanel;
    private final AdvancedKeyModel keyModel;
    private final ChangeListener<String> injectionListener;

    DictionarySetupTab(ConnectionModel model) {
        super(new BorderLayout());
        this.model = model;
        this.dictionaryGroupModel = model.getOrCreateParameterGroup("basic");
        this.keyModel = new AdvancedKeyModel();
        this.injectionListener = (observableValue, s, t1) -> this.updateRows();
        final JPanel rootPanel = new JPanel(new GridBagLayout());
        rootPanel.setBorder(AbstractConnectionGUI.DEFAULT_PANEL_BORDER);
        this.fillKeyModel();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 2, 0);
        gbc.weightx = 1.0;
        this.rowOuterPanel = new JPanel(new GridBagLayout());
        ++gbc.gridy;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.updateRows();
        rootPanel.add((Component)this.rowOuterPanel, gbc);
        if (model.isEditable()) {
            ++gbc.gridy;
            gbc.weighty = 0.0;
            gbc.fill = 0;
            gbc.anchor = 17;
            gbc.insets = new Insets(0, 0, 7, 0);
            JPanel buttonPanel = new JPanel(new BorderLayout());
            buttonPanel.add((Component)new JButton((Action)new ResourceAction(true, "connection.parameter.process_defined_operators.dictionary.config.add", new Object[0]){

                protected void loggedActionPerformed(ActionEvent e) {
                    DictionarySetupTab.this.keyModel.addAdvancedKey("", "", true, true);
                    DictionarySetupTab.this.fireStructureChanged();
                    DictionarySetupTab.this.scrollPane.getViewport().scrollRectToVisible(new Rectangle(1, rootPanel.getHeight() + 50, 1, 1));
                }
            }), "West");
            buttonPanel.add(Box.createHorizontalStrut(3), "Center");
            buttonPanel.add((Component)new JButton((Action)new ResourceAction(true, "connection.parameter.process_defined_operators.dictionary.config.add_string", new Object[0]){

                protected void loggedActionPerformed(ActionEvent e) {
                    DictionarySetupTab.this.keyModel.addAdvancedKey("", "", false, true);
                    DictionarySetupTab.this.fireStructureChanged();
                    DictionarySetupTab.this.scrollPane.getViewport().scrollRectToVisible(new Rectangle(1, rootPanel.getHeight() + 50, 1, 1));
                }
            }), "East");
            rootPanel.add((Component)buttonPanel, gbc);
        }
        this.scrollPane = new ExtendedJScrollPane((Component)rootPanel);
        this.scrollPane.setBorder(null);
        this.add((Component)this.scrollPane, "Center");
    }

    private void fillKeyModel() {
        for (ConnectionParameterModel parameter : this.dictionaryGroupModel.getParameters()) {
            this.keyModel.addAdvancedKey(parameter.getName(), parameter.getValue(), parameter.isEncrypted(), parameter.isEnabled());
            parameter.injectorNameProperty().addListener(this.injectionListener);
        }
    }

    private void updateRows() {
        this.rowOuterPanel.removeAll();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 5, 0);
        for (int i = 0; i < this.keyModel.getSize(); ++i) {
            AdvancedKey advancedKey = this.keyModel.getAdvancedKey(i);
            this.rowOuterPanel.add((Component)this.createRow(i, advancedKey), gbc);
            ++gbc.gridy;
        }
        ++gbc.gridy;
        gbc.weighty = 1.0;
        gbc.fill = 3;
        this.rowOuterPanel.add((Component)new JLabel(), gbc);
        this.rowOuterPanel.revalidate();
        this.rowOuterPanel.repaint();
    }

    private JPanel createRow(final int index, AdvancedKey advancedKey) {
        JComponent keyComp;
        String key = advancedKey.getKey();
        String value = advancedKey.getValue();
        boolean encrypted = advancedKey.isEncrypted();
        boolean enabled = advancedKey.isEnabled();
        JPanel rowPanel = new JPanel(new GridBagLayout());
        JPanel innerRowPanel = new JPanel(new GridLayout(1, 2, 10, 0));
        final JTextField valueField = encrypted ? new JPasswordField(15) : new JTextField(15);
        valueField.setText(advancedKey.getValue());
        valueField.setEnabled(this.model.isEditable() && enabled);
        if (this.model.isEditable()) {
            final JTextField keyField = new JTextField(15);
            keyField.setText(advancedKey.getKey());
            keyField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.updateKey();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.updateKey();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.updateKey();
                }

                private void updateKey() {
                    String oldKey = DictionarySetupTab.this.keyModel.getAdvancedKey(index).getKey();
                    String newName = keyField.getText();
                    if (oldKey == null || !oldKey.equals(newName)) {
                        DictionarySetupTab.this.removeParameterIfExists(DictionarySetupTab.this.keyModel.getAdvancedKey(index).getKey());
                        DictionarySetupTab.this.keyModel.setKey(index, newName);
                        DictionarySetupTab.this.fireContentChanged();
                    }
                }
            });
            keyComp = keyField;
        } else {
            keyComp = new JLabel(key);
        }
        JPanel comboPanel = new JPanel(new GridBagLayout());
        comboPanel.setPreferredSize(new Dimension(300, keyComp.getPreferredSize().height));
        GridBagConstraints innerGbc = new GridBagConstraints();
        innerGbc.gridx = 0;
        innerGbc.gridy = 0;
        innerGbc.weightx = 1.0;
        innerGbc.fill = 2;
        comboPanel.add((Component)keyComp, innerGbc);
        innerRowPanel.add(comboPanel);
        ConnectionParameterModel parameter = this.dictionaryGroupModel.getParameter(key);
        if (parameter != null && parameter.isInjected()) {
            innerRowPanel.add((Component)new InjectedParameterPlaceholderLabel(parameter));
        } else {
            JComponent valComp;
            if (this.model.isEditable()) {
                valueField.getDocument().addDocumentListener(new DocumentListener(){

                    @Override
                    public void insertUpdate(DocumentEvent e) {
                        this.updateValue();
                    }

                    @Override
                    public void removeUpdate(DocumentEvent e) {
                        this.updateValue();
                    }

                    @Override
                    public void changedUpdate(DocumentEvent e) {
                        this.updateValue();
                    }

                    private void updateValue() {
                        String newValue = valueField.getText();
                        String existingValue = DictionarySetupTab.this.keyModel.getAdvancedKey(index).getValue();
                        if (existingValue == null || !existingValue.equals(newValue)) {
                            DictionarySetupTab.this.keyModel.setValue(index, newValue);
                            DictionarySetupTab.this.fireContentChanged();
                        }
                    }
                });
                JPanel container = new JPanel(new BorderLayout());
                container.add((Component)valueField, "Center");
                Icon icon = encrypted ? ENCRYPTED_ICON : TEXT_ICON;
                container.add((Component)new JLabel(icon), "East");
                valComp = container;
            } else if (parameter != null && parameter.isEncrypted()) {
                char[] replacement = new char[value != null ? value.length() : 0];
                Arrays.fill(replacement, '*');
                valComp = new JLabel(new String(replacement));
            } else {
                valComp = new JLabel(value);
            }
            innerRowPanel.add(valComp);
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        rowPanel.add((Component)innerRowPanel, gbc);
        if (this.model.isEditable()) {
            ++gbc.gridx;
            gbc.weightx = 0.0;
            gbc.fill = 0;
            gbc.insets = new Insets(0, 10, 0, 0);
            JButton deleteButton = new JButton((Action)new ResourceAction(false, "connection.parameter.process_defined_operators.dictionary.config.remove", new Object[0]){

                protected void loggedActionPerformed(ActionEvent e) {
                    DictionarySetupTab.this.removeParameterIfExists(DictionarySetupTab.this.keyModel.getAdvancedKey(index).getKey());
                    DictionarySetupTab.this.keyModel.removeAdvancedKey(index);
                    DictionarySetupTab.this.fireStructureChanged();
                }
            });
            deleteButton.setContentAreaFilled(false);
            deleteButton.setBorderPainted(false);
            rowPanel.add((Component)deleteButton, gbc);
        }
        return rowPanel;
    }

    private void fireStructureChanged() {
        this.updateRows();
        this.fireContentChanged();
    }

    private void fireContentChanged() {
        for (AdvancedKey advancedKey : this.keyModel.getAdvancedKeys()) {
            if (StringUtils.trimToNull((String)advancedKey.getKey()) == null) continue;
            ConnectionParameterModel existingParameter = this.dictionaryGroupModel.getParameter(advancedKey.getKey());
            if (existingParameter == null) {
                this.dictionaryGroupModel.addOrSetParameter(advancedKey.getKey(), advancedKey.getValue(), advancedKey.isEncrypted(), null, true);
                this.dictionaryGroupModel.getParameter(advancedKey.getKey()).injectorNameProperty().addListener(this.injectionListener);
                continue;
            }
            existingParameter.setValue(advancedKey.getValue());
            existingParameter.setEncrypted(advancedKey.isEncrypted());
        }
    }

    private void removeParameterIfExists(String key) {
        ConnectionParameterModel toBeRemovedParam = this.dictionaryGroupModel.getParameter(key);
        if (toBeRemovedParam != null) {
            toBeRemovedParam.injectorNameProperty().removeListener(this.injectionListener);
            this.dictionaryGroupModel.removeParameter(toBeRemovedParam.getName());
        }
    }

    private static class AdvancedKeyModel {
        private final List<AdvancedKey> keys = Collections.synchronizedList(new ArrayList());

        private AdvancedKeyModel() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<AdvancedKey> getAdvancedKeys() {
            List<AdvancedKey> list = this.keys;
            synchronized (list) {
                return new ArrayList<AdvancedKey>(this.keys);
            }
        }

        private int getSize() {
            return this.keys.size();
        }

        private AdvancedKey getAdvancedKey(int index) {
            return this.keys.get(index);
        }

        private void addAdvancedKey(String key, String value, boolean encrypted, boolean enabled) {
            this.keys.add(new AdvancedKey(key, value, encrypted, enabled));
        }

        private void removeAdvancedKey(int index) {
            this.keys.remove(index);
        }

        private void setKey(int index, String key) {
            this.keys.get(index).setKey(key);
        }

        private void setValue(int index, String value) {
            this.keys.get(index).setValue(value);
        }
    }

    private static final class AdvancedKey {
        private String key;
        private String value;
        private final boolean encrypted;
        private final boolean enabled;

        private AdvancedKey(String key, String value, boolean encrypted, boolean enabled) {
            this.key = key;
            this.value = value;
            this.encrypted = encrypted;
            this.enabled = enabled;
        }

        private String getKey() {
            return this.key;
        }

        private void setKey(String key) {
            this.key = key;
        }

        private String getValue() {
            return this.value;
        }

        private void setValue(String value) {
            this.value = value;
        }

        private boolean isEncrypted() {
            return this.encrypted;
        }

        private boolean isEnabled() {
            return this.enabled;
        }
    }
}

