/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.distribution;

import com.rapidminer.tools.ValidationUtilV2;
import java.util.Objects;

public class PythonDistribution {
    private final String key;
    private final String version;

    public PythonDistribution(String key, String version) {
        this.key = ValidationUtilV2.requireNonEmptyString((String)key, (String)"key");
        this.version = version;
    }

    public String getKey() {
        return this.key;
    }

    public String getVersion() {
        return this.version;
    }

    public String toDistributionString() {
        if (this.version != null) {
            return this.key + "-" + this.version;
        }
        return this.key;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PythonDistribution that = (PythonDistribution)o;
        return Objects.equals(this.key, that.key) && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.version);
    }

    public String toString() {
        return "PythonDistribution{key='" + this.key + "', version='" + this.version + "'}";
    }
}

