/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.distribution;

import com.altair.ai.pel.distribution.DistributionCapability;
import com.altair.ai.pel.distribution.PythonDistribution;
import com.altair.ai.pel.distribution.PythonDistributionHandlerTools;
import com.altair.ai.pel.distribution.PythonDistributionMode;
import com.altair.ai.pel.distribution.PythonDistributionReference;
import com.altair.ai.pel.distribution.PythonDistributionStatus;
import com.altair.ai.pel.loader.PythonExtension;
import com.altair.ai.pel.python.event.PythonDistributionHandlerEvent;
import com.altair.ai.pel.python.event.PythonDistributionHandlerEventListener;
import com.altair.ai.pel.python.event.PythonDistributionRegistrationEvent;
import com.altair.ai.pel.python.exception.PythonDistributionAlreadyRegisteredException;
import com.altair.ai.pel.python.exception.PythonDistributionNotRegisteredException;
import com.altair.ai.pel.python.exception.PythonDistributionRegistrationException;
import com.altair.ai.pel.python.settings.PythonSDKSettings;
import com.altair.ai.pel.python.util.PythonDistributionTools;
import com.altair.ai.pel.util.ExternalProcess;
import com.altair.ai.pel.util.ExternalProcessBuilder;
import com.rapidminer.gui.tools.VersionNumber;
import com.rapidminer.tools.IOTools;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.SecurityTools;
import com.rapidminer.tools.TempFileTools;
import com.rapidminer.tools.ValidationUtilV2;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public enum PythonDistributionHandler {
    INSTANCE;

    private final List<PythonDistributionHandlerEventListener> listeners = Collections.synchronizedList(new ArrayList());
    private final ExecutorService listenerNotificationService = Executors.newFixedThreadPool(1);
    private final Map<PythonDistribution, PythonDistributionReference> distributions = Collections.synchronizedMap(new LinkedHashMap());
    private final Map<PythonDistribution, PythonDistributionStatus> distStatus = Collections.synchronizedMap(new HashMap());
    private final Map<PythonDistribution, Object> registerLocks = Collections.synchronizedMap(new HashMap());

    private PythonDistributionHandler() {
        PythonDistributionHandlerEventListener distStatusListener = (event, pyDist) -> {
            switch (event.getEventType()) {
                case PYTHON_DISTRIBUTION_IN_REGISTRATION: {
                    this.distStatus.merge(pyDist, PythonDistributionStatus.IN_REGISTRATION, (oldStatus, newStatus) -> oldStatus == PythonDistributionStatus.REGISTERED ? oldStatus : newStatus);
                    break;
                }
                case PYTHON_DISTRIBUTION_REGISTRATION_FAILURE: {
                    this.distStatus.put(pyDist, PythonDistributionStatus.FAILED_TO_REGISTER);
                    break;
                }
                case PYTHON_DISTRIBUTION_REGISTERED: {
                    this.distStatus.put(pyDist, PythonDistributionStatus.REGISTERED);
                    break;
                }
                case PYTHON_DISTRIBUTION_UNREGISTERED: {
                    this.distStatus.put(pyDist, PythonDistributionStatus.UNREGISTERED);
                    break;
                }
                default: {
                    this.distStatus.put(pyDist, PythonDistributionStatus.UNKNOWN);
                }
            }
        };
        this.addEventListener(distStatusListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDistributionForExtension(PythonExtension pyExt) {
        ValidationUtilV2.requireNonNull((Object)pyExt, (String)"pyExt");
        if (PythonSDKSettings.isPyDistRegistrationSkipped()) {
            LogService.getRoot().log(Level.FINE, () -> String.format("Skipped Python distribution registration for Python extension %s due to distribution registration being disabled via setting!", pyExt.getName()));
            return;
        }
        LogService.getRoot().log(Level.FINE, () -> String.format("Registering Python distribution for Python extension %s [%s]", pyExt.getName(), pyExt.getVersion().getShortLongVersion()));
        PythonDistribution newDist = pyExt.getPythonDist();
        this.fireHandlerEvent(PythonDistributionRegistrationEvent.PYTHON_DISTRIBUTION_IN_REGISTRATION, newDist);
        Object object = this.registerLocks.computeIfAbsent(newDist, pyDist -> new Object());
        synchronized (object) {
            try {
                if (!PythonDistributionHandlerTools.registerDistributionForExtension(pyExt)) {
                    this.fireHandlerEvent(PythonDistributionRegistrationEvent.PYTHON_DISTRIBUTION_REGISTRATION_FAILURE, newDist);
                }
            }
            catch (PythonDistributionAlreadyRegisteredException e) {
                LogService.getRoot().log(Level.FINE, () -> String.format("Python distribution %s requested by Python extension %s, already registered, skipping.", e.getDist().toDistributionString(), pyExt.getName()));
                this.fireHandlerEvent(PythonDistributionRegistrationEvent.PYTHON_DISTRIBUTION_REGISTERED, newDist);
            }
        }
    }

    public void addEventListener(PythonDistributionHandlerEventListener listener) {
        this.listeners.add((PythonDistributionHandlerEventListener)ValidationUtilV2.requireNonNull((Object)listener, (String)"listener"));
    }

    public void removeEventListener(PythonDistributionHandlerEventListener listener) {
        this.listeners.remove(ValidationUtilV2.requireNonNull((Object)listener, (String)"listener"));
    }

    public boolean isDistributionRegistered(PythonDistribution pyDist) {
        return this.distributions.containsKey(ValidationUtilV2.requireNonNull((Object)pyDist, (String)"pyDist"));
    }

    public PythonDistributionStatus getDistributionStatus(PythonDistribution pyDist) {
        return this.distStatus.computeIfAbsent(pyDist, dist -> PythonDistributionStatus.NOT_YET_REGISTERED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PythonDistribution> getRegisteredDistributions() {
        Map<PythonDistribution, PythonDistributionReference> map = this.distributions;
        synchronized (map) {
            return new ArrayList<PythonDistribution>(this.distributions.keySet());
        }
    }

    public PythonDistributionReference getDistributionReference(PythonDistribution pyDist) {
        ValidationUtilV2.requireNonNull((Object)pyDist, (String)"pyDist");
        return this.distributions.get(pyDist);
    }

    void registerDistribution(PythonDistribution dist, List<Path> executables, PythonDistributionMode distributionMode) throws PythonDistributionRegistrationException {
        switch (distributionMode) {
            case MINIFORGE: 
            case LOCAL: {
                this.registerLocalDistribution(dist, executables, distributionMode);
                break;
            }
            default: {
                throw new PythonDistributionRegistrationException(String.format("Unknown distribution mode %s not yet implemented", new Object[]{distributionMode}), dist);
            }
        }
        this.fireHandlerEvent(PythonDistributionRegistrationEvent.PYTHON_DISTRIBUTION_REGISTERED, dist);
    }

    void unregisterDistribution(PythonDistribution distToRemove) throws PythonDistributionNotRegisteredException {
        SecurityTools.requireInternalPermission();
        ValidationUtilV2.requireNonNull((Object)distToRemove, (String)"distToRemove");
        PythonDistributionReference removed = this.distributions.remove(distToRemove);
        if (removed == null) {
            throw new PythonDistributionNotRegisteredException("Python distribution was not registered", distToRemove);
        }
        this.fireHandlerEvent(PythonDistributionRegistrationEvent.PYTHON_DISTRIBUTION_UNREGISTERED, distToRemove);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerLocalDistribution(PythonDistribution newDist, List<Path> executables, PythonDistributionMode distMode) throws PythonDistributionRegistrationException {
        List<Path> absoluteExecPaths;
        ValidationUtilV2.requireNonNull((Object)newDist, (String)"newDist");
        Map<PythonDistribution, PythonDistributionReference> map = this.distributions;
        synchronized (map) {
            if (this.distributions.keySet().stream().anyMatch(newDist::equals)) {
                throw new PythonDistributionAlreadyRegisteredException(newDist);
            }
        }
        if (executables == null || executables.isEmpty()) {
            executables = PythonDistributionTools.getDefaultExecutableRelativePaths();
        }
        if (!executables.get(0).isAbsolute()) {
            Path rootDir = PythonDistributionTools.resolveDistributionRootDir(newDist, distMode);
            absoluteExecPaths = executables.stream().map(rootDir::resolve).collect(Collectors.toList());
        } else {
            absoluteExecPaths = executables;
        }
        PythonDistributionReference distRef = this.verifyInstallationOnDisk(newDist, absoluteExecPaths, distMode);
        this.distributions.put(newDist, distRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PythonDistributionReference verifyInstallationOnDisk(PythonDistribution newDist, List<Path> executables, PythonDistributionMode distMode) throws PythonDistributionRegistrationException {
        PythonDistributionRegistrationException ex;
        if (executables == null || executables.isEmpty()) {
            throw new PythonDistributionRegistrationException("Python distribution has no executables!", newDist);
        }
        AtomicReference<PythonDistributionRegistrationException> caughtException = new AtomicReference<PythonDistributionRegistrationException>();
        for (Path executable : executables) {
            Path testFile = null;
            try {
                InputStream testScriptIS = PythonDistributionHandler.class.getResourceAsStream("/com/altair/extension/resources/scripts/test/test.py");
                try {
                    if (testScriptIS == null) {
                        caughtException.set(new PythonDistributionRegistrationException("Could not verify Python distribution installation due to test script not found", newDist));
                        break;
                    }
                    if (!Files.exists(executable, new LinkOption[0])) {
                        throw new FileNotFoundException(executable.toString());
                    }
                    testFile = TempFileTools.createTempFile((String)"pybundle-test", (String)".py");
                    IOTools.copyStreamSynchronously((InputStream)testScriptIS, (OutputStream)Files.newOutputStream(testFile, StandardOpenOption.TRUNCATE_EXISTING), (boolean)true);
                    ArrayList<String> output = new ArrayList<String>();
                    StringJoiner errJoiner = new StringJoiner("\n");
                    CountDownLatch latch = new CountDownLatch(2);
                    ExternalProcess testResult = ExternalProcessBuilder.newBuilder().outputConsumer(output::add).errorConsumer(errJoiner::add).awaitOutputStreamsClosing(latch).id("distribution-test").command(executable.toString(), testFile.toAbsolutePath().toString()).startProcess();
                    Process testProcess = testResult.getProcessFuture().get(30L, TimeUnit.SECONDS);
                    if (!latch.await(1L, TimeUnit.SECONDS)) {
                        throw new TimeoutException();
                    }
                    if (errJoiner.length() > 0) {
                        caughtException.set(new PythonDistributionRegistrationException(String.format("Failed to verify Python distribution, error from Python was: %s with exit code %d", errJoiner, testProcess.exitValue()), newDist));
                        continue;
                    }
                    if (!output.isEmpty()) {
                        PythonDistributionReference pythonDistributionReference = this.checkDistributionCapabilitiesOnDisk(output, newDist, executable, distMode);
                        return pythonDistributionReference;
                    }
                    caughtException.set(new PythonDistributionRegistrationException("Failed to verify Python distribution, no output from Python!", newDist));
                }
                finally {
                    if (testScriptIS == null) continue;
                    testScriptIS.close();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                caughtException.set(new PythonDistributionRegistrationException("Failed to verify Python distribution", newDist, e));
            }
            catch (FileNotFoundException e) {
                if (caughtException.get() != null) continue;
                caughtException.set(new PythonDistributionRegistrationException("Failed to verify Python distribution", newDist, e));
            }
            catch (IOException e) {
                caughtException.set(new PythonDistributionRegistrationException("Failed to verify Python distribution", newDist, e));
            }
            catch (ExecutionException e) {
                caughtException.set(new PythonDistributionRegistrationException("Failed to verify Python distribution", newDist, e.getCause()));
            }
            catch (TimeoutException e) {
                caughtException.set(new PythonDistributionRegistrationException("Failed to verify Python distribution, test process did not finish", newDist));
            }
            finally {
                if (testFile == null) continue;
                FileUtils.deleteQuietly((File)testFile.toFile());
            }
        }
        if ((ex = (PythonDistributionRegistrationException)caughtException.get()) != null) {
            throw ex;
        }
        throw new PythonDistributionRegistrationException("The Python distribution installation could not be verified but no exception was caught, unexpected state!", newDist);
    }

    private PythonDistributionReference checkDistributionCapabilitiesOnDisk(List<String> output, PythonDistribution newDist, Path executable, PythonDistributionMode distMode) throws PythonDistributionRegistrationException {
        String[] operatingModeParts;
        int expectedLineCount = 2;
        if (output.size() != expectedLineCount) {
            throw new PythonDistributionRegistrationException(String.format("Failed to verify Python distribution %s, output was %s, but should have been %d lines!", newDist.toDistributionString(), output, expectedLineCount), newDist);
        }
        String pyVersionStr = output.get(0);
        String supportedModesStr = output.get(1);
        LinkedHashSet<DistributionCapability> supportedCapabilities = new LinkedHashSet<DistributionCapability>();
        String[] versionParts = pyVersionStr.split("\\s");
        VersionNumber pythonVersion = new VersionNumber(versionParts[0]);
        if (!pythonVersion.isAtLeast(3, 9, 0)) {
            throw new PythonDistributionRegistrationException(String.format("Failed to verify Python distribution %s, Python version %s is below minimally required 3.9!", newDist.toDistributionString(), pythonVersion.getShortLongVersion()), newDist);
        }
        for (String supported : operatingModeParts = supportedModesStr.split("\\s")) {
            if (StringUtils.trimToNull((String)supported) == null) continue;
            try {
                supportedCapabilities.add(DistributionCapability.valueOf(supported));
            }
            catch (IllegalArgumentException e) {
                LogService.getRoot().log(Level.WARNING, () -> String.format("BUG: Unexpected distribution capability, ignoring: %s", supported));
            }
        }
        if (PythonDistributionTools.getSupportedCommunicationModes(supportedCapabilities).isEmpty()) {
            throw new PythonDistributionRegistrationException(String.format("Failed to verify Python distribution %s, it does not have the required packages to support any communication mode!", newDist.toDistributionString()), newDist);
        }
        LogService.getRoot().log(Level.FINE, () -> String.format("Successfully verified Python distribution %s (Python version: %s, supported capabilities: %s)", newDist.toDistributionString(), pythonVersion.getShortLongVersion(), supportedCapabilities));
        return new PythonDistributionReference(newDist, executable, pythonVersion, supportedCapabilities, distMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireHandlerEvent(PythonDistributionRegistrationEvent type, PythonDistribution pyDist) {
        List<PythonDistributionHandlerEventListener> list = this.listeners;
        synchronized (list) {
            for (PythonDistributionHandlerEventListener listener : this.listeners) {
                this.notifyListener(() -> listener.pythonDistributionRegistrationChanged(new PythonDistributionHandlerEvent(type), pyDist));
            }
        }
    }

    private void notifyListener(Runnable r) {
        try {
            this.listenerNotificationService.submit(r);
        }
        catch (RejectedExecutionException e) {
            LogService.getRoot().log(Level.WARNING, "Failed to notify listener about Python distribution handler event", e);
        }
    }
}

