/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.distribution;

import com.altair.ai.pel.distribution.PythonDistribution;
import com.altair.ai.pel.distribution.PythonDistributionHandler;
import com.altair.ai.pel.distribution.PythonDistributionMode;
import com.altair.ai.pel.distribution.installer.archive.PythonDistributionInstaller;
import com.altair.ai.pel.distribution.installer.archive.PythonDistributionInstallerFactory;
import com.altair.ai.pel.loader.PythonExtension;
import com.altair.ai.pel.miniforge.MiniforgeHandler;
import com.altair.ai.pel.miniforge.MiniforgeStatus;
import com.altair.ai.pel.python.exception.PythonDistributionAlreadyRegisteredException;
import com.altair.ai.pel.python.exception.PythonDistributionInstallationException;
import com.altair.ai.pel.python.exception.PythonDistributionNotRegisteredException;
import com.altair.ai.pel.python.exception.PythonDistributionRegistrationException;
import com.altair.ai.pel.python.settings.PythonSDKSettings;
import com.altair.ai.pel.python.util.PythonDistributionTools;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.SecurityTools;
import com.rapidminer.tools.ValidationUtilV2;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;

public final class PythonDistributionHandlerTools
extends Enum<PythonDistributionHandlerTools> {
    private static final /* synthetic */ PythonDistributionHandlerTools[] $VALUES;

    public static PythonDistributionHandlerTools[] values() {
        return (PythonDistributionHandlerTools[])$VALUES.clone();
    }

    public static PythonDistributionHandlerTools valueOf(String name) {
        return Enum.valueOf(PythonDistributionHandlerTools.class, name);
    }

    public static void registerPythonDistributionOverride(Path distBaseExecDir) throws PythonDistributionRegistrationException {
        SecurityTools.requireInternalPermission();
        ValidationUtilV2.requireNonNull((Object)distBaseExecDir, (String)"distBaseDir");
        ArrayList<Path> absolutePythonExecutablePaths = new ArrayList<Path>();
        for (Path defaultExecutableRelativePath : PythonDistributionTools.getDefaultExecutableRelativePaths()) {
            absolutePythonExecutablePaths.add(distBaseExecDir.resolve(defaultExecutableRelativePath).toAbsolutePath());
        }
        try {
            PythonDistributionHandlerTools.unregisterPythonDistributionOverride();
        }
        catch (PythonDistributionNotRegisteredException e) {
            LogService.getRoot().log(Level.INFO, "PYTHON DISTRIBUTION OVERRIDE WAS NOT SET BEFORE");
        }
        PythonDistributionHandler.INSTANCE.registerDistribution(PythonDistributionTools.OVERRIDE_DIST, absolutePythonExecutablePaths, PythonDistributionMode.LOCAL);
    }

    public static void unregisterPythonDistributionOverride() throws PythonDistributionNotRegisteredException {
        PythonDistributionHandler.INSTANCE.unregisterDistribution(PythonDistributionTools.OVERRIDE_DIST);
    }

    static boolean registerDistributionForExtension(PythonExtension pyExt) throws PythonDistributionAlreadyRegisteredException {
        PythonDistribution pyDist = pyExt.getPythonDist();
        if (PythonDistributionHandler.INSTANCE.isDistributionRegistered(pyDist)) {
            throw new PythonDistributionAlreadyRegisteredException(pyDist);
        }
        try {
            boolean success = PythonDistributionHandlerTools.tryMiniforge(pyExt);
            if (!success) {
                success = PythonDistributionHandlerTools.tryLocal(pyExt);
            }
            if (!success) {
                throw new PythonDistributionRegistrationException("No valid distribution found for any distribution mode", pyDist);
            }
            LogService.getRoot().log(Level.FINE, () -> String.format("Python distribution for Python extension %s [%s] registered.", pyExt.getName(), pyExt.getVersion().getShortLongVersion()));
            return true;
        }
        catch (PythonDistributionAlreadyRegisteredException e) {
            LogService.getRoot().log(Level.FINE, () -> String.format("Python distribution %s requested by Python extension %s, already registered, skipping.", pyDist.toDistributionString(), pyExt.getName()));
            return false;
        }
        catch (PythonDistributionRegistrationException e) {
            LogService.getRoot().log(Level.WARNING, e, () -> String.format("Python distribution %s requested by Python extension %s: could not verify it, operators will not work.", pyDist.toDistributionString(), pyExt.getName()));
            return false;
        }
        catch (PythonDistributionInstallationException e) {
            LogService.getRoot().log(Level.WARNING, e, () -> String.format("Python distribution %s requested by Python extension %s: could not install it, operators will not work.", pyDist.toDistributionString(), pyExt.getName()));
            return false;
        }
    }

    private static boolean tryMiniforge(PythonExtension pyExt) throws PythonDistributionRegistrationException, PythonDistributionInstallationException {
        PythonDistributionInstaller installer;
        if (!PythonSDKSettings.isMiniforgeEnabled() || MiniforgeHandler.INSTANCE.getStatus() != MiniforgeStatus.READY || pyExt.getEnvDefinitionYml() == null) {
            return false;
        }
        if (!PythonSDKSettings.isAirGapped()) {
            LogService.getRoot().log(Level.INFO, () -> String.format("Python distribution for extension %s is handled by Miniforge (online mode)", pyExt.getName()));
            installer = PythonDistributionInstallerFactory.INSTANCE.createPythonMiniforgeDistributionInstaller(pyExt.getPythonDist(), pyExt.getEnvDefinitionYml(), pyExt.getPipRequirementsTxt(), false);
        } else {
            LogService.getRoot().log(Level.INFO, () -> String.format("Python distribution for extension %s is handled by Miniforge (air-gapped mode)", pyExt.getName()));
            installer = PythonDistributionInstallerFactory.INSTANCE.createPythonMiniforgeDistributionInstaller(pyExt.getPythonDist(), pyExt.getEnvDefinitionYml(), null, true);
        }
        if (!installer.isDistributionInstalled()) {
            if (PythonSDKSettings.isAirGapped() && !PythonDistributionTools.doesOfflineMiniforgeDistributionInstallerArchiveExist(pyExt.getPythonDist())) {
                LogService.getRoot().log(Level.WARNING, () -> String.format("Offline Miniforge distribution installation failed for extension %s: %s does not exist", pyExt.getName(), PythonDistributionTools.createPythonMiniforgeDistributionOfflineInstallerArchiveName(pyExt.getPythonDist(), true)));
                return false;
            }
            installer.installDistribution();
        }
        PythonDistributionHandler.INSTANCE.registerDistribution(pyExt.getPythonDist(), Collections.emptyList(), PythonDistributionMode.MINIFORGE);
        return true;
    }

    private static boolean tryLocal(PythonExtension pyExt) throws PythonDistributionInstallationException, PythonDistributionRegistrationException {
        Path distPath = PythonDistributionTools.resolveDistributionRootDir(pyExt.getPythonDist(), PythonDistributionMode.LOCAL);
        PythonDistributionInstaller installer = PythonDistributionInstallerFactory.INSTANCE.createPythonLocalDistributionExtractor(pyExt.getPythonDist(), distPath, null);
        if (PythonDistributionTools.doesDistributionArchiveExist(pyExt.getPythonDist()) && !installer.isDistributionInstalled()) {
            LogService.getRoot().log(Level.INFO, () -> String.format("Python distribution for extension %s is handled via archive", pyExt.getName()));
            installer.installDistribution();
        } else if (Files.exists(distPath, new LinkOption[0]) && Files.isDirectory(distPath, new LinkOption[0])) {
            LogService.getRoot().log(Level.INFO, () -> String.format("Python distribution for extension %s is handled via disk", pyExt.getName()));
        } else {
            return false;
        }
        PythonDistributionHandler.INSTANCE.registerDistribution(pyExt.getPythonDist(), Collections.emptyList(), PythonDistributionMode.LOCAL);
        return true;
    }

    private static /* synthetic */ PythonDistributionHandlerTools[] $values() {
        return new PythonDistributionHandlerTools[0];
    }

    static {
        $VALUES = PythonDistributionHandlerTools.$values();
    }
}

