/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.distribution;

import com.altair.ai.pel.distribution.DistributionCapability;
import com.altair.ai.pel.distribution.PythonDistribution;
import com.altair.ai.pel.distribution.PythonDistributionMode;
import com.rapidminer.gui.tools.VersionNumber;
import com.rapidminer.tools.ValidationUtilV2;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public final class PythonDistributionReference {
    private final PythonDistribution pyDist;
    private final Path executablePath;
    private final VersionNumber pyVersion;
    private final Set<DistributionCapability> supportedCapabilities;
    private final PythonDistributionMode distributionMode;

    PythonDistributionReference(PythonDistribution pyDist, Path executablePath, VersionNumber pyVersion, Set<DistributionCapability> supportedCapabilities, PythonDistributionMode distributionMode) {
        this.pyDist = (PythonDistribution)ValidationUtilV2.requireNonNull((Object)pyDist, (String)"pyDist");
        this.executablePath = (Path)ValidationUtilV2.requireNonNull((Object)executablePath, (String)"executablePath");
        this.pyVersion = (VersionNumber)ValidationUtilV2.requireNonNull((Object)pyVersion, (String)"pyVersion");
        this.supportedCapabilities = Collections.unmodifiableSet((Set)ValidationUtilV2.requireNonNull(supportedCapabilities, (String)"supportedCapabilities"));
        this.distributionMode = (PythonDistributionMode)((Object)ValidationUtilV2.requireNonNull((Object)((Object)distributionMode), (String)"distributionMode"));
    }

    public PythonDistribution getDist() {
        return this.pyDist;
    }

    public VersionNumber getPythonVersion() {
        return this.pyVersion;
    }

    public Set<DistributionCapability> getSupportedCapabilities() {
        return this.supportedCapabilities;
    }

    public PythonDistributionMode getDistributionMode() {
        return this.distributionMode;
    }

    public Path getExecutablePath() {
        return this.executablePath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PythonDistributionReference that = (PythonDistributionReference)o;
        return Objects.equals(this.pyDist, that.pyDist) && Objects.equals(this.executablePath, that.executablePath) && Objects.equals(this.pyVersion, that.pyVersion) && Objects.equals(this.supportedCapabilities, that.supportedCapabilities) && Objects.equals((Object)this.distributionMode, (Object)that.distributionMode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.pyDist, this.executablePath, this.pyVersion, this.supportedCapabilities, this.distributionMode});
    }

    public String toString() {
        return "PythonDistributionReference{distributionMode=" + this.distributionMode + ", pyDist=" + this.pyDist + ", executablePath=" + this.executablePath + ", pyVersion=" + this.pyVersion + ", supportedCapabilities=" + this.supportedCapabilities + "}";
    }
}

