/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.distribution.installer.archive;

import com.altair.ai.pel.distribution.PythonDistribution;
import com.altair.ai.pel.distribution.installer.archive.PythonDistributionInstaller;
import com.altair.ai.pel.python.exception.PythonDistributionInstallationException;
import com.altair.ai.pel.python.util.PythonDistributionTools;
import com.altair.ai.pel.util.FileTools;
import com.rapidminer.tools.FileUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;

public abstract class AbstractPythonDistributionArchiveExtractor
implements PythonDistributionInstaller {
    private final PythonDistribution dist;
    private final Path installationDirectory;

    protected AbstractPythonDistributionArchiveExtractor(PythonDistribution dist, Path installationDirectory) {
        this.dist = dist;
        this.installationDirectory = installationDirectory;
    }

    @Override
    public PythonDistribution getDistribution() {
        return this.dist;
    }

    @Override
    public boolean isDistributionInstalled() throws PythonDistributionInstallationException {
        try {
            if (!Files.isDirectory(this.installationDirectory, new LinkOption[0]) || FileUtils.isDirectoryEmpty((Path)this.installationDirectory)) {
                return false;
            }
        }
        catch (IOException e) {
            throw new PythonDistributionInstallationException("Failed to check Python distribution installation target folder", this.dist, e);
        }
        try {
            return PythonDistributionTools.verifyDistributionArchiveContents(this.dist, this.installationDirectory, this.getHashesToCheck());
        }
        catch (IOException e) {
            throw new PythonDistributionInstallationException("Failed to unpack Python distribution", this.dist, e);
        }
    }

    @Override
    public synchronized void installDistribution() throws PythonDistributionInstallationException {
        try {
            FileTools.ensureEmptyDirectoryExists(this.installationDirectory);
        }
        catch (IOException e) {
            throw new PythonDistributionInstallationException("Failed to prepare Python distribution installation folder", this.dist, e);
        }
        try {
            PythonDistributionTools.extractDistributionArchive(this.dist, this.installationDirectory);
        }
        catch (IOException e) {
            throw new PythonDistributionInstallationException("Failed to unpack Python distribution", this.dist, e);
        }
    }

    protected Path getInstallationDirectory() {
        return this.installationDirectory;
    }

    protected abstract Map<String, String> getHashesToCheck();
}

