/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.distribution.installer.archive;

import com.altair.ai.pel.distribution.PythonDistribution;
import com.altair.ai.pel.distribution.installer.archive.PythonDistributionInstaller;
import com.altair.ai.pel.miniforge.MiniforgeHandler;
import com.altair.ai.pel.python.exception.PythonDistributionInstallationException;
import com.altair.ai.pel.python.settings.PythonSDKSettings;
import com.altair.ai.pel.python.util.PythonDistributionTools;
import com.altair.ai.pel.util.ExternalProcess;
import com.altair.ai.pel.util.ExternalProcessBuilder;
import com.altair.ai.pel.util.ExternalProcessTools;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.SystemInfoUtilities;
import com.rapidminer.tools.TempFileTools;
import com.rapidminer.tools.ValidationUtilV2;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.logging.Level;
import org.apache.commons.io.FileUtils;

public abstract class AbstractPythonMiniforgeDistributionInstaller
implements PythonDistributionInstaller {
    private static final int DEFAULT_TIMEOUT = 30;
    protected final PythonDistribution dist;
    protected final String envDefinitionYml;

    protected AbstractPythonMiniforgeDistributionInstaller(PythonDistribution dist, String envDefinitionYml) {
        this.dist = (PythonDistribution)ValidationUtilV2.requireNonNull((Object)dist, (String)"dist");
        this.envDefinitionYml = (String)ValidationUtilV2.requireNonNull((Object)envDefinitionYml, (String)"envDefinitionYml");
    }

    @Override
    public PythonDistribution getDistribution() {
        return this.dist;
    }

    @Override
    public List<Path> getPythonExecutablePaths() {
        return Collections.singletonList(MiniforgeHandler.INSTANCE.getMiniforgeExecutable());
    }

    @Override
    public boolean isDistributionInstalled() throws PythonDistributionInstallationException {
        return this.isDistributionKnown() && this.isDistributionValid();
    }

    protected boolean isDistributionKnown() throws PythonDistributionInstallationException {
        ArrayList envList = new ArrayList();
        CountDownLatch latch = new CountDownLatch(2);
        this.runPythonDistributionInstallerCommand(envList::add, latch, "Miniforge (list envs)", 1, false, MiniforgeHandler.INSTANCE.getMiniforgeExecutable().toString(), "env", "list");
        try {
            if (!latch.await(1L, TimeUnit.SECONDS)) {
                throw new TimeoutException();
            }
        }
        catch (Exception e) {
            throw new PythonDistributionInstallationException("Failed to verify distribution via Miniforge (step: list envs)", this.dist, e);
        }
        return envList.stream().filter(entry -> entry.contains(PythonSDKSettings.getMiniforgeEnvDir().toString()) || entry.contains(PythonSDKSettings.getMiniforgeEnvDir().toAbsolutePath().toString())).map(entry -> entry.substring(0, entry.indexOf(32))).anyMatch(entry -> entry.equals(this.dist.toDistributionString()));
    }

    protected boolean isDistributionValid() throws PythonDistributionInstallationException {
        LogService.getRoot().log(Level.INFO, () -> String.format("Verifying if distribution %s is valid", this.dist.toDistributionString()));
        if (PythonSDKSettings.isMiniforgeEnvValidationDisabled()) {
            boolean exists = Files.exists(PythonSDKSettings.getMiniforgeEnvDir().resolve(this.dist.toDistributionString()), new LinkOption[0]);
            if (exists) {
                LogService.getRoot().log(Level.INFO, () -> String.format("Distribution %s is valid (directory does exist [Miniforge env validation disabled])", this.dist.toDistributionString()));
            } else {
                LogService.getRoot().log(Level.INFO, () -> String.format("Distribution %s is not valid (directory does not exist [Miniforge env validation disabled])", this.dist.toDistributionString()));
            }
            return exists;
        }
        Path tempEnvYml = PythonDistributionTools.createPythonMiniforgeDistributionDefinitionYmlPath(this.dist);
        TempFileTools.registerCleanup((Path)tempEnvYml);
        try {
            Files.writeString(tempEnvYml, (CharSequence)this.envDefinitionYml, new OpenOption[0]);
            this.runPythonDistributionInstallerCommand("Miniforge (validate env)", 1, false, MiniforgeHandler.INSTANCE.getMiniforgeExecutable().toString(), "compare", String.format("--name=%s", this.dist.toDistributionString()), tempEnvYml.toAbsolutePath().toString());
            LogService.getRoot().log(Level.INFO, () -> String.format("Distribution %s is up-to-date (compare with extension requirements succeeded)", this.dist.toDistributionString()));
            boolean bl = true;
            return bl;
        }
        catch (PythonDistributionInstallationException e) {
            LogService.getRoot().log(Level.INFO, () -> String.format("Distribution %s is not up-to-date (compare with extension requirements failed)", this.dist.toDistributionString()));
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            throw new PythonDistributionInstallationException("Failed to verify distribution via Miniforge (step: validate env)", this.dist, e.getCause());
        }
        finally {
            FileUtils.deleteQuietly((File)tempEnvYml.toFile());
        }
    }

    protected void removeDistribution() throws PythonDistributionInstallationException {
        LogService.getRoot().log(Level.INFO, () -> String.format("Removing %s distribution", this.dist.toDistributionString()));
        String logPrefix = "Miniforge (remove env)";
        this.runPythonDistributionInstallerCommand((String s) -> ExternalProcessTools.logShellOutput(logPrefix, Level.FINER, s), null, logPrefix, 10, false, MiniforgeHandler.INSTANCE.getMiniforgeExecutable().toString(), "remove", String.format("--name=%s", this.dist.toDistributionString()), "--all", "--yes");
    }

    protected void runPythonDistributionInstallerCommand(String logPrefix, boolean useShellScript, String ... commands) throws PythonDistributionInstallationException {
        this.runPythonDistributionInstallerCommand(logPrefix, 30, useShellScript, commands);
    }

    protected void runPythonDistributionInstallerCommand(String logPrefix, int timeout, boolean useShellScript, String ... commands) throws PythonDistributionInstallationException {
        this.runPythonDistributionInstallerCommand((String s) -> ExternalProcessTools.logShellOutput(logPrefix, Level.FINER, s), null, logPrefix, timeout, useShellScript, commands);
    }

    protected void runPythonDistributionInstallerCommand(Consumer<String> outputConsumer, CountDownLatch consumerLatch, String logPrefix, int timeout, boolean useShellScript, String ... commands) throws PythonDistributionInstallationException {
        try {
            Process process;
            int exitCode;
            String[] stringArray;
            Path shellScript = useShellScript ? PythonDistributionTools.formatPythonInvocationCommandsAndWriteToShellScript(List.of(commands), MiniforgeHandler.INSTANCE.getMiniforgeExecutable().getParent()) : null;
            ExternalProcessBuilder builder = ExternalProcessBuilder.newBuilder();
            ExternalProcessBuilder externalProcessBuilder = builder.workingDir(MiniforgeHandler.INSTANCE.getMiniforgeExecutable().getParent()).addEnv("CONDA_ENVS_PATH", PythonSDKSettings.getMiniforgeEnvDir().toAbsolutePath().toString()).addEnvUnlessOperatingSystem("HOME", () -> PythonSDKSettings.getMiniforgeFakeHomeDir().toAbsolutePath().toString(), SystemInfoUtilities.OperatingSystem.WINDOWS).outputConsumer(outputConsumer).errorConsumer(err -> ExternalProcessTools.logShellOutput(logPrefix, Level.WARNING, err)).awaitOutputStreamsClosing(consumerLatch).id(String.format("Installing %s via Miniforge (%s)", this.dist.toDistributionString(), logPrefix));
            if (shellScript != null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = shellScript.toAbsolutePath().toString();
            } else {
                stringArray = commands;
            }
            ExternalProcess result = externalProcessBuilder.command(stringArray).startProcess();
            if (shellScript != null) {
                result.getProcessFuture().whenComplete((p, t) -> FileUtils.deleteQuietly((File)shellScript.toFile()));
            }
            if ((exitCode = (process = result.getProcessFuture().get(timeout, TimeUnit.MINUTES)).exitValue()) != 0) {
                throw new PythonDistributionInstallationException(String.format("Failed to install distribution (%s), exitCode: %d", logPrefix, exitCode), this.dist);
            }
        }
        catch (PythonDistributionInstallationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PythonDistributionInstallationException(String.format("Failed to install distribution (%s)", logPrefix), this.dist, e);
        }
    }
}

