/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.distribution.installer.archive;

import com.altair.ai.pel.distribution.installer.archive.ArchiveExtractor;
import com.altair.ai.pel.distribution.installer.archive.ArchiveVerifier;
import com.altair.ai.pel.util.ExternalProcessBuilder;
import com.altair.ai.pel.util.ExternalProcessTools;
import com.rapidminer.tools.FileUtils;
import com.rapidminer.tools.LogService;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.Map;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.codec.digest.DigestUtils;

public enum ArchiveFormat {
    TAR("tar", ArchiveFormat::extractTar, ArchiveFormat::verifyTarContents),
    TAR_GZIP("tar.gz", ArchiveFormat::extractTar, ArchiveFormat::verifyTarContents),
    ZIP("zip", ArchiveFormat::extractZip, ArchiveFormat::verifyZipContents);

    private static final String SUFFIX_STATUS = ".status";
    private static final String SUFFIX_CONTENT = ".content";
    private static final String STATUS_SEPARATOR = "|";
    private final String suffix;
    private final ArchiveExtractor extractor;
    private final ArchiveVerifier verifier;

    private ArchiveFormat(String suffix, ArchiveExtractor extractor, ArchiveVerifier verifier) {
        this.suffix = suffix;
        this.extractor = extractor;
        this.verifier = verifier;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public ArchiveExtractor getExtractor() {
        return this.extractor;
    }

    public ArchiveVerifier getVerifier() {
        return this.verifier;
    }

    private static void extractZip(Path archive, Path target) throws IOException {
        try (InputStream stream = Files.newInputStream(archive, new OpenOption[0]);
             ZipInputStream zipStream = new ZipInputStream(new BufferedInputStream(stream));){
            FileUtils.extractZipStream((Path)target, (ZipInputStream)zipStream);
        }
        ArchiveFormat.createStatus(archive, target);
    }

    private static boolean verifyZipContents(Path archive, Path target, Map<String, String> hashesToCheck) throws IOException {
        if (ArchiveFormat.verifyStatusFile(archive, target)) {
            return true;
        }
        Path contentsFile = archive.getParent().resolve(archive.getFileName().toString() + SUFFIX_CONTENT);
        if (!Files.exists(contentsFile, new LinkOption[0])) {
            ArchiveFormat.createContentsForZip(archive, contentsFile);
        }
        return ArchiveFormat.verifyContentsTXT(contentsFile, target, hashesToCheck);
    }

    private static void createContentsForZip(Path archive, Path contentsFile) throws IOException {
        try (ZipInputStream zis = new ZipInputStream(new BufferedInputStream(Files.newInputStream(archive, new OpenOption[0])));
             BufferedWriter writer = new BufferedWriter(new FileWriter(contentsFile.toFile(), StandardCharsets.UTF_8));){
            ZipEntry entry;
            int counter = 0;
            while ((entry = zis.getNextEntry()) != null) {
                String name = entry.getName();
                if (counter > 0) {
                    writer.newLine();
                }
                writer.write(name);
                ++counter;
            }
        }
    }

    private static void extractTar(Path archive, Path target) throws IOException {
        ExternalProcessBuilder.newBuilder().errorConsumer(err -> ExternalProcessTools.logShellOutput("Archive extractor", Level.WARNING, err)).id(String.format("archive %s extractor", archive.getFileName().toString())).command("tar", "-x", "-f", archive.toAbsolutePath().toString(), "-C", target.toAbsolutePath().toString()).startProcess();
        ArchiveFormat.createStatus(archive, target);
    }

    private static boolean verifyTarContents(Path archive, Path target, Map<String, String> hashesToCheck) throws IOException {
        if (ArchiveFormat.verifyStatusFile(archive, target)) {
            return true;
        }
        Path contentsFile = archive.getParent().resolve(archive.getFileName() + SUFFIX_CONTENT);
        if (!Files.exists(contentsFile, new LinkOption[0])) {
            ArchiveFormat.createContentsForTar(archive, contentsFile);
        }
        return ArchiveFormat.verifyContentsTXT(contentsFile, target, hashesToCheck);
    }

    private static void createContentsForTar(Path archive, Path contentsFile) throws IOException {
        ExternalProcessBuilder.newBuilder().redirectOutputToFile(contentsFile).errorConsumer(err -> ExternalProcessTools.logShellOutput("Archive indexer", Level.WARNING, err)).id(String.format("archive %s content creator", archive.getFileName().toString())).command("tar", "-t", "-f", archive.toAbsolutePath().toString()).startProcess();
    }

    private static void createStatus(Path archive, Path targetDirectory) throws IOException {
        Path statusFile = archive.getParent().resolve(archive.getFileName() + SUFFIX_STATUS);
        if (!Files.exists(targetDirectory, new LinkOption[0]) || !Files.isDirectory(targetDirectory, new LinkOption[0])) {
            LogService.getRoot().log(Level.SEVERE, () -> String.format("Could not create %s for installation!", statusFile));
            return;
        }
        String statusContent = String.format("%d|%s", Files.size(targetDirectory), Files.getLastModifiedTime(targetDirectory, new LinkOption[0]).toInstant());
        Files.writeString(statusFile, (CharSequence)statusContent, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    private static boolean verifyStatusFile(Path archive, Path targetDirectory) throws IOException {
        Path statusFile = archive.getParent().resolve(archive.getFileName() + SUFFIX_STATUS);
        if (Files.exists(statusFile, new LinkOption[0])) {
            String statusContent = Files.readString(statusFile);
            String[] statusSplit = statusContent.split("\\|");
            if (statusSplit.length == 2) {
                try {
                    long expectedSize = Long.parseLong(statusSplit[0]);
                    Instant expectedLastModified = Instant.parse(statusSplit[1]);
                    long currentSize = Files.size(targetDirectory);
                    Instant currentLastModified = Files.getLastModifiedTime(targetDirectory, new LinkOption[0]).toInstant();
                    if (expectedSize == currentSize && expectedLastModified.equals(currentLastModified)) {
                        LogService.getRoot().log(Level.INFO, () -> "Status verification successful!");
                        return true;
                    }
                }
                catch (NumberFormatException | DateTimeParseException e) {
                    LogService.getRoot().log(Level.SEVERE, e, () -> String.format("Could not read %s for verification!", statusFile));
                }
            } else {
                LogService.getRoot().log(Level.SEVERE, () -> String.format("Could not read %s for verification, invalid content!", statusFile));
                org.apache.commons.io.FileUtils.deleteQuietly((File)statusFile.toFile());
            }
        }
        return false;
    }

    private static boolean verifyContentsTXT(Path contentsFile, Path target, Map<String, String> hashesToCheck) throws IOException {
        if (!Files.exists(contentsFile, new LinkOption[0])) {
            LogService.getRoot().log(Level.WARNING, () -> String.format("Could not verify contents via %s as it does not exist unexpectedly", contentsFile));
            return false;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(contentsFile, new OpenOption[0]), StandardCharsets.UTF_8));){
            String entry;
            while ((entry = reader.readLine()) != null) {
                String hashOnDisk;
                if (entry.startsWith("share/gdb")) continue;
                Path absPath = target.resolve(entry);
                if (!Files.exists(absPath, new LinkOption[0])) {
                    boolean bl = false;
                    return bl;
                }
                String fileName = entry;
                String hash = hashesToCheck.get(entry);
                if (hash == null || hash.equals(hashOnDisk = new DigestUtils(DigestUtils.getSha3_256Digest()).digestAsHex(absPath, new OpenOption[0]))) continue;
                LogService.getRoot().log(Level.WARNING, () -> String.format("Wrong hash %s detected for file %s, should have been %s, re-installation of Python distribution required", hashOnDisk, fileName, hash));
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }
}

