/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.distribution.installer.archive;

import com.altair.ai.pel.distribution.PythonDistribution;
import com.altair.ai.pel.distribution.installer.archive.AbstractPythonDistributionArchiveExtractor;
import com.rapidminer.tools.ValidationUtilV2;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class PythonDistributionArchiveExtractorWindows
extends AbstractPythonDistributionArchiveExtractor {
    private final List<Path> executablePaths;
    private final Map<String, String> hashesToCheck;

    PythonDistributionArchiveExtractorWindows(PythonDistribution dist, Path targetDirectory, List<Path> executableNames, Map<String, String> hashesToCheck) {
        super(dist, targetDirectory);
        ValidationUtilV2.requireNonEmptyList(executableNames, (String)"executableNames");
        this.hashesToCheck = hashesToCheck != null ? hashesToCheck : Collections.emptyMap();
        this.executablePaths = executableNames.stream().map(name -> this.getInstallationDirectory().resolve((Path)name)).filter(newPath -> newPath.startsWith(this.getInstallationDirectory())).collect(Collectors.toList());
    }

    @Override
    protected Map<String, String> getHashesToCheck() {
        return this.hashesToCheck;
    }

    @Override
    public List<Path> getPythonExecutablePaths() {
        return this.executablePaths;
    }
}

