/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.distribution.installer.archive;

import com.altair.ai.pel.distribution.PythonDistribution;
import com.altair.ai.pel.distribution.installer.archive.PythonDistributionArchiveExtractorWindows;
import com.altair.ai.pel.distribution.installer.archive.PythonDistributionInstaller;
import com.altair.ai.pel.distribution.installer.archive.PythonMiniforgeDistributionOfflineInstaller;
import com.altair.ai.pel.distribution.installer.archive.PythonMiniforgeDistributionOnlineInstaller;
import com.altair.ai.pel.python.util.PythonDistributionTools;
import java.nio.file.Path;
import java.util.Map;

public enum PythonDistributionInstallerFactory {
    INSTANCE;


    public PythonDistributionInstaller createPythonLocalDistributionExtractor(PythonDistribution dist, Path targetDirectory, Map<String, String> hashesToCheck) {
        return new PythonDistributionArchiveExtractorWindows(dist, targetDirectory, PythonDistributionTools.getDefaultExecutableRelativePaths(), hashesToCheck);
    }

    public PythonDistributionInstaller createPythonMiniforgeDistributionInstaller(PythonDistribution dist, String envDefinitionYml, String pipRequirementsTxt, boolean airgapped) {
        if (airgapped) {
            return new PythonMiniforgeDistributionOfflineInstaller(dist, envDefinitionYml);
        }
        return new PythonMiniforgeDistributionOnlineInstaller(dist, envDefinitionYml, pipRequirementsTxt);
    }
}

