/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.distribution.installer.archive;

import com.altair.ai.pel.distribution.PythonDistribution;
import com.altair.ai.pel.distribution.installer.archive.AbstractPythonMiniforgeDistributionInstaller;
import com.altair.ai.pel.miniforge.MiniforgeHandler;
import com.altair.ai.pel.python.exception.PythonDistributionInstallationException;
import com.altair.ai.pel.python.util.PythonDistributionTools;
import com.altair.ai.pel.util.FileTools;
import com.altair.ai.pel.util.OSTools;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class PythonMiniforgeDistributionOfflineInstaller
extends AbstractPythonMiniforgeDistributionInstaller {
    private static final String PIP_REQUIREMENTS_FILE = "pip_requirements.txt";
    private static final String CONDA_REQUIREMENTS_FILE = String.format("conda_requirements_%s.txt", OSTools.getPlatformName());
    protected final Path installerDirectory;

    public PythonMiniforgeDistributionOfflineInstaller(PythonDistribution dist, String envDefinitionYml) {
        super(dist, envDefinitionYml);
        this.installerDirectory = FileTools.getTempDirectory().resolve(PythonDistributionTools.createPythonMiniforgeDistributionOfflineInstallerArchiveName(dist, false));
    }

    @Override
    public void installDistribution() throws PythonDistributionInstallationException {
        try {
            FileTools.ensureEmptyDirectoryExists(this.installerDirectory);
        }
        catch (IOException e) {
            throw new PythonDistributionInstallationException("Failed to prepare Python distribution installation folder", this.dist, e);
        }
        try {
            PythonDistributionTools.extractMiniforgeDistributionOfflineInstallerArchive(this.dist, this.installerDirectory);
            if (this.isDistributionKnown()) {
                this.removeDistribution();
            }
            this.createDistribution();
            this.validateOfflineChannel();
            this.installCondaPackages();
            if (Files.exists(this.installerDirectory.resolve(PIP_REQUIREMENTS_FILE), new LinkOption[0])) {
                this.installPipPackages();
            }
        }
        catch (IOException e) {
            throw new PythonDistributionInstallationException("Failed to unpack Python distribution", this.dist, e);
        }
        catch (PythonDistributionInstallationException e) {
            this.removeDistribution();
            throw e;
        }
        catch (URISyntaxException e) {
            this.removeDistribution();
            throw new PythonDistributionInstallationException("Failed to create URI for offline channel", this.dist, e);
        }
        finally {
            FileUtils.deleteQuietly((File)this.installerDirectory.toFile());
        }
    }

    private void createDistribution() throws PythonDistributionInstallationException {
        this.runPythonDistributionInstallerCommand("Miniforge (create offline env - empty)", 1, false, MiniforgeHandler.INSTANCE.getMiniforgeExecutable().toString(), "create", String.format("--name=%s", this.dist.toDistributionString()), "--yes");
    }

    private void validateOfflineChannel() throws PythonDistributionInstallationException, URISyntaxException {
        String encodedChannelURI = new URI("file", null, this.installerDirectory.resolve("conda").toAbsolutePath().toString(), null).toASCIIString();
        this.runPythonDistributionInstallerCommand("Miniforge (create offline env - validate offline channel)", true, MiniforgeHandler.INSTANCE.getMiniforgeExecutable().toString(), "search", "rapidminer", "--channel", encodedChannelURI, "--override-channels", "--offline");
    }

    private void installCondaPackages() throws PythonDistributionInstallationException, URISyntaxException {
        String encodedChannelURI = new URI("file", null, this.installerDirectory.resolve("conda").toAbsolutePath().toString(), null).toASCIIString();
        this.runPythonDistributionInstallerCommand("Miniforge (create offline env - install conda pkgs)", true, MiniforgeHandler.INSTANCE.getMiniforgeExecutable().toString(), "install", String.format("--name=%s", this.dist.toDistributionString()), "--file", this.installerDirectory.resolve(CONDA_REQUIREMENTS_FILE).toAbsolutePath().toString(), "--channel", encodedChannelURI, "--override-channels", "--offline", "--yes");
    }

    private void installPipPackages() throws PythonDistributionInstallationException {
        List<String> commands = PythonDistributionTools.createPythonMiniforgeDistributionActivationCommands(this.dist.toDistributionString());
        commands.add("&&");
        commands.add("pip");
        commands.add("install");
        commands.add("--no-index");
        commands.add("--find-links");
        commands.add(this.installerDirectory.resolve("pip").toAbsolutePath().toString());
        commands.add("--requirement");
        commands.add(this.installerDirectory.resolve(PIP_REQUIREMENTS_FILE).toAbsolutePath().toString());
        this.runPythonDistributionInstallerCommand("Miniforge (create offline env - install pip pkgs)", true, commands.toArray(new String[0]));
    }
}

