/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.distribution.installer.archive;

import com.altair.ai.pel.distribution.PythonDistribution;
import com.altair.ai.pel.distribution.installer.archive.AbstractPythonMiniforgeDistributionInstaller;
import com.altair.ai.pel.miniforge.MiniforgeHandler;
import com.altair.ai.pel.python.exception.PythonDistributionInstallationException;
import com.altair.ai.pel.python.util.PythonDistributionTools;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.TempFileTools;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.logging.Level;
import org.apache.commons.io.FileUtils;

public class PythonMiniforgeDistributionOnlineInstaller
extends AbstractPythonMiniforgeDistributionInstaller {
    private final String pipRequirementsTxt;

    public PythonMiniforgeDistributionOnlineInstaller(PythonDistribution dist, String envDefinitionYml, String pipRequirementsTxt) {
        super(dist, envDefinitionYml);
        this.pipRequirementsTxt = pipRequirementsTxt;
    }

    @Override
    public void installDistribution() throws PythonDistributionInstallationException {
        Path tempEnvYml = PythonDistributionTools.createPythonMiniforgeDistributionDefinitionYmlPath(this.dist);
        TempFileTools.registerCleanup((Path)tempEnvYml);
        try {
            if (this.isDistributionKnown()) {
                this.removeDistribution();
            }
            LogService.getRoot().log(Level.INFO, () -> String.format("Installing %s distribution", this.dist.toDistributionString()));
            Files.writeString(tempEnvYml, (CharSequence)this.envDefinitionYml, new OpenOption[0]);
            this.runPythonDistributionInstallerCommand("Miniforge (create online env)", false, MiniforgeHandler.INSTANCE.getMiniforgeExecutable().toString(), "env", "create", String.format("--file=%s", tempEnvYml));
            if (this.pipRequirementsTxt != null) {
                this.installPipPackages();
            }
        }
        catch (IOException e) {
            throw new PythonDistributionInstallationException("Failed to install env via Miniforge (step: create env)", this.dist, e);
        }
        finally {
            FileUtils.deleteQuietly((File)tempEnvYml.toFile());
        }
    }

    private void installPipPackages() throws PythonDistributionInstallationException {
        Path pipRequirementsPath = PythonDistributionTools.createPythonMiniforgeDistributionPipRequirementsPath(this.dist);
        TempFileTools.registerCleanup((Path)pipRequirementsPath);
        try {
            Files.writeString(pipRequirementsPath, (CharSequence)this.pipRequirementsTxt, new OpenOption[0]);
            List<String> commands = PythonDistributionTools.createPythonMiniforgeDistributionActivationCommands(this.dist.toDistributionString());
            commands.add("&&");
            commands.add("pip");
            commands.add("install");
            commands.add("--requirement");
            commands.add(pipRequirementsPath.toString());
            this.runPythonDistributionInstallerCommand("Miniforge (create online env - install pip pkgs)", true, commands.toArray(new String[0]));
        }
        catch (IOException e) {
            throw new PythonDistributionInstallationException("Failed to install pip requirements (step: create env)", this.dist, e);
        }
        finally {
            FileUtils.deleteQuietly((File)pipRequirementsPath.toFile());
        }
    }
}

