/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.gui;

import com.altair.ai.pel.distribution.PythonDistribution;
import com.altair.ai.pel.distribution.PythonDistributionHandler;
import com.altair.ai.pel.distribution.PythonDistributionReference;
import com.altair.ai.pel.python.util.PythonDistributionTools;
import java.awt.Component;
import java.util.StringJoiner;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.border.Border;

class PythonDistributionListRenderer
extends DefaultListCellRenderer {
    private static final Border BORDER = BorderFactory.createEmptyBorder(5, 5, 5, 0);

    PythonDistributionListRenderer() {
    }

    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        PythonDistribution dist = (PythonDistribution)value;
        if (dist == null) {
            label.setText("-");
            return label;
        }
        PythonDistributionReference distRef = PythonDistributionHandler.INSTANCE.getDistributionReference(dist);
        StringJoiner supportedModes = new StringJoiner(", ");
        PythonDistributionTools.getSupportedCommunicationModes(distRef.getSupportedCapabilities()).forEach(mode -> supportedModes.add(mode.name()));
        label.setText(String.format("<html><div><span>&nbsp;%s&nbsp;</span><br/><span style=\"font-size:9px;color:gray\">&nbsp;Python:&nbsp;%s</span><br/><span style=\"font-size:9px;color:gray\">&nbsp;Supported:&nbsp;%s&nbsp;</span><br/><span style=\"font-size:9px;color:gray\">&nbsp;Source:&nbsp;%s</span></div></html>", new Object[]{dist.toDistributionString(), distRef.getPythonVersion().getShortLongVersion(), supportedModes, distRef.getDistributionMode()}));
        label.setBorder(BORDER);
        return label;
    }
}

