/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.gui;

import com.altair.ai.pel.distribution.PythonDistribution;
import com.altair.ai.pel.distribution.PythonDistributionHandler;
import com.altair.ai.pel.distribution.PythonDistributionReference;
import com.altair.ai.pel.distribution.PythonDistributionStatus;
import com.altair.ai.pel.gui.DistStatus;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.tools.I18N;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import org.apache.commons.lang3.StringUtils;

public class PythonDistributionStatusCellRenderer
extends DefaultTableCellRenderer {
    private static final Border BORDER = BorderFactory.createEmptyBorder(0, 10, 0, 5);
    private static final Map<PythonDistributionStatus, ImageIcon> IMG_CACHE = new HashMap<PythonDistributionStatus, ImageIcon>();
    private static final Map<PythonDistributionStatus, String> TIP_CACHE = new HashMap<PythonDistributionStatus, String>();

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value == null) {
            return comp;
        }
        JLabel label = (JLabel)comp;
        label.setIconTextGap(8);
        label.setBorder(BORDER);
        DistStatus status = (DistStatus)value;
        ImageIcon icon = IMG_CACHE.computeIfAbsent(status.getDistStatus(), distStatus -> SwingTools.createIcon((String)("16/" + I18N.getGUIMessage((String)String.format("gui.dialog.python_extensions.column.distribution.status.%s.icon", distStatus.name().toLowerCase()), (Object[])new Object[0]))));
        label.setIcon(icon);
        String tooltip = TIP_CACHE.computeIfAbsent(status.getDistStatus(), distStatus -> I18N.getGUIMessage((String)String.format("gui.dialog.python_extensions.column.distribution.status.%s.tip", distStatus.name().toLowerCase()), (Object[])new Object[0]));
        label.setToolTipText(tooltip);
        PythonDistribution dist = status.getPyDist();
        StringBuilder sb = new StringBuilder();
        sb.append("<html>").append("<div>");
        sb.append("<span>").append("&nbsp;").append(dist.toDistributionString()).append("&nbsp;").append("</span>");
        PythonDistributionReference distRef = PythonDistributionHandler.INSTANCE.getDistributionReference(dist);
        sb.append("<br/>");
        sb.append("<span style=\"font-size:9px;color:gray\">").append("&nbsp;").append("Python:").append("&nbsp;");
        sb.append(distRef != null ? distRef.getPythonVersion().getShortLongVersion() : "?");
        sb.append("</span>").append("<br/>");
        sb.append("<span style=\"font-size:9px;color:gray\">").append("&nbsp;");
        sb.append(I18N.getGUIMessage((String)"gui.dialog.python_extensions.column.distribution.source", (Object[])new Object[0]));
        sb.append(":&nbsp;");
        sb.append(distRef != null ? StringUtils.capitalize((String)distRef.getDistributionMode().name().toLowerCase()) : "?");
        sb.append("</span></div>").append("</html>");
        label.setText(sb.toString());
        return label;
    }
}

