/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.gui;

import com.altair.ai.pel.gui.PythonLicenseInfoEditorAndRenderer;
import com.altair.ai.pel.gui.PythonLicenseListRenderer;
import com.altair.ai.pel.loader.PythonExtension;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.LogService;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.AbstractCellEditor;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingWorker;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class PythonExtensionActionsEditorAndRenderer
extends AbstractCellEditor
implements TableCellEditor,
TableCellRenderer {
    private static final String LICENSES_FOLDER = "licenses/";
    private static final Dimension SIZE_SP_LIST = new Dimension(200, 700);
    private static final Dimension SIZE_SP_LIC = new Dimension(500, 700);
    private final DefaultTableCellRenderer defaultRenderer = new DefaultTableCellRenderer();
    private final JPanel panel = new JPanel(new GridBagLayout());
    private PythonExtension pyExt;

    public PythonExtensionActionsEditorAndRenderer(Window owner) {
        GridBagConstraints gbc = new GridBagConstraints();
        JButton showLicensesButton = new JButton((Action)this.createThirdPartyLicensesAction(owner));
        showLicensesButton.putClientProperty("button_highlight_white", Boolean.TRUE);
        showLicensesButton.setOpaque(false);
        showLicensesButton.setFocusPainted(false);
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.anchor = 10;
        gbc.insets = new Insets(0, 5, 0, 5);
        this.panel.add((Component)showLicensesButton, gbc);
        JButton showDependenciesButton = new JButton((Action)this.createDependenciesAction(owner));
        showDependenciesButton.putClientProperty("button_highlight_white", Boolean.TRUE);
        showDependenciesButton.setOpaque(false);
        showDependenciesButton.setFocusPainted(false);
        ++gbc.gridx;
        gbc.insets = new Insets(0, 5, 0, 5);
        this.panel.add((Component)showDependenciesButton, gbc);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component comp = this.defaultRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.pyExt = (PythonExtension)value;
        this.panel.setBackground(comp.getBackground());
        return this.panel;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        Component comp = this.defaultRenderer.getTableCellRendererComponent(table, value, true, false, row, column);
        this.pyExt = (PythonExtension)value;
        this.panel.setBackground(comp.getBackground());
        return this.panel;
    }

    @Override
    public Object getCellEditorValue() {
        return this.pyExt;
    }

    private ResourceAction createThirdPartyLicensesAction(final Window owner) {
        return new ResourceAction(false, "python_extensions.column.actions.show_licenses", new Object[0]){

            public void loggedActionPerformed(ActionEvent e) {
                JTextArea licArea = new JTextArea();
                licArea.setEditable(false);
                licArea.setLineWrap(true);
                JPanel parentPanel = new JPanel(new GridBagLayout());
                GridBagConstraints gbc = new GridBagConstraints();
                JList<String> thirdPartyLicensesList = new JList<String>();
                thirdPartyLicensesList.setMinimumSize(new Dimension(200, 300));
                thirdPartyLicensesList.setSelectionMode(0);
                thirdPartyLicensesList.setCellRenderer(new PythonLicenseListRenderer());
                thirdPartyLicensesList.addListSelectionListener(e1 -> {
                    if (e1.getValueIsAdjusting()) {
                        return;
                    }
                    String selVal = (String)thirdPartyLicensesList.getSelectedValue();
                    if (selVal != null) {
                        licArea.setText("...");
                        PythonExtensionActionsEditorAndRenderer.this.loadLicenseAsync(selVal, licText -> {
                            licArea.setText((String)licText);
                            licArea.setCaretPosition(0);
                        });
                    } else {
                        licArea.setText("");
                    }
                });
                ExtendedJScrollPane sp1 = new ExtendedJScrollPane(thirdPartyLicensesList);
                sp1.setBorder(null);
                sp1.setMinimumSize(SIZE_SP_LIST);
                sp1.setMaximumSize(SIZE_SP_LIST);
                gbc.gridy = 0;
                gbc.gridx = 0;
                gbc.weighty = 1.0;
                gbc.fill = 3;
                gbc.insets = new Insets(5, 5, 5, 5);
                parentPanel.add((Component)sp1, gbc);
                ExtendedJScrollPane sp2 = new ExtendedJScrollPane((Component)licArea);
                sp2.setBorder(null);
                sp2.setPreferredSize(SIZE_SP_LIC);
                ++gbc.gridx;
                gbc.weightx = 1.0;
                gbc.fill = 1;
                parentPanel.add((Component)sp2, gbc);
                PythonExtensionActionsEditorAndRenderer.this.loadLicenseListAsync(thirdPartyLicensesList, parentPanel, owner);
                PythonExtensionActionsEditorAndRenderer.this.stopCellEditing();
            }
        };
    }

    private ResourceAction createDependenciesAction(final Window owner) {
        return new ResourceAction(false, "python_extensions.column.actions.show_dependencies", new Object[0]){

            public void loggedActionPerformed(ActionEvent e) {
                JLabel depLabel = PythonExtensionActionsEditorAndRenderer.this.pyExt.getDependencies().isEmpty() ? new JLabel(I18N.getGUIMessage((String)"gui.dialog.message.python_extensions.column.actions.show_dependencies.empty", (Object[])new Object[0])) : new JLabel(PythonExtension.getDependenciesAsString(PythonExtensionActionsEditorAndRenderer.this.pyExt.getDependencies()));
                depLabel.setHorizontalAlignment(0);
                SwingTools.showMessageDialog((Window)owner, (String)"python_extensions.column.actions.show_dependencies", (JComponent)depLabel, (Object[])new Object[]{PythonExtensionActionsEditorAndRenderer.this.pyExt.getName()});
                PythonExtensionActionsEditorAndRenderer.this.stopCellEditing();
            }
        };
    }

    private void loadLicenseListAsync(final JList<String> thirdPartyLicensesList, final JPanel parentPanel, final Window owner) {
        SwingWorker<Vector<String>, Void> sw = new SwingWorker<Vector<String>, Void>(){

            @Override
            protected Vector<String> doInBackground() {
                return PythonExtensionActionsEditorAndRenderer.this.getThirdPartyLicenseFileNames();
            }

            @Override
            protected void done() {
                try {
                    JComponent comp;
                    final Vector vec = (Vector)this.get();
                    thirdPartyLicensesList.setModel(new AbstractListModel<String>(){

                        @Override
                        public int getSize() {
                            return vec.size();
                        }

                        @Override
                        public String getElementAt(int index) {
                            return (String)vec.elementAt(index);
                        }
                    });
                    if (!vec.isEmpty()) {
                        comp = parentPanel;
                    } else {
                        JLabel label = new JLabel(I18N.getGUIMessage((String)"gui.dialog.message.python_extensions.column.actions.show_licenses.empty", (Object[])new Object[0]));
                        label.setHorizontalAlignment(0);
                        comp = label;
                    }
                    SwingTools.showMessageDialog((Window)owner, (String)"python_extensions.column.actions.show_licenses", (JComponent)comp, (Object[])new Object[]{PythonExtensionActionsEditorAndRenderer.this.pyExt.getName()});
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
            }
        };
        sw.execute();
    }

    private void loadLicenseAsync(final String licenseEntryName, final Consumer<String> callback) {
        SwingWorker<String, Void> sw = new SwingWorker<String, Void>(){

            @Override
            protected String doInBackground() {
                return PythonLicenseInfoEditorAndRenderer.getLicenseAsString(PythonExtensionActionsEditorAndRenderer.this.pyExt.getSource(), PythonExtensionActionsEditorAndRenderer.LICENSES_FOLDER + licenseEntryName);
            }

            @Override
            protected void done() {
                try {
                    callback.accept((String)this.get());
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
            }
        };
        sw.execute();
    }

    private Vector<String> getThirdPartyLicenseFileNames() {
        Vector<String> vec = new Vector<String>();
        try (ZipFile zipFile = new ZipFile(this.pyExt.getSource().toFile());){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                if (!zipEntry.getName().startsWith(LICENSES_FOLDER) || zipEntry.isDirectory()) continue;
                vec.add(zipEntry.getName().substring(LICENSES_FOLDER.length()));
            }
        }
        catch (Exception e1) {
            LogService.getRoot().log(Level.WARNING, e1, () -> "Failed to load 3rd-party licenses");
        }
        return vec;
    }
}

