/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.gui;

import com.altair.ai.pel.gui.ExtStatus;
import com.altair.ai.pel.loader.ExtensionState;
import com.altair.ai.pel.loader.PythonExtension;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.tools.I18N;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;

public class PythonExtensionStatusCellRenderer
extends DefaultTableCellRenderer {
    private static final Border BORDER = BorderFactory.createEmptyBorder(0, 10, 0, 5);
    private static final Map<ExtStatus, ImageIcon> IMG_CACHE = new HashMap<ExtStatus, ImageIcon>();
    private static final Map<ExtStatus, String> LABEL_CACHE = new HashMap<ExtStatus, String>();
    private static final Map<ExtStatus, String> TIP_CACHE = new HashMap<ExtStatus, String>();

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value == null) {
            return comp;
        }
        JLabel label = (JLabel)comp;
        label.setIconTextGap(8);
        label.setBorder(BORDER);
        ExtStatus extStatus = (ExtStatus)value;
        ImageIcon icon = IMG_CACHE.computeIfAbsent(extStatus, status -> SwingTools.createIcon((String)("16/" + I18N.getGUIMessage((String)String.format("gui.dialog.python_extensions.column.status.%s.icon", status.getExtensionState().name().toLowerCase()), (Object[])new Object[0]))));
        label.setIcon(icon);
        String textLabel = LABEL_CACHE.computeIfAbsent(extStatus, status -> I18N.getGUIMessage((String)String.format("gui.dialog.python_extensions.column.status.%s.message", status.getExtensionState().name().toLowerCase()), (Object[])new Object[0]));
        label.setText(textLabel);
        PythonExtension pyExt = extStatus.getPyExt();
        boolean missingDeps = extStatus.getExtensionState() == ExtensionState.MISSING_DEPENDENCY;
        int i = 0;
        String[] arguments = new String[missingDeps ? 2 : 1];
        if (missingDeps) {
            arguments[i++] = PythonExtension.getDependenciesAsString(pyExt.getMissingDependencies());
        }
        arguments[i] = pyExt.isListingOperatorsAtRootLevel() ? "<br/><br/>" + I18N.getGUIMessage((String)"gui.dialog.python_extensions.column.status.ops_under_root.tip", (Object[])new Object[0]) : "";
        String tooltip = TIP_CACHE.computeIfAbsent(extStatus, status -> I18N.getGUIMessage((String)String.format("gui.dialog.python_extensions.column.status.%s.tip", status.getExtensionState().name().toLowerCase()), (Object[])arguments));
        label.setToolTipText(tooltip);
        return label;
    }
}

