/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.gui;

import com.altair.ai.pel.distribution.PythonDistributionHandler;
import com.altair.ai.pel.gui.DistStatus;
import com.altair.ai.pel.gui.ExtStatus;
import com.altair.ai.pel.gui.LicenseInfo;
import com.altair.ai.pel.loader.PythonExtension;
import com.altair.ai.pel.loader.PythonExtensionRegistry;
import com.altair.ai.pel.loader.event.PythonExtensionRegistryEventListener;
import com.altair.ai.pel.python.event.PythonDistributionHandlerEventListener;
import com.rapidminer.tools.I18N;
import javax.swing.table.AbstractTableModel;

class PythonExtensionTableModel
extends AbstractTableModel {
    static final int COLUMN_NAME = 0;
    static final int COLUMN_VERSION = 1;
    static final int COLUMN_STATUS = 2;
    static final int COLUMN_LICENSE = 3;
    static final int COLUMN_DISTRIBUTION = 4;
    static final int COLUMN_ACTIONS = 5;
    private final PythonExtensionRegistryEventListener extListener = (event, pyExt) -> {
        switch (event.getEventType()) {
            case PYTHON_EXTENSION_REGISTERED: {
                int index = PythonExtensionRegistry.INSTANCE.getAllExtensions().indexOf(pyExt);
                this.fireTableRowsInserted(index, index);
                break;
            }
            case PYTHON_EXTENSION_BROKEN: {
                int index = PythonExtensionRegistry.INSTANCE.getAllExtensions().indexOf(pyExt);
                this.fireTableRowsUpdated(index, index);
                break;
            }
            default: {
                this.fireTableRowsDeleted(0, PythonExtensionRegistry.INSTANCE.getAllExtensions().size());
            }
        }
    };
    private final PythonDistributionHandlerEventListener distListener;

    PythonExtensionTableModel() {
        PythonExtensionRegistry.INSTANCE.addEventListener(this.extListener);
        this.distListener = (event, pyDist) -> {
            switch (event.getEventType()) {
                default: 
            }
            this.fireTableDataChanged();
        };
        PythonDistributionHandler.INSTANCE.addEventListener(this.distListener);
    }

    @Override
    public int getColumnCount() {
        return 6;
    }

    @Override
    public int getRowCount() {
        return PythonExtensionRegistry.INSTANCE.getAllExtensions().size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex >= this.getRowCount()) {
            return null;
        }
        PythonExtension pyExt = PythonExtensionRegistry.INSTANCE.getAllExtensions().get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return pyExt.getName();
            }
            case 1: {
                return pyExt.getVersion().getShortLongVersion();
            }
            case 2: {
                return new ExtStatus(pyExt, pyExt.getCurrentState());
            }
            case 3: {
                return new LicenseInfo(pyExt);
            }
            case 4: {
                return new DistStatus(pyExt.getPythonDist(), PythonDistributionHandler.INSTANCE.getDistributionStatus(pyExt.getPythonDist()));
            }
            case 5: {
                return pyExt;
            }
        }
        throw new IllegalArgumentException("No such column: " + columnIndex);
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return I18N.getGUIMessage((String)"gui.dialog.python_extensions.column.name", (Object[])new Object[0]);
            }
            case 1: {
                return I18N.getGUIMessage((String)"gui.dialog.python_extensions.column.version", (Object[])new Object[0]);
            }
            case 2: {
                return I18N.getGUIMessage((String)"gui.dialog.python_extensions.column.status", (Object[])new Object[0]);
            }
            case 3: {
                return I18N.getGUIMessage((String)"gui.dialog.python_extensions.column.license", (Object[])new Object[0]);
            }
            case 4: {
                return I18N.getGUIMessage((String)"gui.dialog.python_extensions.column.distribution", (Object[])new Object[0]);
            }
            case 5: {
                return I18N.getGUIMessage((String)"gui.dialog.python_extensions.column.actions", (Object[])new Object[0]);
            }
        }
        throw new IllegalArgumentException("No such column: " + columnIndex);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 3: {
                return LicenseInfo.class;
            }
            case 2: {
                return ExtStatus.class;
            }
            case 4: {
                return DistStatus.class;
            }
            case 5: {
                return PythonExtension.class;
            }
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 3 || columnIndex == 5;
    }

    void cleanUp() {
        PythonExtensionRegistry.INSTANCE.removeEventListener(this.extListener);
        PythonDistributionHandler.INSTANCE.removeEventListener(this.distListener);
    }
}

