/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.gui;

import com.altair.ai.pel.distribution.PythonDistributionHandler;
import com.altair.ai.pel.gui.DistStatus;
import com.altair.ai.pel.gui.ExtStatus;
import com.altair.ai.pel.gui.LicenseInfo;
import com.altair.ai.pel.gui.PythonDistributionStatusCellRenderer;
import com.altair.ai.pel.gui.PythonExtensionActionsEditorAndRenderer;
import com.altair.ai.pel.gui.PythonExtensionCellRenderer;
import com.altair.ai.pel.gui.PythonExtensionStatusCellRenderer;
import com.altair.ai.pel.gui.PythonExtensionTableModel;
import com.altair.ai.pel.gui.PythonLicenseInfoEditorAndRenderer;
import com.altair.ai.pel.loader.ExtensionState;
import com.altair.ai.pel.loader.PythonExtension;
import com.altair.ai.pel.loader.PythonExtensionLoader;
import com.altair.ai.pel.loader.PythonExtensionRegistry;
import com.altair.ai.pel.server.local.ServerService;
import com.altair.ai.pel.util.FileTools;
import com.rapidminer.altair.license.StudioConstraintsManager;
import com.rapidminer.gui.ApplicationFrame;
import com.rapidminer.gui.MainFrame;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ProgressThread;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.dialogs.ButtonDialog;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.SecurityTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableRowSorter;

public class PythonExtensionsOverviewDialog
extends ButtonDialog {
    private static final AtomicReference<PythonExtensionsOverviewDialog> INSTANCE = new AtomicReference<Object>(null);
    private final JTable table;
    private final PythonExtensionTableModel tableModel;

    private PythonExtensionsOverviewDialog() {
        super((Window)ApplicationFrame.getApplicationFrame(), "python_extensions", Dialog.ModalityType.MODELESS, new Object[0]);
        if (INSTANCE.get() != null) {
            this.tableModel = null;
            this.table = null;
            return;
        }
        this.tableModel = new PythonExtensionTableModel();
        this.table = new JTable(this.tableModel);
        TableRowSorter<PythonExtensionTableModel> sorter = new TableRowSorter<PythonExtensionTableModel>(this.tableModel);
        sorter.setSortable(5, false);
        sorter.setMaxSortKeys(1);
        this.table.setRowSorter(sorter);
        this.table.setRowHeight(64);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setDefaultRenderer(String.class, new PythonExtensionCellRenderer());
        this.table.setDefaultRenderer(LicenseInfo.class, new PythonLicenseInfoEditorAndRenderer((Window)((Object)this)));
        this.table.setDefaultRenderer(DistStatus.class, new PythonDistributionStatusCellRenderer());
        this.table.setDefaultRenderer(ExtStatus.class, new PythonExtensionStatusCellRenderer());
        this.table.setDefaultRenderer(PythonExtension.class, new PythonExtensionActionsEditorAndRenderer((Window)((Object)this)));
        this.table.setDefaultEditor(LicenseInfo.class, new PythonLicenseInfoEditorAndRenderer((Window)((Object)this)));
        this.table.setDefaultEditor(PythonExtension.class, new PythonExtensionActionsEditorAndRenderer((Window)((Object)this)));
        this.table.getColumnModel().getColumn(0).setMinWidth(200);
        this.table.getColumnModel().getColumn(0).setMaxWidth(800);
        this.table.getColumnModel().getColumn(1).setMinWidth(100);
        this.table.getColumnModel().getColumn(1).setMaxWidth(200);
        this.table.getColumnModel().getColumn(2).setMinWidth(200);
        this.table.getColumnModel().getColumn(2).setMaxWidth(400);
        this.table.getColumnModel().getColumn(3).setMinWidth(150);
        this.table.getColumnModel().getColumn(3).setMaxWidth(300);
        this.table.getColumnModel().getColumn(4).setMinWidth(200);
        this.table.getColumnModel().getColumn(4).setMaxWidth(800);
        this.table.getColumnModel().getColumn(5).setMinWidth(125);
        this.table.getColumnModel().getColumn(5).setMaxWidth(125);
        ExtendedJScrollPane scrollPane = new ExtendedJScrollPane((Component)this.table);
        scrollPane.setBorder(null);
        JPanel main = new JPanel(new BorderLayout());
        main.add((Component)scrollPane, "Center");
        this.layoutDefault(main, 11, new AbstractButton[]{this.makeAddButton(), this.makeReloadButton(), this.makeCloseButton()});
    }

    public void setVisible(boolean b) {
        if (b) {
            PythonExtensionsOverviewDialog instance = INSTANCE.get();
            if (instance != null) {
                instance.requestFocus();
                return;
            }
            INSTANCE.set(this);
        }
        super.setVisible(b);
    }

    public void dispose() {
        if (this.tableModel != null) {
            this.tableModel.cleanUp();
        }
        INSTANCE.set(null);
        super.dispose();
    }

    private JButton makeAddButton() {
        return new JButton((Action)new ResourceAction("python_extensions.add_extension", new Object[0]){

            public void actionPerformed(ActionEvent e) {
                File selectedFile = SwingTools.chooseFile((Component)((Object)PythonExtensionsOverviewDialog.this), (String)"add_extension", null, (boolean)true, (String)".zip".substring(1), (String)"Python Extension");
                if (selectedFile == null) {
                    return;
                }
                Path sourcePath = selectedFile.toPath();
                if (!sourcePath.getFileName().toString().endsWith(".zip")) {
                    SwingTools.showVerySimpleErrorMessage((String)"python_extensions.add_extension_invalid_name", (Object[])new Object[]{".zip"});
                    return;
                }
                if (sourcePath.getParent().toAbsolutePath().equals(FileTools.getPythonExtensionLookupDirectory())) {
                    SwingTools.showVerySimpleErrorMessage((String)"python_extensions.add_extension_already_there", (Object[])new Object[]{".zip"});
                    return;
                }
                PythonExtensionsOverviewDialog.this.loadExtensionInPT(sourcePath, false);
            }
        });
    }

    private JButton makeReloadButton() {
        return new JButton((Action)new ResourceAction("python_extensions.reload_extensions", new Object[0]){

            public void actionPerformed(ActionEvent e) {
                PythonExtensionsOverviewDialog.this.table.getRowSorter().setSortKeys(null);
                PythonExtensionsOverviewDialog.this.table.getTableHeader().repaint();
                PythonExtensionsOverviewDialog.this.loadExtensionsInPT();
            }
        });
    }

    private void loadExtensionInPT(final Path sourcePath, final boolean overwriteConfirmed) {
        String i18nKey = "pel.load_extension";
        ProgressThread pt = new ProgressThread(i18nKey){

            public void run() {
                try {
                    Path targetPath = FileTools.getPythonExtensionLookupDirectory().resolve(sourcePath.getFileName());
                    CopyOption[] copyOptions = overwriteConfirmed ? new CopyOption[]{StandardCopyOption.REPLACE_EXISTING} : new CopyOption[]{};
                    Files.copy(sourcePath, targetPath, copyOptions);
                    PythonExtension pyExt = PythonExtensionLoader.loadExtensionFromFile(targetPath);
                    PythonExtensionRegistry.INSTANCE.registerExtension(pyExt, true);
                    if (pyExt.getCurrentState() == ExtensionState.NOT_READY) {
                        PythonDistributionHandler.INSTANCE.registerDistributionForExtension(pyExt);
                    }
                }
                catch (FileAlreadyExistsException e) {
                    int returnOption = SwingTools.showConfirmDialog((Window)((Object)PythonExtensionsOverviewDialog.this), (String)"python_extensions.add_extension_overwrite", (int)0, (Object[])new Object[0]);
                    if (returnOption == 0) {
                        PythonExtensionsOverviewDialog.this.loadExtensionInPT(sourcePath, true);
                    }
                }
                catch (Exception e) {
                    LogService.getRoot().log(Level.SEVERE, "Failed to load Python extension", e);
                }
            }
        };
        pt.addDependency(new String[]{i18nKey});
        pt.start();
    }

    private void loadExtensionsInPT() {
        String i18nKey = "pel.load_extensions";
        ProgressThread pt = new ProgressThread(i18nKey){

            public void run() {
                long activeServerCount = ServerService.INSTANCE.getActiveServerCount();
                if (activeServerCount > 0L) {
                    int returnOption = SwingTools.showConfirmDialog((Window)((Object)PythonExtensionsOverviewDialog.this), (String)"python_extensions.reload_extensions_confirmation", (int)2, (Object[])new Object[]{activeServerCount});
                    if (returnOption == 0) {
                        ServerService.INSTANCE.shutdownAllServers();
                    } else {
                        LogService.getRoot().log(Level.INFO, "Python extension reload cancelled");
                        return;
                    }
                }
                PythonExtensionLoader.loadExtensions(true, Optional.of(this.getProgressListener()), () -> (this).isCancelled());
            }
        };
        pt.addDependency(new String[]{i18nKey});
        pt.start();
    }

    public static void registerInExtensionsMenu(MainFrame mainframe) {
        SecurityTools.requireInternalPermission();
        mainframe.getExtensionsMenu().add((Action)PythonExtensionsOverviewDialog.createPythonExtensionsDialogAction());
    }

    private static ResourceAction createPythonExtensionsDialogAction() {
        return new ResourceAction("python_extensions", new Object[0]){

            protected void loggedActionPerformed(ActionEvent e) {
                if (StudioConstraintsManager.isRapidMinerLicense()) {
                    SwingTools.showMessageDialog((String)"python_extensions.missing_altair_license", (Object[])new Object[0]);
                } else {
                    new PythonExtensionsOverviewDialog().setVisible(true);
                }
            }
        };
    }
}

