/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.gui;

import com.altair.ai.pel.gui.PythonIOORendererPanel;
import com.altair.ai.pel.operator.SerializablePythonIOObject;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.rapidminer.gui.renderer.AbstractRenderer;
import com.rapidminer.gui.renderer.DefaultReadable;
import com.rapidminer.gui.renderer.DefaultTextRenderer;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.report.Reportable;
import java.awt.Component;
import java.util.Iterator;
import java.util.Map;

public class PythonIOORenderer
extends AbstractRenderer {
    private static final String ARRAY_TEMPLATE = "<label class='json_object array_style'><input type='checkbox'/><span class='arrow'></span><span class='key'>%s</span></label><br>";
    private static final String OBJECT_TEMPLATE = "<label class='json_object'><input type='checkbox'/><span class='arrow'></span><span class='key'>%s</span></label><br>";
    private static final String PRIMITIVE_TEMPLATE = "<span class='key'>%s</span><span class='value'>%s</span>";
    private static final String ITEM_TEMPLATE = "<div class='item'>%s</div>";
    private static final int MAX_JSON_LENGTH = 1250000;

    public String getName() {
        return "python_ioo_renderer";
    }

    public Component getVisualizationComponent(Object o, IOContainer ioContainer) {
        if (!(o instanceof SerializablePythonIOObject)) {
            return null;
        }
        SerializablePythonIOObject pythonIOObject = (SerializablePythonIOObject)o;
        if (pythonIOObject.getJson().length() > 1250000) {
            return new DefaultTextRenderer().getVisualizationComponent((Object)pythonIOObject, ioContainer);
        }
        return new PythonIOORendererPanel(PythonIOORenderer.jsonToHtml(pythonIOObject.getName(), pythonIOObject.getJson()));
    }

    public Reportable createReportable(Object o, IOContainer ioContainer, int i, int i1) {
        if (!(o instanceof SerializablePythonIOObject)) {
            return null;
        }
        return new DefaultReadable(((SerializablePythonIOObject)o).toResultString());
    }

    private static String jsonToHtml(String rootKey, String json) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode jsonNode = mapper.readTree(json);
            return String.format("<div>%s</div>", PythonIOORenderer.nodeToHtml(rootKey, jsonNode));
        }
        catch (JsonProcessingException e) {
            return "<div>Error reading json</div>";
        }
    }

    private static String nodeToHtml(String key, JsonNode jsonNode) {
        switch (jsonNode.getNodeType()) {
            case ARRAY: {
                return PythonIOORenderer.arrayNodeToHtml(key, jsonNode);
            }
            case OBJECT: {
                return PythonIOORenderer.objectNodeToHtml(key, jsonNode);
            }
            case STRING: {
                return String.format(PRIMITIVE_TEMPLATE, key, "&quot;" + jsonNode.asText() + "&quot;");
            }
        }
        return String.format(PRIMITIVE_TEMPLATE, key, jsonNode.asText());
    }

    private static String objectNodeToHtml(String key, JsonNode jsonNode) {
        StringBuilder result = new StringBuilder(String.format(OBJECT_TEMPLATE, key));
        Iterator it = jsonNode.fields();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            result.append(String.format(ITEM_TEMPLATE, PythonIOORenderer.nodeToHtml((String)entry.getKey(), (JsonNode)entry.getValue())));
        }
        return result.toString();
    }

    private static String arrayNodeToHtml(String key, JsonNode jsonNode) {
        StringBuilder result = new StringBuilder(String.format(ARRAY_TEMPLATE, key));
        int i = 0;
        for (JsonNode child : jsonNode) {
            result.append(String.format(ITEM_TEMPLATE, PythonIOORenderer.nodeToHtml(String.valueOf(i), child)));
            ++i;
        }
        return result.toString();
    }
}

