/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.gui;

import com.altair.ai.pel.gui.LicenseInfo;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.LogService;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class PythonLicenseInfoEditorAndRenderer
extends AbstractCellEditor
implements TableCellEditor,
TableCellRenderer {
    private final DefaultTableCellRenderer defaultRenderer = new DefaultTableCellRenderer();
    private final JPanel panel = new JPanel(new GridBagLayout());
    private final JLabel licLabel;
    private final JButton showLicenseButton;
    private LicenseInfo licInfo;

    public PythonLicenseInfoEditorAndRenderer(Window owner) {
        GridBagConstraints gbc = new GridBagConstraints();
        this.licLabel = new JLabel();
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.anchor = 10;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.panel.add((Component)this.licLabel, gbc);
        this.showLicenseButton = new JButton((Action)this.createAction(owner));
        this.showLicenseButton.putClientProperty("button_highlight_white", Boolean.TRUE);
        this.showLicenseButton.setOpaque(false);
        this.showLicenseButton.setFocusPainted(false);
        this.showLicenseButton.setVisible(false);
        ++gbc.gridy;
        gbc.anchor = 10;
        gbc.insets = new Insets(0, 5, 5, 5);
        this.panel.add((Component)this.showLicenseButton, gbc);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component comp = this.defaultRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value == null) {
            return comp;
        }
        this.licInfo = (LicenseInfo)value;
        this.panel.setBackground(comp.getBackground());
        String licenseName = this.licInfo.getLicenseName();
        this.showLicenseButton.setVisible(licenseName != null);
        this.licLabel.setText(licenseName != null ? licenseName : "-");
        this.licLabel.setToolTipText(licenseName);
        return this.panel;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        Component comp = this.defaultRenderer.getTableCellRendererComponent(table, value, true, false, row, column);
        if (value == null) {
            return comp;
        }
        this.licInfo = (LicenseInfo)value;
        this.panel.setBackground(comp.getBackground());
        String licenseName = this.licInfo.getLicenseName();
        this.showLicenseButton.setVisible(licenseName != null);
        this.licLabel.setText(licenseName != null ? licenseName : "-");
        this.licLabel.setToolTipText(licenseName);
        return this.panel;
    }

    @Override
    public Object getCellEditorValue() {
        return this.licInfo;
    }

    private ResourceAction createAction(final Window owner) {
        return new ResourceAction(true, "python_extensions.column.license.show_license", new Object[0]){

            public void loggedActionPerformed(ActionEvent e) {
                JTextArea licArea = new JTextArea(PythonLicenseInfoEditorAndRenderer.getLicenseAsString(PythonLicenseInfoEditorAndRenderer.this.licInfo.getPyExt().getSource(), "LICENSE"));
                licArea.setEditable(false);
                licArea.setLineWrap(true);
                ExtendedJScrollPane sp = new ExtendedJScrollPane((Component)licArea);
                sp.setBorder(null);
                sp.setPreferredSize(new Dimension(500, 700));
                SwingTools.showMessageDialog((Window)owner, (String)"python_extensions.column.license.show_license", (JComponent)sp, (Object[])new Object[]{PythonLicenseInfoEditorAndRenderer.this.licInfo.getPyExt().getName(), PythonLicenseInfoEditorAndRenderer.this.licInfo.getLicenseName()});
                PythonLicenseInfoEditorAndRenderer.this.stopCellEditing();
            }
        };
    }

    static String getLicenseAsString(Path zipPath, String entryName) {
        String licString;
        try (ZipFile zipFile = new ZipFile(zipPath.toFile());){
            ZipEntry licEntry = zipFile.getEntry(entryName);
            licString = licEntry != null ? new String(zipFile.getInputStream(licEntry).readAllBytes()) : I18N.getGUIMessage((String)"gui.dialog.python_extensions.column.license.show_license.missing", (Object[])new Object[]{entryName});
        }
        catch (Exception e1) {
            LogService.getRoot().log(Level.WARNING, e1, () -> String.format("Failed to load %s license", entryName));
            licString = I18N.getGUIMessage((String)"gui.dialog.python_extensions.column.license.show_license.error", (Object[])new Object[]{entryName, e1.getMessage()});
        }
        return licString;
    }
}

