/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.gui;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.border.Border;

class PythonLicenseListRenderer
extends DefaultListCellRenderer {
    private static final Dimension MINIMUM_SIZE = new Dimension(75, 48);
    private static final Dimension PREFERRED_SIZE = new Dimension(150, 48);
    private static final Border BORDER = BorderFactory.createEmptyBorder(5, 5, 5, 5);
    private static final String SUFFIX_LICENSE = ".license";
    private static final String SUFFIX_LICENSE_TXT = ".license.txt";
    private static final String SUFFIX_TXT = ".txt";

    PythonLicenseListRenderer() {
    }

    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        String licEntryName = (String)value;
        String[] split = licEntryName.split("\\.", 2);
        String dependency = licEntryName;
        String licType = "";
        if (split.length > 1) {
            dependency = split[0];
            String remainder = split[1];
            if (remainder.endsWith(SUFFIX_LICENSE)) {
                licType = remainder.substring(0, remainder.length() - SUFFIX_LICENSE.length());
            } else if (remainder.endsWith(SUFFIX_LICENSE_TXT)) {
                licType = remainder.substring(0, remainder.length() - SUFFIX_LICENSE_TXT.length());
            } else if (remainder.endsWith(SUFFIX_TXT)) {
                licType = remainder.substring(0, remainder.length() - SUFFIX_TXT.length());
            }
        }
        label.setText(String.format("<html><div><span><strong>&nbsp;%s&nbsp;</strong></span><br/><span style=\"font-size:9px;color:gray\">&nbsp;%s&nbsp;</span></div></html>", dependency, licType));
        label.setToolTipText(dependency);
        label.setBorder(BORDER);
        label.setMinimumSize(MINIMUM_SIZE);
        label.setPreferredSize(PREFERRED_SIZE);
        return label;
    }
}

