/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.gui;

import com.altair.ai.pel.distribution.PythonDistribution;
import com.altair.ai.pel.distribution.PythonDistributionHandler;
import com.altair.ai.pel.distribution.PythonDistributionHandlerTools;
import com.altair.ai.pel.gui.PythonDistributionListRenderer;
import com.altair.ai.pel.miniforge.MiniforgeConfigModifier;
import com.altair.ai.pel.miniforge.MiniforgeHandler;
import com.altair.ai.pel.miniforge.MiniforgeStatus;
import com.altair.ai.pel.python.bridge.CommunicationMode;
import com.altair.ai.pel.python.bridge.DataExchangeMode;
import com.altair.ai.pel.python.bridge.PythonBridge;
import com.altair.ai.pel.python.bridge.PythonBridgeStatus;
import com.altair.ai.pel.python.event.PythonDistributionHandlerEventListener;
import com.altair.ai.pel.python.exception.MiniforgeException;
import com.altair.ai.pel.python.exception.PythonDistributionException;
import com.altair.ai.pel.python.exception.PythonDistributionNotRegisteredException;
import com.altair.ai.pel.python.exception.PythonDistributionRegistrationException;
import com.altair.ai.pel.python.exception.PythonSDKException;
import com.altair.ai.pel.python.exception.PythonScriptProcessingException;
import com.altair.ai.pel.python.exception.PythonScriptRunnerException;
import com.altair.ai.pel.python.listener.MiniforgeListener;
import com.altair.ai.pel.python.listener.PythonBridgeListener;
import com.altair.ai.pel.python.script.PythonCodeScript;
import com.altair.ai.pel.python.script.result.PythonScriptResult;
import com.altair.ai.pel.python.script.result.SubmissionResult;
import com.altair.ai.pel.python.settings.PythonDebugMode;
import com.altair.ai.pel.python.settings.PythonSDKSettings;
import com.altair.ai.pel.util.ExternalProcess;
import com.altair.ai.pel.util.ExternalProcessBuilder;
import com.altair.ai.pel.util.ExternalProcessTools;
import com.rapidminer.altair.license.StudioConstraintsManager;
import com.rapidminer.gui.ApplicationFrame;
import com.rapidminer.gui.MainFrame;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.flow.processrendering.draw.ProcessDrawer;
import com.rapidminer.gui.look.Colors;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ProgressThread;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.components.LinkLocalButton;
import com.rapidminer.gui.tools.dialogs.ButtonDialog;
import com.rapidminer.settings.Settings;
import com.rapidminer.tools.FontTools;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.SecurityTools;
import com.rapidminer.tools.SystemInfoUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

public final class PythonSDKDebugDialog
extends ButtonDialog {
    private static final String TOGGLE_ACTION_I18N_KEY = "python_bundle_debug.toggle_debug_mode";
    private static final String EXAMPLE_SCRIPT;
    private static final int ELEMENT_HEIGHT = 20;
    private static final int ELEMENT_WIDTH = 125;
    private static final Dimension BRIDGE_STATUS_DIMENSION;
    private static final Dimension MINIFORGE_STATUS_DIMENSION;
    private static final Font OPEN_SANS;
    private static final int MAX_HISTORY = 10;
    private static final List<String> SCRIPT_HISTORY;
    private final JComboBox<PythonDistribution> distributionBox;
    private final DefaultComboBoxModel<PythonDistribution> model;
    private final RSyntaxTextArea scriptArea;
    private final ResourceAction submitAction;
    private final JTabbedPane resultTabbedPane;
    private final JTextArea resultAreaOut;
    private final JTextArea resultAreaErr;
    private final JLabel infoLabel;
    private final JPopupMenu historyMenu = new JPopupMenu();
    private final LinkLocalButton historyPopupButton;
    private final PythonBridgeListener bridgeListener;
    private final PythonDistributionHandlerEventListener distributionListener;
    private final MiniforgeListener miniforgeListener;
    private volatile PythonBridgeStatus bridgeStatus;
    private volatile MiniforgeStatus miniforgeStatus;

    private PythonSDKDebugDialog() {
        super((Window)ApplicationFrame.getApplicationFrame(), "python_bundle_debug_dialog", Dialog.ModalityType.MODELESS, new Object[0]);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.insets = new Insets(5, 5, 5, 5);
        JPanel mainPanel = new JPanel(new GridBagLayout());
        final JButton condaChannelLoginButton = new JButton(SwingTools.createIcon((String)"16/log_in.png"));
        final JButton condaChannelLogoutButton = new JButton(SwingTools.createIcon((String)"16/log_out.png"));
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.scriptArea = new RSyntaxTextArea(new RSyntaxDocument("text/python"), "", 8, 10);
        this.scriptArea.setText(EXAMPLE_SCRIPT);
        ExtendedJScrollPane scrollPane = new ExtendedJScrollPane((Component)this.scriptArea);
        scrollPane.setBorder(null);
        mainPanel.add((Component)scrollPane, gbc);
        JPanel submitPanel = new JPanel(new FlowLayout(2));
        ++gbc.gridy;
        gbc.anchor = 13;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        this.submitAction = new ResourceAction("python_bundle_debug.submit", new Object[0]){

            public void loggedActionPerformed(ActionEvent e) {
                PythonSDKDebugDialog.this.scriptArea.setEnabled(false);
                PythonSDKDebugDialog.this.submitAction.setEnabled(false);
                String script = PythonSDKDebugDialog.this.scriptArea.getText().trim();
                if (script.isEmpty()) {
                    PythonSDKDebugDialog.this.scriptArea.setEnabled(true);
                    PythonSDKDebugDialog.this.submitAction.setEnabled(true);
                    return;
                }
                PythonSDKDebugDialog.this.infoLabel.setForeground(Colors.TEXT_FOREGROUND);
                PythonSDKDebugDialog.this.infoLabel.setText(" ");
                PythonSDKDebugDialog.this.resultAreaOut.setText("");
                PythonSDKDebugDialog.this.resultAreaErr.setText("");
                PythonSDKDebugDialog.this.addToScriptHistory(script);
                PythonSDKDebugDialog.this.historyPopupButton.setEnabled(true);
                try {
                    Consumer<String> logConsumer = l -> SwingUtilities.invokeLater(() -> PythonSDKDebugDialog.this.resultAreaOut.append(l + "\n"));
                    Consumer<String> errConsumer = l -> SwingUtilities.invokeLater(() -> PythonSDKDebugDialog.this.resultAreaErr.append(l + "\n"));
                    PythonSDKDebugDialog.this.awaitResult(PythonSDKDebugDialog.submitScript(PythonSDKDebugDialog.this.distributionBox.getItemAt(PythonSDKDebugDialog.this.distributionBox.getSelectedIndex()), script, logConsumer, errConsumer).getSubmissionFuture());
                }
                catch (PythonDistributionException | PythonScriptRunnerException ex) {
                    LogService.getRoot().log(Level.WARNING, "Failed to submit script", ex);
                    PythonSDKDebugDialog.this.infoLabel.setForeground(Color.RED);
                    PythonSDKDebugDialog.this.infoLabel.setText(ex.getMessage());
                    PythonSDKDebugDialog.this.scriptArea.setEnabled(true);
                    PythonSDKDebugDialog.this.submitAction.setEnabled(true);
                }
            }
        };
        JButton submitButton = new JButton((Action)this.submitAction);
        this.scriptArea.getInputMap().put(KeyStroke.getKeyStroke(10, 128), "run");
        this.scriptArea.getActionMap().put("run", (Action)this.submitAction);
        this.historyPopupButton = new LinkLocalButton((Action)new ResourceAction("python_bundle_debug.show_history", new Object[]{10}){

            public void loggedActionPerformed(ActionEvent e) {
                PythonSDKDebugDialog.this.historyMenu.removeAll();
                SCRIPT_HISTORY.forEach(script -> {
                    JMenuItem histItem = new JMenuItem((String)script);
                    histItem.addActionListener(event -> PythonSDKDebugDialog.this.scriptArea.setText(script));
                    PythonSDKDebugDialog.this.historyMenu.add(histItem);
                });
                if (!PythonSDKDebugDialog.this.historyMenu.isVisible() && !SCRIPT_HISTORY.isEmpty()) {
                    PythonSDKDebugDialog.this.historyMenu.show((Component)PythonSDKDebugDialog.this.historyPopupButton, 0, PythonSDKDebugDialog.this.historyPopupButton.getHeight() - 1);
                    PythonSDKDebugDialog.this.historyMenu.requestFocusInWindow();
                }
            }
        });
        this.historyPopupButton.setEnabled(!SCRIPT_HISTORY.isEmpty());
        String distTT = "Select the distribution to use for the test script in this dialog.";
        JLabel distLabel = new JLabel("Select Distribution:");
        distLabel.setToolTipText(distTT);
        this.model = new DefaultComboBoxModel();
        this.distributionBox = new JComboBox<PythonDistribution>(this.model);
        this.distributionBox.setRenderer(new PythonDistributionListRenderer());
        this.distributionBox.setToolTipText(distTT);
        submitPanel.add(distLabel);
        submitPanel.add(this.distributionBox);
        submitPanel.add((Component)this.historyPopupButton);
        submitPanel.add(submitButton);
        mainPanel.add((Component)submitPanel, gbc);
        ++gbc.gridy;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        this.infoLabel = new JLabel(" ");
        mainPanel.add((Component)this.infoLabel, gbc);
        this.resultAreaOut = new JTextArea(1, 10);
        this.resultAreaOut.setEditable(false);
        this.resultAreaOut.setFont(new Font("Consolas", 0, 12));
        ExtendedJScrollPane scrollPaneOut = new ExtendedJScrollPane((Component)this.resultAreaOut);
        scrollPaneOut.setBorder(null);
        this.resultAreaErr = new JTextArea(1, 10);
        this.resultAreaErr.setEditable(false);
        this.resultAreaErr.setFont(new Font("Consolas", 0, 12));
        this.resultAreaErr.setForeground(Color.RED);
        ExtendedJScrollPane scrollPaneErr = new ExtendedJScrollPane((Component)this.resultAreaErr);
        scrollPaneErr.setBorder(null);
        this.resultTabbedPane = new JTabbedPane(3);
        this.resultTabbedPane.addTab("Standard Out", (Component)scrollPaneOut);
        this.resultTabbedPane.addTab("Standard Err", (Component)scrollPaneErr);
        ++gbc.gridy;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        mainPanel.add((Component)this.resultTabbedPane, gbc);
        JPanel statusPanel = new JPanel(new GridBagLayout());
        GridBagConstraints sGbc = new GridBagConstraints();
        JLabel bridgeStatusLabel = new JLabel("Python Bridge Status:");
        sGbc.gridy = 0;
        sGbc.gridx = 0;
        sGbc.insets = new Insets(5, 0, 5, 0);
        sGbc.anchor = 18;
        statusPanel.add((Component)bridgeStatusLabel, sGbc);
        final JPanel bridgePaintPanel = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2 = (Graphics2D)g.create();
                g2.setRenderingHints(ProcessDrawer.HI_QUALITY_HINTS);
                int counter = 0;
                for (PythonBridgeStatus status : PythonBridgeStatus.values()) {
                    if (status == PythonSDKDebugDialog.this.bridgeStatus) {
                        Paint prevPaint = g2.getPaint();
                        g2.setPaint(PythonSDKDebugDialog.getBridgeStatusPaint(status));
                        g2.fillRect(0, counter * 20, this.getWidth(), 20);
                        g2.setPaint(prevPaint);
                    }
                    g2.setFont(OPEN_SANS);
                    String name = status.name();
                    g2.drawString(name, 5, 15 + counter * 20);
                    ++counter;
                }
                g2.dispose();
            }
        };
        bridgePaintPanel.setMinimumSize(BRIDGE_STATUS_DIMENSION);
        bridgePaintPanel.setPreferredSize(BRIDGE_STATUS_DIMENSION);
        ++sGbc.gridy;
        sGbc.weightx = 1.0;
        sGbc.weighty = 1.0;
        sGbc.fill = 1;
        statusPanel.add((Component)bridgePaintPanel, sGbc);
        JLabel miniforgeStatusLabel = new JLabel("Miniforge Status:");
        ++sGbc.gridy;
        sGbc.weightx = 0.0;
        sGbc.weighty = 0.0;
        sGbc.fill = 0;
        sGbc.insets = new Insets(15, 0, 5, 0);
        statusPanel.add((Component)miniforgeStatusLabel, sGbc);
        JPanel miniforgePaintPanel = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2 = (Graphics2D)g.create();
                g2.setRenderingHints(ProcessDrawer.HI_QUALITY_HINTS);
                int counter = 0;
                for (MiniforgeStatus status : MiniforgeStatus.values()) {
                    if (status == PythonSDKDebugDialog.this.miniforgeStatus) {
                        Paint prevPaint = g2.getPaint();
                        g2.setPaint(PythonSDKDebugDialog.getMiniforgeStatusPaint(status));
                        g2.fillRect(0, counter * 20, this.getWidth(), 20);
                        g2.setPaint(prevPaint);
                    }
                    g2.setFont(OPEN_SANS);
                    String name = status.name();
                    g2.drawString(name, 5, 15 + counter * 20);
                    ++counter;
                }
                g2.dispose();
            }
        };
        miniforgePaintPanel.setMinimumSize(MINIFORGE_STATUS_DIMENSION);
        miniforgePaintPanel.setPreferredSize(MINIFORGE_STATUS_DIMENSION);
        ++sGbc.gridy;
        sGbc.weightx = 1.0;
        sGbc.weighty = 1.0;
        sGbc.fill = 1;
        sGbc.insets = new Insets(5, 0, 5, 0);
        statusPanel.add((Component)miniforgePaintPanel, sGbc);
        JPanel leftPanel = new JPanel(new GridBagLayout());
        GridBagConstraints lGbc = new GridBagConstraints();
        lGbc.gridy = 0;
        lGbc.gridx = 0;
        lGbc.anchor = 18;
        lGbc.weightx = 1.0;
        lGbc.fill = 2;
        lGbc.insets = new Insets(5, 5, 15, 15);
        leftPanel.add((Component)statusPanel, lGbc);
        String condaChannelAuthTT = "<html>Manage token authentication for private conda channels.<br/>This can e.g. be used to authenticate to channels for internal dev builds of the Devkit package.</html> ";
        JLabel condaChannelAuthLabel = new JLabel("Conda Channel Authentication:");
        condaChannelAuthLabel.setToolTipText(condaChannelAuthTT);
        ++lGbc.gridy;
        lGbc.weightx = 0.0;
        lGbc.weighty = 0.0;
        lGbc.anchor = 17;
        lGbc.fill = 0;
        lGbc.insets = new Insets(5, 5, 5, 5);
        leftPanel.add((Component)condaChannelAuthLabel, lGbc);
        condaChannelLoginButton.setToolTipText("Log into a conda channel via token.");
        condaChannelLoginButton.addActionListener(e -> {
            final String channel = SwingTools.showInputDialog((String)"pel.debug.debug_channel_login.channel", (String)"", (Object[])new Object[0]);
            if (StringUtils.isBlank((CharSequence)channel)) {
                return;
            }
            final String token = SwingTools.showInputDialog((String)"pel.debug.debug_channel_login.token", (String)"", (Object[])new Object[0]);
            if (StringUtils.isBlank((CharSequence)token)) {
                return;
            }
            ProgressThread pt = new ProgressThread("pel.debug_channel_login.login"){

                public void run() {
                    condaChannelLoginButton.setEnabled(false);
                    condaChannelLogoutButton.setEnabled(false);
                    try {
                        if (!PythonSDKDebugDialog.isCondaAuthPackageInstalled()) {
                            PythonSDKDebugDialog.installCondaAuth();
                        }
                        PythonSDKDebugDialog.addChannel(channel);
                        PythonSDKDebugDialog.logIntoChannel(channel, token);
                    }
                    catch (MiniforgeException ex) {
                        LogService.getRoot().log(Level.WARNING, ex, () -> String.format("FAILURE: FAILED LOGGING INTO CONDA CHANNEL (%s)!", channel));
                    }
                    finally {
                        condaChannelLoginButton.setEnabled(true);
                        condaChannelLogoutButton.setEnabled(true);
                    }
                }
            };
            pt.addDependency(new String[]{"pel.debug_channel_login.login", "pel.debug_channel_login.logout"});
            pt.setIndeterminate(true);
            pt.start();
        });
        ++lGbc.gridy;
        lGbc.insets = new Insets(5, 5, 5, 5);
        leftPanel.add((Component)condaChannelLoginButton, lGbc);
        condaChannelLogoutButton.setToolTipText("Log out of a conda channel.");
        condaChannelLogoutButton.addActionListener(e -> {
            final String channel = SwingTools.showInputDialog((String)"pel.debug.debug_channel_logout.channel", (String)"", (Object[])new Object[0]);
            if (StringUtils.isBlank((CharSequence)channel)) {
                return;
            }
            ProgressThread pt = new ProgressThread("pel.debug_channel_login.logout"){

                public void run() {
                    condaChannelLoginButton.setEnabled(false);
                    condaChannelLogoutButton.setEnabled(false);
                    try {
                        if (!PythonSDKDebugDialog.isCondaAuthPackageInstalled()) {
                            PythonSDKDebugDialog.installCondaAuth();
                        }
                        PythonSDKDebugDialog.removeChannel(channel);
                        PythonSDKDebugDialog.logOutOfChannel(channel);
                    }
                    catch (MiniforgeException ex) {
                        LogService.getRoot().log(Level.WARNING, ex, () -> String.format("FAILURE: FAILED LOGGING OUT OF CONDA CHANNEL (%s)!", channel));
                    }
                    finally {
                        condaChannelLoginButton.setEnabled(true);
                        condaChannelLogoutButton.setEnabled(true);
                    }
                }
            };
            pt.addDependency(new String[]{"pel.debug_channel_login.logout", "pel.debug_channel_login.login"});
            pt.setIndeterminate(true);
            pt.start();
        });
        lGbc.anchor = 13;
        lGbc.insets = new Insets(5, 5, 5, 15);
        leftPanel.add((Component)condaChannelLogoutButton, lGbc);
        String distOverrideTT = "<html>Override the Python distribution used by operators:<br/>Select the root folder of a Python distribution on disk which is then used for every Python operator execution.<br/></html> ";
        JLabel overrideDistLabel = new JLabel("Override Distribution:");
        overrideDistLabel.setToolTipText(distOverrideTT);
        ++lGbc.gridy;
        lGbc.weightx = 0.0;
        lGbc.weighty = 0.0;
        lGbc.fill = 0;
        lGbc.anchor = 17;
        lGbc.insets = new Insets(5, 5, 5, 5);
        leftPanel.add((Component)overrideDistLabel, lGbc);
        final JButton delButton = new JButton(SwingTools.createIcon((String)"16/delete.png"));
        final JButton chooserButton = new JButton(SwingTools.createIcon((String)"16/folder_open.png"));
        chooserButton.setToolTipText(distOverrideTT);
        chooserButton.addActionListener(e -> {
            final File directory = SwingTools.chooseFile((Component)RapidMinerGUI.getMainFrame(), null, (boolean)true, (boolean)true, null, (String[])new String[0]);
            if (directory.isDirectory()) {
                ProgressThread pt = new ProgressThread("pel.debug_override_dist"){

                    public void run() {
                        chooserButton.setEnabled(false);
                        delButton.setEnabled(false);
                        try {
                            LogService.getRoot().log(Level.INFO, "TRY SETTING GLOBAL PYTHON DISTRIBUTION OVERRIDE...");
                            PythonDistributionHandlerTools.registerPythonDistributionOverride(directory.toPath());
                            LogService.getRoot().log(Level.INFO, "SUCCESS: SET GLOBAL PYTHON DISTRIBUTION OVERRIDE!");
                        }
                        catch (PythonDistributionRegistrationException ex) {
                            LogService.getRoot().log(Level.WARNING, "FAILURE: FAILED SETTING GLOBAL PYTHON DISTRIBUTION OVERRIDE!", ex);
                        }
                        finally {
                            chooserButton.setEnabled(true);
                            delButton.setEnabled(true);
                        }
                    }
                };
                pt.addDependency(new String[]{"pel.debug_override_dist"});
                pt.setIndeterminate(true);
                pt.start();
            }
        });
        ++lGbc.gridy;
        lGbc.insets = new Insets(5, 5, 5, 5);
        leftPanel.add((Component)chooserButton, lGbc);
        delButton.setToolTipText("Remove override of the Python distribution used by operators.");
        delButton.addActionListener(e -> {
            LogService.getRoot().log(Level.INFO, "TRY REMOVING GLOBAL PYTHON DISTRIBUTION OVERRIDE...");
            try {
                PythonDistributionHandlerTools.unregisterPythonDistributionOverride();
                LogService.getRoot().log(Level.INFO, "SUCCESS: REMOVED GLOBAL PYTHON DISTRIBUTION OVERRIDE!");
            }
            catch (PythonDistributionNotRegisteredException ex) {
                LogService.getRoot().log(Level.INFO, "PYTHON DISTRIBUTION OVERRIDE WAS NOT SET BEFORE");
            }
        });
        lGbc.anchor = 13;
        lGbc.insets = new Insets(5, 5, 5, 15);
        leftPanel.add((Component)delButton, lGbc);
        String commModeTT = "<html>Select the communication mode that should be enforced for every Python operator execution.<br/>Might cause failures if selected distribution does not support it!</html>";
        JLabel overrideCommModeLabel = new JLabel("Override Communication Mode:");
        overrideCommModeLabel.setToolTipText(commModeTT);
        ++lGbc.gridy;
        lGbc.insets = new Insets(15, 5, 5, 5);
        lGbc.anchor = 17;
        leftPanel.add((Component)overrideCommModeLabel, lGbc);
        List commModes = Arrays.stream(CommunicationMode.values()).map(Enum::name).collect(Collectors.toList());
        String none = "None";
        commModes.add(0, none);
        JComboBox<String> commModeOverrideComboBox = new JComboBox<String>((String[])commModes.toArray(String[]::new));
        CommunicationMode curValCommMode = PythonSDKSettings.getGlobalCommunicationModeOverride();
        String currentValueCommMode = curValCommMode == null ? none : curValCommMode.name();
        commModeOverrideComboBox.setSelectedItem(currentValueCommMode);
        commModeOverrideComboBox.setToolTipText(commModeTT);
        commModeOverrideComboBox.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                String override = String.valueOf(e.getItem());
                LogService.getRoot().log(Level.INFO, "Set Communication Mode override to : " + override);
                if (none.equals(override)) {
                    Settings.setSetting((String)"python_sdk.communication_mode.override", null);
                } else {
                    Settings.setSetting((String)"python_sdk.communication_mode.override", (String)override);
                }
            }
        });
        ++lGbc.gridy;
        lGbc.weightx = 1.0;
        lGbc.fill = 2;
        lGbc.insets = new Insets(5, 5, 5, 15);
        leftPanel.add(commModeOverrideComboBox, lGbc);
        String dataExModeTT = "<html>Select the data exchange mode that should be enforced for every Python operator execution.<br/>Might cause failures if selected distribution does not support it!</html>";
        JLabel overrideDataExModeLabel = new JLabel("Override Data Exchange Mode:");
        overrideDataExModeLabel.setToolTipText(dataExModeTT);
        lGbc.anchor = 17;
        ++lGbc.gridy;
        leftPanel.add((Component)overrideDataExModeLabel, lGbc);
        List dataExModes = Arrays.stream(DataExchangeMode.values()).map(Enum::name).collect(Collectors.toList());
        dataExModes.add(0, none);
        JComboBox<String> dataExModeOverrideComboBox = new JComboBox<String>((String[])dataExModes.toArray(String[]::new));
        DataExchangeMode curValDataEx = PythonSDKSettings.getGlobalDataExchangeModeOverride();
        String currentValueDataEx = curValDataEx == null ? none : curValDataEx.name();
        dataExModeOverrideComboBox.setSelectedItem(currentValueDataEx);
        dataExModeOverrideComboBox.setToolTipText(dataExModeTT);
        dataExModeOverrideComboBox.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                String override = String.valueOf(e.getItem());
                LogService.getRoot().log(Level.INFO, "Set Data Exchange Mode override to : " + override);
                if (none.equals(override)) {
                    Settings.setSetting((String)"python_sdk.data_exchange_mode.override", null);
                } else {
                    Settings.setSetting((String)"python_sdk.data_exchange_mode.override", (String)override);
                }
            }
        });
        ++lGbc.gridy;
        lGbc.weightx = 1.0;
        lGbc.fill = 2;
        lGbc.insets = new Insets(5, 5, 5, 15);
        leftPanel.add(dataExModeOverrideComboBox, lGbc);
        ++lGbc.gridy;
        lGbc.weightx = 0.0;
        lGbc.weighty = 1.0;
        lGbc.fill = 3;
        leftPanel.add((Component)Box.createVerticalBox(), lGbc);
        JPanel parentPanel = new JPanel(new BorderLayout());
        parentPanel.add((Component)leftPanel, "West");
        parentPanel.add((Component)mainPanel, "Center");
        ResourceAction toggleAction = new ResourceAction(TOGGLE_ACTION_I18N_KEY, new Object[]{PythonDebugMode.NONE.name().toLowerCase()}){

            protected void loggedActionPerformed(ActionEvent e) {
                PythonDebugMode debugModeNewSetting;
                switch (PythonSDKSettings.getDebugMode()) {
                    case NONE: {
                        debugModeNewSetting = PythonDebugMode.OPERATOR;
                        break;
                    }
                    case OPERATOR: {
                        debugModeNewSetting = PythonDebugMode.ALL;
                        break;
                    }
                    default: {
                        debugModeNewSetting = PythonDebugMode.NONE;
                    }
                }
                Settings.setSetting((String)"altair-library", (String)"pysdk.debugMode", (String)debugModeNewSetting.name());
                try {
                    PythonSDKSettings.updateSettings();
                    this.putValue("Name", PythonSDKDebugDialog.createNameForDebugToggle());
                    this.putValue("SwingLargeIconKey", PythonSDKDebugDialog.createIconForDebugToggle());
                }
                catch (PythonSDKException ex) {
                    LogService.getRoot().log(Level.WARNING, "Cannot change debug mode", ex);
                }
            }
        };
        toggleAction.putValue("Name", (Object)PythonSDKDebugDialog.createNameForDebugToggle());
        toggleAction.putValue("SwingLargeIconKey", (Object)PythonSDKDebugDialog.createIconForDebugToggle());
        this.layoutDefault(parentPanel, 9, new AbstractButton[]{new JButton((Action)toggleAction), this.makeCloseButton()});
        this.bridgeListener = new PythonBridgeListener(){

            @Override
            public void bridgeReady() {
                PythonSDKDebugDialog.this.submitAction.setEnabled(true);
                this.statusChanged(PythonBridgeStatus.READY);
            }

            @Override
            public void bridgeNotReady() {
                PythonSDKDebugDialog.this.submitAction.setEnabled(false);
                this.statusChanged(PythonBridgeStatus.NOT_READY);
            }

            @Override
            public void bridgeError() {
                PythonSDKDebugDialog.this.submitAction.setEnabled(false);
                this.statusChanged(PythonBridgeStatus.ERROR);
            }

            private void statusChanged(PythonBridgeStatus newStatus) {
                PythonSDKDebugDialog.this.bridgeStatus = newStatus;
                SwingTools.invokeLater(bridgePaintPanel::repaint);
            }
        };
        PythonBridge.INSTANCE.addBridgeListener(this.bridgeListener);
        this.distributionListener = (event, pyDist) -> {
            switch (event.getEventType()) {
                case PYTHON_DISTRIBUTION_REGISTERED: {
                    this.model.addElement(pyDist);
                    break;
                }
                case PYTHON_DISTRIBUTION_UNREGISTERED: {
                    this.model.removeElement(pyDist);
                    break;
                }
            }
        };
        List<PythonDistribution> registeredDistributions = PythonDistributionHandler.INSTANCE.getRegisteredDistributions();
        this.model.addAll(registeredDistributions);
        if (!registeredDistributions.isEmpty()) {
            this.distributionBox.setSelectedIndex(0);
        }
        PythonDistributionHandler.INSTANCE.addEventListener(this.distributionListener);
        this.miniforgeListener = new MiniforgeListener(){

            @Override
            public void miniforgeStatusChanged(MiniforgeStatus newStatus) {
                this.statusChanged(newStatus);
            }

            private void statusChanged(MiniforgeStatus newStatus) {
                PythonSDKDebugDialog.this.miniforgeStatus = newStatus;
                SwingTools.invokeLater(bridgePaintPanel::repaint);
                if (newStatus != MiniforgeStatus.READY) {
                    condaChannelLoginButton.setEnabled(false);
                    condaChannelLogoutButton.setEnabled(false);
                }
            }
        };
        MiniforgeHandler.INSTANCE.addMiniforgeListener(this.miniforgeListener);
    }

    public void dispose() {
        try {
            PythonBridge.INSTANCE.removeBridgeListener(this.bridgeListener);
            PythonDistributionHandler.INSTANCE.removeEventListener(this.distributionListener);
            MiniforgeHandler.INSTANCE.removeMiniforgeListener(this.miniforgeListener);
        }
        catch (Exception ex) {
            LogService.getRoot().log(Level.WARNING, "Failed to remove listener", ex);
        }
        super.dispose();
    }

    private void addToScriptHistory(String script) {
        while (SCRIPT_HISTORY.size() >= 10) {
            SCRIPT_HISTORY.remove(0);
        }
        int index = SCRIPT_HISTORY.indexOf(script);
        if (index >= 0) {
            SCRIPT_HISTORY.remove(index);
        }
        SCRIPT_HISTORY.add(script);
    }

    private void awaitResult(CompletableFuture<PythonScriptResult> result) {
        result.whenComplete((scriptResult, e) -> {
            try {
                if (scriptResult != null) {
                    SwingTools.invokeLater(() -> this.infoLabel.setText(String.format("Script exited with code %d, took %d ms", scriptResult.getExitCode(), scriptResult.getRuntimeInMs())));
                    SwingTools.invokeLater(() -> this.resultTabbedPane.setSelectedIndex(scriptResult.getExitCode() == 0 ? 0 : 1));
                } else if (e != null) {
                    if (e.getCause() instanceof PythonScriptProcessingException) {
                        PythonScriptProcessingException processingException = (PythonScriptProcessingException)e.getCause();
                        Throwable rootCause = processingException.getCause();
                        SwingTools.invokeLater(() -> this.infoLabel.setText("Script processing exception!"));
                        SwingTools.invokeLater(() -> {
                            this.resultAreaErr.setText(ExceptionUtils.getStackTrace((Throwable)rootCause));
                            this.resultTabbedPane.setSelectedIndex(1);
                        });
                    } else {
                        SwingTools.invokeLater(() -> this.infoLabel.setText("Unexpected exception!"));
                        SwingTools.invokeLater(() -> {
                            this.resultAreaErr.setText("Unexpected script processing exception: " + e.getCause().getMessage());
                            this.resultTabbedPane.setSelectedIndex(1);
                        });
                        LogService.getRoot().log(Level.WARNING, "Debug script error", e.getCause());
                    }
                }
            }
            finally {
                this.scriptArea.setEnabled(true);
                this.submitAction.setEnabled(true);
                this.scriptArea.requestFocusInWindow();
                Optional.ofNullable(scriptResult).ifPresent(PythonScriptResult::close);
            }
        });
    }

    public static void registerInHelpMenu(MainFrame mainframe) {
        SecurityTools.requireInternalPermission();
        mainframe.getHelpMenu().add((Action)PythonSDKDebugDialog.createDebugAction());
    }

    public static ResourceAction createDebugAction() {
        return new ResourceAction("debug.python_bundle", new Object[0]){

            protected void loggedActionPerformed(ActionEvent e) {
                if (StudioConstraintsManager.isRapidMinerLicense()) {
                    SwingTools.showMessageDialog((String)"python_extensions.missing_altair_license", (Object[])new Object[0]);
                } else {
                    new PythonSDKDebugDialog().setVisible(true);
                }
            }
        };
    }

    private static SubmissionResult submitScript(PythonDistribution pyDist, String script, Consumer<String> logConsumer, Consumer<String> errConsumer) throws PythonDistributionException, PythonScriptRunnerException {
        return PythonBridge.INSTANCE.submitScript(pyDist, new PythonCodeScript(script, logConsumer, errConsumer), CommunicationMode.CMD_V1, DataExchangeMode.FILE_SYSTEM);
    }

    private static ImageIcon createIconForDebugToggle() {
        PythonDebugMode debugModeSetting = PythonSDKSettings.getDebugMode();
        String iconKey = String.format("gui.action.%s.%s.icon", TOGGLE_ACTION_I18N_KEY, debugModeSetting.name().toLowerCase());
        return SwingTools.createIcon((String)("24/" + I18N.getGUIMessage((String)iconKey, (Object[])new Object[0])), (boolean)false);
    }

    private static String createNameForDebugToggle() {
        PythonDebugMode debugModeSetting = PythonSDKSettings.getDebugMode();
        String i18nKey = String.format("gui.action.%s.%s.label", TOGGLE_ACTION_I18N_KEY, debugModeSetting.name().toLowerCase());
        return I18N.getGUIMessage((String)i18nKey, (Object[])new Object[0]);
    }

    private static Color getBridgeStatusPaint(PythonBridgeStatus status) {
        String statusName = status.name();
        if (statusName.contains("ERROR")) {
            return Colors.PASTEL_ERROR_LIGHT;
        }
        if (statusName.contains("NOT_READY")) {
            return Colors.RAPIDMINER_X_ORANGE;
        }
        return Colors.RAPIDMINER_X_TEAL;
    }

    private static Color getMiniforgeStatusPaint(MiniforgeStatus status) {
        String statusName = status.name();
        if (statusName.equals(MiniforgeStatus.ERROR.name())) {
            return Colors.PASTEL_ERROR_LIGHT;
        }
        if (Set.of("NOT_YET_INITIALIZED", "UNKNOWN", "INSTALLING", "DISABLED").contains(statusName)) {
            return Colors.RAPIDMINER_X_ORANGE;
        }
        return Colors.RAPIDMINER_X_TEAL;
    }

    private static void addChannel(String channel) throws MiniforgeException {
        try {
            MiniforgeHandler.INSTANCE.changeConfig(MiniforgeConfigModifier.PREPEND, "channels", channel);
        }
        catch (Exception e) {
            throw new MiniforgeException("Miniforge conda channel addition failed", e);
        }
    }

    private static void removeChannel(String channel) throws MiniforgeException {
        try {
            MiniforgeHandler.INSTANCE.changeConfig(MiniforgeConfigModifier.REMOVE, "channels", channel);
        }
        catch (Exception e) {
            throw new MiniforgeException("Miniforge conda channel removal failed", e);
        }
    }

    private static void logIntoChannel(String channel, String token) throws MiniforgeException {
        try {
            String[] fullArgs = new String[]{MiniforgeHandler.INSTANCE.getMiniforgeExecutable().toString(), "auth", "login", channel, "--token", token};
            ExternalProcess result = ExternalProcessBuilder.newBuilder().workingDir(MiniforgeHandler.INSTANCE.getMiniforgeExecutable().getParent()).addEnvUnlessOperatingSystem("HOME", () -> PythonSDKSettings.getMiniforgeFakeHomeDir().toAbsolutePath().toString(), SystemInfoUtilities.OperatingSystem.WINDOWS).outputConsumer(s -> ExternalProcessTools.logShellOutput("Miniforge conda channel login", Level.INFO, s)).errorConsumer(err -> ExternalProcessTools.logShellOutput("Miniforge conda channel login", Level.WARNING, err)).id("Miniforge conda channel login").command(fullArgs).startProcess();
            Process process = result.getProcessFuture().get(10L, TimeUnit.SECONDS);
            int exitCode = process.exitValue();
            if (exitCode != 0) {
                throw new MiniforgeException("Miniforge conda channel login failed: " + exitCode);
            }
            LogService.getRoot().log(Level.INFO, () -> String.format("Miniforge conda channel login (%s) successful", channel));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new MiniforgeException("Miniforge conda channel login failed", e);
        }
        catch (Exception e) {
            throw new MiniforgeException("Miniforge conda channel login failed", e);
        }
    }

    private static void logOutOfChannel(String channel) throws MiniforgeException {
        try {
            String[] fullArgs = new String[]{MiniforgeHandler.INSTANCE.getMiniforgeExecutable().toString(), "auth", "logout", channel};
            ExternalProcess result = ExternalProcessBuilder.newBuilder().workingDir(MiniforgeHandler.INSTANCE.getMiniforgeExecutable().getParent()).addEnvUnlessOperatingSystem("HOME", () -> PythonSDKSettings.getMiniforgeFakeHomeDir().toAbsolutePath().toString(), SystemInfoUtilities.OperatingSystem.WINDOWS).outputConsumer(s -> ExternalProcessTools.logShellOutput("Miniforge conda channel logout", Level.INFO, s)).errorConsumer(err -> ExternalProcessTools.logShellOutput("Miniforge conda channel logout", Level.WARNING, err)).id("Miniforge conda channel logout").command(fullArgs).startProcess();
            Process process = result.getProcessFuture().get(10L, TimeUnit.SECONDS);
            int exitCode = process.exitValue();
            if (exitCode != 0) {
                throw new MiniforgeException("Miniforge conda channel logout failed: " + exitCode);
            }
            LogService.getRoot().log(Level.INFO, () -> String.format("Miniforge conda channel logout (%s) successful", channel));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new MiniforgeException("Miniforge conda channel logout failed", e);
        }
        catch (Exception e) {
            throw new MiniforgeException("Miniforge conda channel logout failed", e);
        }
    }

    private static boolean isCondaAuthPackageInstalled() throws MiniforgeException {
        try {
            String[] fullArgs = new String[]{MiniforgeHandler.INSTANCE.getMiniforgeExecutable().toString(), "list", "--name", "base", "conda-auth"};
            StringBuilder sb = new StringBuilder();
            ExternalProcess result = ExternalProcessBuilder.newBuilder().workingDir(MiniforgeHandler.INSTANCE.getMiniforgeExecutable().getParent()).addEnvUnlessOperatingSystem("HOME", () -> PythonSDKSettings.getMiniforgeFakeHomeDir().toAbsolutePath().toString(), SystemInfoUtilities.OperatingSystem.WINDOWS).outputConsumer(s -> {
                sb.append((String)s);
                ExternalProcessTools.logShellOutput("Miniforge conda-auth package existence check", Level.INFO, s);
            }).errorConsumer(err -> ExternalProcessTools.logShellOutput("Miniforge conda-auth package existence check", Level.WARNING, err)).id("Miniforge conda-auth package existence check").command(fullArgs).startProcess();
            Process process = result.getProcessFuture().get(10L, TimeUnit.SECONDS);
            int exitCode = process.exitValue();
            if (exitCode != 0) {
                throw new MiniforgeException("Miniforge conda-auth package existence check failed: " + exitCode);
            }
            String response = sb.toString().toLowerCase(Locale.ENGLISH);
            return response.contains("conda-auth");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new MiniforgeException("Miniforge conda-auth install failed", e);
        }
        catch (Exception e) {
            throw new MiniforgeException("Miniforge conda-auth package existence check failed", e);
        }
    }

    private static void installCondaAuth() throws MiniforgeException {
        try {
            String[] fullArgs = new String[]{MiniforgeHandler.INSTANCE.getMiniforgeExecutable().toString(), "install", "--name", "base", "--channel", "conda-forge", "--yes", "conda-auth"};
            ExternalProcess result = ExternalProcessBuilder.newBuilder().workingDir(MiniforgeHandler.INSTANCE.getMiniforgeExecutable().getParent()).addEnvUnlessOperatingSystem("HOME", () -> PythonSDKSettings.getMiniforgeFakeHomeDir().toAbsolutePath().toString(), SystemInfoUtilities.OperatingSystem.WINDOWS).outputConsumer(s -> ExternalProcessTools.logShellOutput("Miniforge conda-auth install", Level.INFO, s)).errorConsumer(err -> ExternalProcessTools.logShellOutput("Miniforge conda-auth install", Level.WARNING, err)).id("Miniforge conda-auth install").command(fullArgs).startProcess();
            Process process = result.getProcessFuture().get(10L, TimeUnit.SECONDS);
            int exitCode = process.exitValue();
            if (exitCode != 0) {
                throw new MiniforgeException("Miniforge conda-auth install failed: " + exitCode);
            }
            LogService.getRoot().log(Level.INFO, "Miniforge conda-auth install successful");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new MiniforgeException("Miniforge conda-auth install failed", e);
        }
        catch (Exception e) {
            throw new MiniforgeException("Miniforge conda-auth install failed", e);
        }
    }

    static {
        String exampleScript;
        BRIDGE_STATUS_DIMENSION = new Dimension(125, PythonBridgeStatus.values().length * 20);
        MINIFORGE_STATUS_DIMENSION = new Dimension(125, MiniforgeStatus.values().length * 20);
        OPEN_SANS = FontTools.getFont((String)"Open Sans", (int)0, (int)14);
        SCRIPT_HISTORY = new LinkedList<String>();
        try (InputStream scriptStream = PythonDistributionHandler.class.getResourceAsStream("/com/altair/extension/resources/scripts/examples/hello.py");){
            if (scriptStream == null) {
                throw new NullPointerException();
            }
            byte[] bytes = scriptStream.readAllBytes();
            exampleScript = new String(bytes, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            LogService.getRoot().log(Level.WARNING, "Failed to load example script, using fallback.", e);
            exampleScript = "print('Greetings from Altair!')";
        }
        EXAMPLE_SCRIPT = exampleScript;
    }
}

