/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.loader;

import com.altair.ai.pel.distribution.PythonDistribution;
import com.altair.ai.pel.loader.ExtensionState;
import com.altair.ai.pel.loader.PythonExtensionDependency;
import com.altair.ai.pel.loader.PythonExtensionRegistry;
import com.altair.ai.pel.loader.PythonOperatorDescription;
import com.rapidminer.gui.tools.VersionNumber;
import com.rapidminer.tools.ValidationUtilV2;
import com.rapidminer.tools.plugin.Plugin;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;

public class PythonExtension {
    private final Path source;
    private final Plugin provider;
    private final String licenseName;
    private final String namespace;
    private final VersionNumber version;
    private final String name;
    private final boolean listOperatorsAtRootLevel;
    private final String module;
    private final PythonDistribution pythonDist;
    private final Set<PythonExtensionDependency> dependencies;
    private final Set<PythonExtensionDependency> missingDependencies;
    private final String envDefinitionYml;
    private final String pipRequirementsTxt;
    private List<PythonOperatorDescription> pythonOperatorDescriptions;
    private volatile ExtensionState currentState;
    private final Map<String, Set<String>> serializableDataClasses;

    PythonExtension(Path source, Plugin provider, String namespace, String licenseName, String name, boolean listOperatorsAtRootLevel, VersionNumber version, String module, PythonDistribution pythonDist, Set<PythonExtensionDependency> dependencies, String envDefinitionYml, String pipRequirementsTxt, Map<String, Set<String>> serializableDataClasses) {
        this.source = (Path)ValidationUtilV2.requireNonNull((Object)source, (String)"source");
        this.provider = (Plugin)ValidationUtilV2.requireNonNull((Object)provider, (String)"provider");
        this.namespace = "py_" + ValidationUtilV2.requireNonEmptyString((String)namespace, (String)"namespace");
        this.licenseName = licenseName;
        this.name = ValidationUtilV2.requireNonEmptyString((String)name, (String)"name");
        this.listOperatorsAtRootLevel = listOperatorsAtRootLevel;
        this.version = (VersionNumber)ValidationUtilV2.requireNonNull((Object)version, (String)"version");
        this.module = ValidationUtilV2.requireNonEmptyString((String)module, (String)"module");
        this.pythonDist = (PythonDistribution)ValidationUtilV2.requireNonNull((Object)pythonDist, (String)"pythonDist");
        this.dependencies = dependencies != null ? dependencies : Collections.emptySet();
        this.missingDependencies = new HashSet<PythonExtensionDependency>();
        this.envDefinitionYml = envDefinitionYml;
        this.pipRequirementsTxt = pipRequirementsTxt;
        this.currentState = ExtensionState.UNREGISTERED;
        this.serializableDataClasses = serializableDataClasses;
    }

    public Path getSource() {
        return this.source;
    }

    public Set<Path> getTransitiveSources() {
        return this.addTransitiveSources(new HashSet<Path>());
    }

    public Map<String, Set<String>> getSerializableDataClasses() {
        return this.addTransitiveSerializableDataClasses(new HashMap<String, Set<String>>());
    }

    public String getModule() {
        return this.module;
    }

    public Plugin getProvider() {
        return this.provider;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getLicenseName() {
        return this.licenseName;
    }

    public VersionNumber getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public boolean isListingOperatorsAtRootLevel() {
        return this.listOperatorsAtRootLevel;
    }

    public Set<PythonExtensionDependency> getDependencies() {
        return new HashSet<PythonExtensionDependency>(this.dependencies);
    }

    public Set<PythonExtensionDependency> getMissingDependencies() {
        return this.missingDependencies;
    }

    public void setMissingDependencies(Set<PythonExtensionDependency> missingDependencies) {
        Set newMissingDeps = (Set)ValidationUtilV2.requireNonNull(missingDependencies, (String)"missingDependencies");
        this.missingDependencies.clear();
        this.missingDependencies.addAll(newMissingDeps);
    }

    public String getEnvDefinitionYml() {
        return this.envDefinitionYml;
    }

    public String getPipRequirementsTxt() {
        return this.pipRequirementsTxt;
    }

    public PythonDistribution getPythonDist() {
        return this.pythonDist;
    }

    public List<PythonOperatorDescription> getPythonOperatorDescriptions() {
        return this.pythonOperatorDescriptions != null ? Collections.unmodifiableList(this.pythonOperatorDescriptions) : Collections.emptyList();
    }

    public void setPythonOperatorDescriptions(List<PythonOperatorDescription> pythonOperatorDescriptions) {
        this.pythonOperatorDescriptions = (List)ValidationUtilV2.requireNonNull(pythonOperatorDescriptions, (String)"pythonOperatorDescriptions");
    }

    public ExtensionState getCurrentState() {
        return this.currentState;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PythonExtension that = (PythonExtension)o;
        return Objects.equals(this.source, that.source) && Objects.equals(this.module, that.module) && Objects.equals(this.namespace, that.namespace) && Objects.equals(this.name, that.name) && Objects.equals(this.listOperatorsAtRootLevel, that.listOperatorsAtRootLevel) && Objects.equals(this.version, that.version) && Objects.equals(this.pythonDist, that.pythonDist) && Objects.equals(this.pythonOperatorDescriptions, that.pythonOperatorDescriptions) && Objects.equals((Object)this.currentState, (Object)that.currentState) && Objects.equals(this.envDefinitionYml, that.envDefinitionYml) && Objects.equals(this.dependencies, that.dependencies) && Objects.equals(this.licenseName, that.licenseName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.source, this.module, this.namespace, this.licenseName, this.name, this.version, this.pythonDist, this.pythonOperatorDescriptions, this.currentState, this.envDefinitionYml, this.dependencies});
    }

    public String toString() {
        return "PythonExtension{name='" + this.name + "', version=" + this.version + ", pythonDist=" + this.pythonDist + ", currentState=" + this.currentState + ", namespace='" + this.namespace + "', licenseName=" + this.licenseName + ", dependencies=" + this.getDependencies() + ", missingDependencies=" + this.getMissingDependencies() + "}";
    }

    void setState(ExtensionState newState) {
        this.currentState = (ExtensionState)((Object)ValidationUtilV2.requireNonNull((Object)((Object)newState), (String)"newState"));
    }

    private Set<Path> addTransitiveSources(Set<Path> transitiveSources) {
        this.dependencies.stream().map(PythonExtensionDependency::getNamespace).map(PythonExtensionRegistry.INSTANCE::getExtensionForNamespace).forEach(extension -> extension.addTransitiveSources(transitiveSources));
        transitiveSources.add(this.source);
        return transitiveSources;
    }

    private Map<String, Set<String>> addTransitiveSerializableDataClasses(Map<String, Set<String>> resultContainer) {
        this.dependencies.stream().map(PythonExtensionDependency::getNamespace).map(PythonExtensionRegistry.INSTANCE::getExtensionForNamespace).filter(Objects::nonNull).forEach(extension -> extension.addTransitiveSerializableDataClasses(resultContainer));
        resultContainer.putAll(this.serializableDataClasses);
        return resultContainer;
    }

    public static String getDependenciesAsString(Set<PythonExtensionDependency> dependencies) {
        StringJoiner depJoiner = new StringJoiner(", ");
        dependencies.forEach(dep -> {
            String v = dep.getMinVersion().getShortLongVersion();
            Optional.ofNullable(PythonExtensionRegistry.INSTANCE.getExtensionForNamespace(dep.getNamespace())).ifPresentOrElse(depExt -> depJoiner.add(String.format("%s [%s]", depExt.getName(), v)), () -> depJoiner.add(String.format("%s [%s]", dep.getNamespace(), v)));
        });
        return !depJoiner.toString().isEmpty() ? depJoiner.toString() : "-";
    }
}

