/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.loader;

import com.altair.ai.pel.distribution.PythonDistribution;
import com.altair.ai.pel.distribution.PythonDistributionHandler;
import com.altair.ai.pel.loader.ExtensionState;
import com.altair.ai.pel.loader.PythonExtension;
import com.altair.ai.pel.loader.PythonExtensionDependency;
import com.altair.ai.pel.loader.PythonExtensionRegistry;
import com.altair.ai.pel.loader.PythonExtensionTools;
import com.altair.ai.pel.loader.PythonOperatorParser;
import com.altair.ai.pel.python.event.PythonDistributionHandlerEventListener;
import com.altair.ai.pel.python.exception.PythonExtensionInvalidException;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.rapidminer.gui.tools.ProgressThread;
import com.rapidminer.gui.tools.ProgressThreadStoppedException;
import com.rapidminer.gui.tools.VersionNumber;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ProgressListener;
import com.rapidminer.tools.ValidationUtilV2;
import com.rapidminer.tools.plugin.Plugin;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import java.util.logging.Level;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.lang3.StringUtils;

public final class PythonExtensionLoader
extends Enum<PythonExtensionLoader> {
    public static final String PYTHON_EXTENSION_SUFFIX = ".zip";
    private static final PythonDistributionHandlerEventListener DISTRIBUTION_LISTENER;
    private static final /* synthetic */ PythonExtensionLoader[] $VALUES;

    public static PythonExtensionLoader[] values() {
        return (PythonExtensionLoader[])$VALUES.clone();
    }

    public static PythonExtensionLoader valueOf(String name) {
        return Enum.valueOf(PythonExtensionLoader.class, name);
    }

    public static void loadExtensions(boolean reloading, Optional<ProgressListener> progress, BooleanSupplier cancelledSupplier) {
        ValidationUtilV2.requireNonNull(progress, (String)"progress");
        ValidationUtilV2.requireNonNull((Object)cancelledSupplier, (String)"cancelledSupplier");
        try {
            Path lookupDir = PythonExtensionTools.getExtensionLookupDirectory();
            LogService.getRoot().log(Level.INFO, () -> String.format("Looking for Python extensions in %s", lookupDir));
            if (reloading) {
                PythonExtensionRegistry.INSTANCE.unregisterAllExtensions();
            }
            AtomicInteger progressCounter = new AtomicInteger(0);
            List<PythonExtension> pythonExtensions = PythonExtensionLoader.loadExtensionsFromFolder(lookupDir);
            int numberOfExtensions = pythonExtensions.size();
            progress.ifPresent(pl -> pl.setTotal(numberOfExtensions * 2));
            PythonExtensionLoader.registerExtensions(pythonExtensions, progressCounter, progress, cancelledSupplier);
            PythonExtensionRegistry.INSTANCE.updateExtensionRegistrationsRelatedToMissingDependencies(false);
            PythonExtensionLoader.registerExtensionDistributions(progressCounter, progress, cancelledSupplier);
        }
        catch (ProgressThreadStoppedException e) {
            LogService.getRoot().log(Level.INFO, "Cancelled registration of Python extensions");
        }
        catch (Exception e) {
            LogService.getRoot().log(Level.SEVERE, "Failed to load Python extensions", e);
        }
    }

    public static PythonExtension loadExtensionFromFile(Path extPath) throws IOException, PythonExtensionInvalidException {
        ValidationUtilV2.requireNonNull((Object)extPath, (String)"extPath");
        String extFileName = extPath.getFileName().toString();
        if (!extFileName.endsWith(PYTHON_EXTENSION_SUFFIX)) {
            throw new PythonExtensionInvalidException(String.format("%s does not have the expected Python extension suffix '%s'.", extFileName, PYTHON_EXTENSION_SUFFIX));
        }
        LogService.getRoot().log(Level.FINE, () -> String.format("Loading Python extension from file %s", extFileName));
        long start = System.currentTimeMillis();
        PythonExtension pyExt = PythonExtensionLoader.loadExtensionFromZip(extPath);
        long end = System.currentTimeMillis();
        LogService.getRoot().log(Level.FINE, () -> String.format("Successfully loaded Python extension %s [%s] in %dms", pyExt.getName(), pyExt.getVersion().getShortLongVersion(), end - start));
        return pyExt;
    }

    private static void registerExtensions(List<PythonExtension> pythonExtensions, AtomicInteger progressCounter, Optional<ProgressListener> progress, BooleanSupplier cancelledSupplier) {
        HashMap<String, PythonExtension> extMap = new HashMap<String, PythonExtension>();
        for (PythonExtension newExt : pythonExtensions) {
            if (cancelledSupplier.getAsBoolean()) {
                LogService.getRoot().log(Level.INFO, "Cancelled registration of Python extensions");
                return;
            }
            PythonExtension existingExt = (PythonExtension)extMap.get(newExt.getNamespace());
            PythonExtension extToKeep = newExt;
            if (existingExt != null) {
                VersionNumber existingVersion = existingExt.getVersion();
                if (existingVersion.isAtLeast(newExt.getVersion())) {
                    LogService.getRoot().log(Level.INFO, () -> String.format("Ignored Python extension %s with version [%s] because version [%s] exists", newExt.getName(), newExt.getVersion().getShortLongVersion(), existingVersion.getShortLongVersion()));
                    newExt.setState(ExtensionState.OLD_VERSION);
                    extToKeep = existingExt;
                } else {
                    LogService.getRoot().log(Level.INFO, () -> String.format("Ignored Python extension %s with version [%s] because version [%s] exists", existingExt.getName(), existingVersion.getShortLongVersion(), newExt.getVersion().getShortLongVersion()));
                    existingExt.setState(ExtensionState.OLD_VERSION);
                }
            }
            extMap.put(extToKeep.getNamespace(), extToKeep);
        }
        for (PythonExtension pyExt : extMap.values()) {
            PythonExtensionRegistry.INSTANCE.registerExtension(pyExt, false);
            progress.ifPresent(pl -> pl.setCompleted(progressCounter.incrementAndGet()));
        }
    }

    private static void registerExtensionDistributions(AtomicInteger progressCounter, Optional<ProgressListener> progress, BooleanSupplier cancelledSupplier) {
        List<PythonExtension> pythonExtensions = PythonExtensionRegistry.INSTANCE.getAllExtensions();
        List<PythonDistribution> registeredDistributions = PythonDistributionHandler.INSTANCE.getRegisteredDistributions();
        pythonExtensions.sort((ext1, ext2) -> {
            if (registeredDistributions.contains(ext1.getPythonDist()) && !registeredDistributions.contains(ext2.getPythonDist())) {
                return -1;
            }
            if (!registeredDistributions.contains(ext1.getPythonDist()) && registeredDistributions.contains(ext2.getPythonDist())) {
                return 1;
            }
            return 0;
        });
        for (final PythonExtension pyExt : pythonExtensions) {
            if (cancelledSupplier.getAsBoolean()) {
                LogService.getRoot().log(Level.INFO, "Cancelled registration of Python extensions");
                return;
            }
            if (progress.isPresent()) {
                String i18nKey = "pel.register_dist";
                ProgressThread progressThread = new ProgressThread(i18nKey, false, new Object[]{pyExt.getName()}){

                    public void run() {
                        PythonDistributionHandler.INSTANCE.registerDistributionForExtension(pyExt);
                    }
                };
                progressThread.addDependency(new String[]{i18nKey});
                progressThread.setIndeterminate(true);
                progressThread.setCancelable(false);
                progressThread.startAndWait();
                progress.get().setCompleted(progressCounter.incrementAndGet());
                continue;
            }
            PythonDistributionHandler.INSTANCE.registerDistributionForExtension(pyExt);
        }
    }

    private static List<PythonExtension> loadExtensionsFromFolder(Path folder) throws IOException {
        ValidationUtilV2.requireNonNull((Object)folder, (String)"folder");
        if (Files.notExists(folder, new LinkOption[0])) {
            Files.createDirectory(folder, new FileAttribute[0]);
            return Collections.emptyList();
        }
        ArrayList<PythonExtension> list = new ArrayList<PythonExtension>();
        try (Stream<Path> extensions = Files.list(folder);){
            extensions.filter(p -> p.toString().endsWith(PYTHON_EXTENSION_SUFFIX)).forEach(extPath -> {
                try {
                    list.add(PythonExtensionLoader.loadExtensionFromFile(extPath));
                }
                catch (PythonExtensionInvalidException e) {
                    LogService.getRoot().log(Level.SEVERE, e, () -> String.format("File '%s' is not a valid Python extension, skipping.", extPath.getFileName().toString()));
                }
                catch (Exception e) {
                    LogService.getRoot().log(Level.SEVERE, e, () -> String.format("Failed to load Python extension from file '%s'", extPath.getFileName().toString()));
                }
            });
        }
        return list;
    }

    private static PythonExtension loadExtensionFromZip(Path zipFile) throws IOException, PythonExtensionInvalidException {
        ValidationUtilV2.requireNonNull((Object)zipFile, (String)"zipFile");
        if (!Files.exists(zipFile, new LinkOption[0]) || Files.isDirectory(zipFile, new LinkOption[0])) {
            throw new FileNotFoundException(zipFile.toString());
        }
        JsonObject root = PythonExtensionLoader.readJson(zipFile);
        JsonObject extension = root.getAsJsonObject("extension");
        String namespace = PythonExtensionLoader.validateNamespace(extension.get("namespace").getAsString());
        String licenseName = PythonExtensionLoader.getAsStringOrNull(extension, "license");
        String extName = extension.get("name").getAsString();
        String envDefinitionYml = PythonExtensionLoader.readEnvironment(zipFile, extName);
        String pipRequirementsTxt = PythonExtensionLoader.readPipRequirements(zipFile, extName);
        if (StringUtils.trimToNull((String)extName) == null) {
            extName = StringUtils.capitalize((String)namespace);
        }
        Set<PythonExtensionDependency> dependencies = PythonExtensionLoader.getExtensionDependencies(extension.get("dependencies"));
        PythonExtension pyExt = new PythonExtension(zipFile, Plugin.getPluginByExtensionId((String)"rmx_pel"), namespace, licenseName, extName, PythonExtensionLoader.getAndValidateBoolean(extension.get("list_operators_at_root_level"), false), PythonExtensionLoader.getAndValidateVersion(extension.get("version").getAsString()), extension.get("module").getAsString(), PythonExtensionLoader.getAndValidateDistribution(extension.get("environment").getAsString()), dependencies, envDefinitionYml, pipRequirementsTxt, PythonExtensionLoader.getSerializableDataClasses(root.getAsJsonArray("data_objects")));
        pyExt.setPythonOperatorDescriptions(PythonOperatorParser.parseOperators(pyExt, root));
        return pyExt;
    }

    private static Map<String, Set<String>> getSerializableDataClasses(JsonArray serializableClassesArray) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        result.put("numpy.ndarray", new HashSet());
        if (serializableClassesArray != null) {
            for (int i = 0; i < serializableClassesArray.size(); ++i) {
                JsonObject jsonObject = serializableClassesArray.get(i).getAsJsonObject();
                result.put(jsonObject.get("name").getAsString(), PythonExtensionLoader.getStringSet(jsonObject.get("compatible_with").getAsJsonArray()));
            }
        }
        return result;
    }

    private static Set<PythonExtensionDependency> getExtensionDependencies(JsonElement dependenciesElement) {
        HashSet<PythonExtensionDependency> dependencies = new HashSet<PythonExtensionDependency>();
        if (dependenciesElement == null || dependenciesElement.isJsonNull() || dependenciesElement.isJsonPrimitive()) {
            return dependencies;
        }
        for (JsonElement dependencyElement : dependenciesElement.getAsJsonArray()) {
            JsonObject dependencyObject = dependencyElement.getAsJsonObject();
            String namespace = dependencyObject.get("name").getAsString();
            String minVersion = dependencyObject.get("min_version").getAsString();
            try {
                dependencies.add(new PythonExtensionDependency(PythonExtensionLoader.validateNamespace(namespace), PythonExtensionLoader.getAndValidateVersion(minVersion)));
            }
            catch (PythonExtensionInvalidException e) {
                LogService.getRoot().log(Level.WARNING, () -> String.format("Skipping invalid extension dependency '%s'", namespace));
            }
        }
        return dependencies;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static JsonObject readJson(Path extension) throws IOException, PythonExtensionInvalidException {
        ZipEntry entry = new ZipEntry("extension.json");
        Gson gson = new Gson();
        try (ZipFile zip = new ZipFile(extension.toFile());){
            JsonObject jsonObject;
            block13: {
                InputStream stream = zip.getInputStream(entry);
                try {
                    String json = new String(stream.readAllBytes(), StandardCharsets.UTF_8);
                    jsonObject = (JsonObject)gson.fromJson(json, JsonObject.class);
                    if (stream == null) break block13;
                }
                catch (Throwable throwable) {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stream.close();
            }
            return jsonObject;
        }
        catch (RuntimeException e) {
            throw new PythonExtensionInvalidException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readEnvironment(Path extension, String extName) {
        try (ZipFile zip = new ZipFile(extension.toFile());){
            ZipEntry entry = zip.getEntry("env.yml");
            if (entry == null) {
                LogService.getRoot().log(Level.INFO, () -> String.format("Python extension %s has no conda env.yml file. Miniforge env management not possible.", extName));
                String string = null;
                return string;
            }
            InputStream stream = zip.getInputStream(entry);
            String string = new String(stream.readAllBytes(), StandardCharsets.UTF_8);
            return string;
        }
        catch (IOException e) {
            LogService.getRoot().log(Level.WARNING, e, () -> String.format("Cannot read conda env.yml file from Python extension %s. Miniforge env management not possible.", extName));
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readPipRequirements(Path extension, String extName) {
        try (ZipFile zip = new ZipFile(extension.toFile());){
            ZipEntry entry = zip.getEntry("requirements.txt");
            if (entry == null) {
                LogService.getRoot().log(Level.FINE, () -> String.format("Python extension %s has no pip requirements.txt file.", extName));
                String string = null;
                return string;
            }
            InputStream stream = zip.getInputStream(entry);
            String string = new String(stream.readAllBytes(), StandardCharsets.UTF_8);
            return string;
        }
        catch (IOException e) {
            LogService.getRoot().log(Level.WARNING, e, () -> String.format("Cannot read pip requirements.txt file from Python extension %s. Pip package installation not possible.", extName));
            return null;
        }
    }

    private static String validateNamespace(String namespace) throws PythonExtensionInvalidException {
        if (StringUtils.trimToNull((String)namespace) == null) {
            throw new PythonExtensionInvalidException(String.format("'namespace' field must not be empty, but was %s", namespace));
        }
        if (namespace.contains(":")) {
            throw new PythonExtensionInvalidException(String.format("'namespace' field must not contain ':', but was %s", namespace));
        }
        return namespace;
    }

    private static boolean getAndValidateBoolean(JsonElement element, boolean defaultIfMissing) {
        if (element == null || element.isJsonNull() || StringUtils.trimToNull((String)element.getAsString()) == null || !element.isJsonPrimitive()) {
            return defaultIfMissing;
        }
        return element.getAsBoolean();
    }

    private static VersionNumber getAndValidateVersion(String version) throws PythonExtensionInvalidException {
        if (StringUtils.trimToNull((String)version) == null) {
            throw new PythonExtensionInvalidException(String.format("'version' field must not be empty, but was %s", version));
        }
        try {
            return new VersionNumber(version);
        }
        catch (VersionNumber.VersionNumberException e) {
            throw new PythonExtensionInvalidException("'version' field must contain a valid version number, e,g. '1.0.0'!", e);
        }
    }

    private static PythonDistribution getAndValidateDistribution(String envString) throws PythonExtensionInvalidException {
        if (StringUtils.trimToNull((String)envString) == null) {
            throw new PythonExtensionInvalidException(String.format("'envString' field must not be empty, but was %s", envString));
        }
        String[] envSplit = envString.split(":");
        if (envSplit.length == 1) {
            return new PythonDistribution(envSplit[0], null);
        }
        if (envSplit.length == 2) {
            return new PythonDistribution(envSplit[0], envSplit[1]);
        }
        LogService.getRoot().log(Level.WARNING, () -> String.format("'envString' field has unexpectedly more than one colon '%s', ignoring middle section", envString));
        return new PythonDistribution(envSplit[0], envSplit[envSplit.length - 1]);
    }

    private static String getAsStringOrNull(JsonObject object, String member) {
        JsonElement element;
        if (object.has(member) && !(element = object.get(member)).isJsonNull()) {
            return element.getAsString();
        }
        return null;
    }

    private static Set<String> getStringSet(JsonArray jsonArray) {
        HashSet<String> result = new HashSet<String>();
        if (jsonArray != null) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                result.add(jsonArray.get(i).getAsString());
            }
        }
        return result;
    }

    private static /* synthetic */ PythonExtensionLoader[] $values() {
        return new PythonExtensionLoader[0];
    }

    static {
        $VALUES = PythonExtensionLoader.$values();
        DISTRIBUTION_LISTENER = (event, pyDist) -> {
            switch (event.getEventType()) {
                case PYTHON_DISTRIBUTION_REGISTERED: {
                    PythonExtensionRegistry.INSTANCE.getAllExtensions().forEach(pyExt -> {
                        if (pyDist.equals(pyExt.getPythonDist()) && pyExt.getCurrentState() == ExtensionState.NOT_READY) {
                            pyExt.setState(ExtensionState.READY);
                        }
                    });
                    break;
                }
                case PYTHON_DISTRIBUTION_UNREGISTERED: {
                    PythonExtensionRegistry.INSTANCE.getAllExtensions().forEach(pyExt -> {
                        if (pyDist.equals(pyExt.getPythonDist()) && pyExt.getCurrentState() == ExtensionState.READY) {
                            pyExt.setState(ExtensionState.NOT_READY);
                        }
                    });
                    break;
                }
            }
        };
        PythonDistributionHandler.INSTANCE.addEventListener(DISTRIBUTION_LISTENER);
    }
}

