/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.loader;

import com.altair.ai.pel.distribution.PythonDistributionHandler;
import com.altair.ai.pel.loader.ExtensionState;
import com.altair.ai.pel.loader.PythonExtension;
import com.altair.ai.pel.loader.PythonExtensionDependency;
import com.altair.ai.pel.loader.PythonExtensionTools;
import com.altair.ai.pel.loader.event.PythonExtensionRegistrationEvent;
import com.altair.ai.pel.loader.event.PythonExtensionRegistryEvent;
import com.altair.ai.pel.loader.event.PythonExtensionRegistryEventListener;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.SecurityTools;
import com.rapidminer.tools.ValidationUtilV2;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Level;

public enum PythonExtensionRegistry {
    INSTANCE;

    private final Map<String, PythonExtension> map = new ConcurrentHashMap<String, PythonExtension>();
    private final List<PythonExtensionRegistryEventListener> listeners = Collections.synchronizedList(new ArrayList());
    private final ExecutorService listenerNotificationService = Executors.newFixedThreadPool(1);

    public void addEventListener(PythonExtensionRegistryEventListener listener) {
        this.listeners.add((PythonExtensionRegistryEventListener)ValidationUtilV2.requireNonNull((Object)listener, (String)"listener"));
    }

    public void removeEventListener(PythonExtensionRegistryEventListener listener) {
        this.listeners.remove(ValidationUtilV2.requireNonNull((Object)listener, (String)"listener"));
    }

    public void registerExtension(PythonExtension pyExt, boolean verifyDependencies) {
        Set<PythonExtensionDependency> missingDependencies;
        ValidationUtilV2.requireNonNull((Object)pyExt, (String)"pyExt");
        LogService.getRoot().log(Level.FINE, () -> String.format("Starting registration of Python extension %s [%s]", pyExt.getName(), pyExt.getVersion().getShortLongVersion()));
        String namespace = pyExt.getNamespace();
        PythonExtension existingExt = this.map.get(namespace);
        if (existingExt != null && existingExt.getCurrentState() != ExtensionState.MISSING_DEPENDENCY) {
            Level duplicateLogLevel;
            Level level = duplicateLogLevel = verifyDependencies ? Level.INFO : Level.FINE;
            if (existingExt.getVersion().isAtLeast(pyExt.getVersion())) {
                LogService.getRoot().log(duplicateLogLevel, () -> String.format("Ignored Python extension %s [%s] because a newer version [%s] is already registered", pyExt.getName(), pyExt.getVersion().getShortLongVersion(), existingExt.getVersion().getShortLongVersion()));
                pyExt.setState(ExtensionState.OLD_VERSION);
                return;
            }
            LogService.getRoot().log(duplicateLogLevel, () -> String.format("Python extension %s [%s] is newer than the previously registered version [%s], replacing", pyExt.getName(), pyExt.getVersion().getShortLongVersion(), existingExt.getVersion().getShortLongVersion()));
            this.unregisterExtension(existingExt, ExtensionState.OLD_VERSION);
        }
        if (verifyDependencies && !(missingDependencies = this.getMissingDependencies(pyExt, new HashMap<String, PythonExtension>(this.map))).isEmpty()) {
            LogService.getRoot().log(Level.WARNING, () -> String.format("Missing dependencies for Python extension '%s': %s", pyExt.getName(), missingDependencies));
            pyExt.setMissingDependencies(missingDependencies);
            this.unregisterExtension(pyExt, ExtensionState.MISSING_DEPENDENCY);
            return;
        }
        PythonExtensionTools.registerExtension(pyExt);
        this.map.put(namespace, pyExt);
        if (verifyDependencies) {
            this.updateExtensionRegistrationsRelatedToMissingDependencies(true);
        }
        pyExt.setState(ExtensionState.NOT_READY);
        this.fireRegistryEvent(PythonExtensionRegistrationEvent.PYTHON_EXTENSION_REGISTERED, pyExt);
    }

    public void unregisterAllExtensions() {
        SecurityTools.requireInternalPermission();
        this.map.values().forEach(ext -> this.unregisterExtension((PythonExtension)ext, ExtensionState.UNLOADED));
    }

    public PythonExtension getExtensionForNamespace(String namespace) {
        return this.map.get(ValidationUtilV2.requireNonNull((Object)namespace, (String)"namespace"));
    }

    public List<PythonExtension> getAllExtensions() {
        return new ArrayList<PythonExtension>(this.map.values());
    }

    public void updateExtensionRegistrationsRelatedToMissingDependencies(boolean recheckAlreadyMissing) {
        HashMap<String, PythonExtension> copyOfExtensionMap = new HashMap<String, PythonExtension>(this.map);
        for (PythonExtension extension : copyOfExtensionMap.values()) {
            Set<PythonExtensionDependency> missingDependencies;
            if (recheckAlreadyMissing && extension.getCurrentState() == ExtensionState.MISSING_DEPENDENCY) {
                missingDependencies = this.getMissingDependencies(extension, new HashMap<String, PythonExtension>(copyOfExtensionMap));
                if (!missingDependencies.isEmpty()) continue;
                extension.setMissingDependencies(Collections.emptySet());
                this.registerExtension(extension, false);
                PythonDistributionHandler.INSTANCE.registerDistributionForExtension(extension);
                continue;
            }
            missingDependencies = this.getMissingDependencies(extension, new HashMap<String, PythonExtension>(copyOfExtensionMap));
            if (missingDependencies.isEmpty()) continue;
            LogService.getRoot().log(Level.WARNING, () -> String.format("Missing dependencies for Python extension '%s': %s", extension.getName(), missingDependencies));
            extension.setMissingDependencies(missingDependencies);
            this.unregisterExtension(extension, ExtensionState.MISSING_DEPENDENCY);
        }
    }

    private Set<PythonExtensionDependency> getMissingDependencies(PythonExtension extension, Map<String, PythonExtension> extensionMap) {
        HashSet<PythonExtensionDependency> missingDependencies = new HashSet<PythonExtensionDependency>();
        extensionMap.remove(extension.getNamespace());
        extension.getDependencies().forEach(dependency -> {
            if (!extensionMap.containsKey(dependency.getNamespace()) || dependency.getMinVersion().isAbove(((PythonExtension)extensionMap.get(dependency.getNamespace())).getVersion())) {
                missingDependencies.add((PythonExtensionDependency)dependency);
            } else {
                missingDependencies.addAll(this.getMissingDependencies((PythonExtension)extensionMap.get(dependency.getNamespace()), extensionMap));
            }
        });
        extensionMap.put(extension.getNamespace(), extension);
        return missingDependencies;
    }

    private void unregisterExtension(PythonExtension pyExt, ExtensionState finalState) {
        ValidationUtilV2.requireNonNull((Object)pyExt, (String)"pyExt");
        PythonExtension unregisteredPyExt = pyExt;
        if (finalState == ExtensionState.MISSING_DEPENDENCY) {
            PythonExtensionTools.unregisterExtension(unregisteredPyExt);
            unregisteredPyExt.setState(finalState);
            this.fireRegistryEvent(PythonExtensionRegistrationEvent.PYTHON_EXTENSION_BROKEN, unregisteredPyExt);
        } else {
            PythonExtension removedExt = this.map.remove(pyExt.getNamespace());
            if (removedExt != null) {
                unregisteredPyExt = removedExt;
                PythonExtensionTools.unregisterExtension(unregisteredPyExt);
                unregisteredPyExt.setState(finalState);
                this.fireRegistryEvent(PythonExtensionRegistrationEvent.PYTHON_EXTENSION_UNREGISTERED, unregisteredPyExt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRegistryEvent(PythonExtensionRegistrationEvent type, PythonExtension pyExt) {
        List<PythonExtensionRegistryEventListener> list = this.listeners;
        synchronized (list) {
            for (PythonExtensionRegistryEventListener listener : this.listeners) {
                this.notifyListener(() -> listener.pythonExtensionRegistrationChanged(new PythonExtensionRegistryEvent(type), pyExt));
            }
        }
    }

    private void notifyListener(Runnable r) {
        try {
            this.listenerNotificationService.submit(r);
        }
        catch (RejectedExecutionException e) {
            LogService.getRoot().log(Level.WARNING, "Failed to notify listener about Python extension registry event", e);
        }
    }
}

