/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.loader;

import com.altair.ai.pel.loader.PythonExtension;
import com.altair.ai.pel.loader.PythonOperatorDescription;
import com.altair.ai.pel.util.FileTools;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.settings.Settings;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.OperatorService;
import com.rapidminer.tools.ValidationUtilV2;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Level;
import org.apache.commons.lang3.StringUtils;

public final class PythonExtensionTools
extends Enum<PythonExtensionTools> {
    private static final /* synthetic */ PythonExtensionTools[] $VALUES;

    public static PythonExtensionTools[] values() {
        return (PythonExtensionTools[])$VALUES.clone();
    }

    public static PythonExtensionTools valueOf(String name) {
        return Enum.valueOf(PythonExtensionTools.class, name);
    }

    public static Path getExtensionLookupDirectory() {
        Path lookupDir = null;
        String pyExtLocationString = Settings.getSetting((String)"altair-library", (String)"pysdk.pel.extLoc");
        if (StringUtils.trimToNull((String)pyExtLocationString) == null) {
            pyExtLocationString = System.getProperty("pysdk.pel.extLoc");
        }
        if (StringUtils.trimToNull((String)pyExtLocationString) == null) {
            pyExtLocationString = System.getenv("PYSDK_PEL_EXT_LOC");
        }
        if (StringUtils.trimToNull((String)pyExtLocationString) != null) {
            try {
                lookupDir = Paths.get(pyExtLocationString, new String[0]);
                if (!Files.isDirectory(lookupDir, new LinkOption[0])) {
                    throw new IllegalArgumentException(String.format("Failed to use setting/property/env-var with value '%s' to set the Python extension lookup directory, path is not a directory", pyExtLocationString));
                }
            }
            catch (InvalidPathException e) {
                throw new IllegalArgumentException(String.format("Failed to use setting/property/env-var with value '%s' to set the Python extension lookup directory, path is not a directory", pyExtLocationString));
            }
        }
        if (lookupDir == null) {
            lookupDir = FileTools.getPythonExtensionLookupDirectory();
        }
        return lookupDir;
    }

    static void registerExtension(PythonExtension pyExt) {
        ValidationUtilV2.requireNonNull((Object)pyExt, (String)"pyExt");
        if (pyExt.getPythonOperatorDescriptions().isEmpty()) {
            LogService.getRoot().log(Level.WARNING, () -> String.format("Python extension %s from %s contains no operators!", pyExt.getName(), pyExt.getSource().getFileName()));
            return;
        }
        for (PythonOperatorDescription pyOpDesc : pyExt.getPythonOperatorDescriptions()) {
            try {
                OperatorService.registerOperator((OperatorDescription)pyOpDesc, null);
            }
            catch (OperatorCreationException e) {
                LogService.getRoot().log(Level.SEVERE, e, () -> String.format("Failed to register operator %s for Python extension %s", pyOpDesc.getKey(), pyExt.getName()));
            }
        }
    }

    static void unregisterExtension(PythonExtension pyExt) {
        ValidationUtilV2.requireNonNull((Object)pyExt, (String)"pyExt");
        pyExt.getPythonOperatorDescriptions().forEach(OperatorService::unregisterOperator);
    }

    private static /* synthetic */ PythonExtensionTools[] $values() {
        return new PythonExtensionTools[0];
    }

    static {
        $VALUES = PythonExtensionTools.$values();
    }
}

