/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.loader;

import com.altair.ai.pel.loader.PythonExtension;
import com.altair.ai.pel.loader.model.ExpectedConnection;
import com.altair.ai.pel.loader.model.ExpectedInput;
import com.altair.ai.pel.loader.model.ExpectedOutput;
import com.altair.ai.pel.loader.model.ExpectedParameter;
import com.altair.ai.pel.operator.PythonOperator;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.tools.documentation.OperatorDocBundle;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class PythonOperatorDescription
extends OperatorDescription {
    private final PythonExtension extension;
    private final String key;
    private final String function;
    private final ExpectedConnection connection;
    private final List<ExpectedParameter> parameters;
    private final List<ExpectedInput> expectedInputs;
    private final List<ExpectedOutput> expectedOutputs;
    private final Consumer<Operator> initializer;

    PythonOperatorDescription(PythonExtension extension, String groupKey, String key, String iconName, OperatorDocBundle bundle, String function, ExpectedConnection connection, List<ExpectedInput> expectedInputs, List<ExpectedOutput> expectedOutputs, List<ExpectedParameter> parameters, Consumer<Operator> initializer) {
        super(PythonOperatorDescription.getGroupKey(groupKey, extension.getName(), extension.isListingOperatorsAtRootLevel()), key, PythonOperator.class, null, iconName, extension.getProvider(), bundle);
        this.extension = extension;
        this.key = key;
        this.function = function;
        this.connection = connection;
        this.expectedInputs = expectedInputs;
        this.expectedOutputs = expectedOutputs;
        this.parameters = parameters;
        this.initializer = initializer;
    }

    public String getKey() {
        return this.extension.getNamespace() + ":" + this.key;
    }

    public String getProviderName() {
        return this.extension.getName();
    }

    public boolean isUsingExtensionTreeRoot() {
        return this.extension.isListingOperatorsAtRootLevel();
    }

    public PythonExtension getExtension() {
        return this.extension;
    }

    public String getFunction() {
        return this.function;
    }

    public ExpectedConnection getConnection() {
        return this.connection;
    }

    public List<ExpectedInput> getExpectedInputs() {
        return this.expectedInputs;
    }

    public List<ExpectedOutput> getExpectedOutputs() {
        return this.expectedOutputs;
    }

    public List<ParameterType> createParameterTypes(PythonOperator operator) {
        return this.parameters.stream().map(expectedParameter -> expectedParameter.getAnnotatedParameterType(operator)).collect(Collectors.toList());
    }

    public Consumer<Operator> getInitializer() {
        return this.initializer;
    }

    public List<String> getSources() {
        return this.extension.getTransitiveSources().stream().map(Path::toAbsolutePath).map(Path::toString).collect(Collectors.toList());
    }

    public String getModule() {
        return this.extension.getModule();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PythonOperatorDescription that = (PythonOperatorDescription)((Object)o);
        return Objects.equals(this.key, that.key) && Objects.equals(this.function, that.function) && Objects.equals(this.expectedInputs, that.expectedInputs) && Objects.equals(this.expectedOutputs, that.expectedOutputs);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.key, this.function, this.expectedInputs, this.expectedOutputs);
    }

    public String toString() {
        return "PythonOperatorDescription{key='" + this.key + "', function='" + this.function + "'}";
    }

    private static String getGroupKey(String groupKey, String extensionName, boolean listOperatorsAtRootLevel) {
        if (listOperatorsAtRootLevel) {
            if (StringUtils.trimToNull((String)groupKey) == null) {
                throw new IllegalArgumentException("Python extension group key must not be empty when listing operators at root level!");
            }
            return groupKey;
        }
        return String.format("extensions.%s%s", extensionName.toLowerCase().replace(" ", "_"), groupKey != null ? "." + groupKey : "");
    }
}

