/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.loader;

import com.altair.ai.pel.loader.PythonExtension;
import com.altair.ai.pel.loader.PythonOperatorDescription;
import com.altair.ai.pel.loader.PythonOperatorDocBundle;
import com.altair.ai.pel.loader.model.ExpectedConnection;
import com.altair.ai.pel.loader.model.ExpectedInput;
import com.altair.ai.pel.loader.model.ExpectedOutput;
import com.altair.ai.pel.loader.model.ExpectedParameter;
import com.altair.ai.pel.operator.MetaDataPythonInternalObjectError;
import com.altair.ai.pel.operator.PythonInternalIOObject;
import com.altair.ai.pel.operator.PythonInternalIOObjectMetaData;
import com.altair.ai.pel.operator.PythonOperator;
import com.altair.ai.pel.operator.PythonOperatorChainTools;
import com.altair.ai.pel.python.exception.PythonExtensionInvalidException;
import com.altair.ai.pel.python.util.PythonOperatorTools;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.PortOwner;
import com.rapidminer.operator.ports.metadata.GenerateNewMDRule;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.MetaDataError;
import com.rapidminer.operator.ports.metadata.Precondition;
import com.rapidminer.operator.ports.metadata.SupplierSimplePrecondition;
import com.rapidminer.tools.ValidationUtilV2;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

final class PythonOperatorParser
extends Enum<PythonOperatorParser> {
    private static final String DEFAULT_ICON = "gearwheel.png";
    private static final /* synthetic */ PythonOperatorParser[] $VALUES;

    public static PythonOperatorParser[] values() {
        return (PythonOperatorParser[])$VALUES.clone();
    }

    public static PythonOperatorParser valueOf(String name) {
        return Enum.valueOf(PythonOperatorParser.class, name);
    }

    static List<PythonOperatorDescription> parseOperators(PythonExtension pyExt, JsonObject root) throws PythonExtensionInvalidException {
        try {
            JsonObject extension = root.getAsJsonObject("extension");
            String extName = extension.get("name").getAsString();
            JsonObject operators = root.getAsJsonObject("operators");
            ArrayList<PythonOperatorDescription> list = new ArrayList<PythonOperatorDescription>(operators.size());
            for (String key : operators.keySet()) {
                JsonObject operator = operators.getAsJsonObject(key);
                String opName = operator.get("name").getAsString();
                String opSyn = PythonOperatorParser.getAsStringOrNull(operator, "synopsis");
                String opDesc = PythonOperatorParser.getAsStringOrNull(operator, "description");
                String opGroup = PythonOperatorParser.getAsStringOrNull(operator, "group_key");
                String icon = Optional.ofNullable(PythonOperatorParser.getAsStringOrNull(operator, "icon")).orElse(DEFAULT_ICON);
                String function = ValidationUtilV2.requireNonEmptyString((String)PythonOperatorParser.getAsStringOrNull(operator, "implementation"), (String)"implementation");
                ArrayList<String> tags = new ArrayList<String>();
                tags.add(extName);
                PythonOperatorParser.getAsArrayOrEmpty(operator.get("tags")).forEach(tag -> tags.add(tag.getAsString()));
                PythonOperatorDocBundle bundle = new PythonOperatorDocBundle(key, opName, tags, opSyn, opDesc);
                ExpectedConnection connection = PythonOperatorParser.readConnection(operator.get("connection"));
                List<ExpectedParameter> parameters = PythonOperatorParser.readParameters(PythonOperatorParser.getAsArrayOrEmpty(operator.get("parameters")));
                List<ExpectedInput> expectedInputs = PythonOperatorParser.readInputPorts(PythonOperatorParser.getAsArrayOrEmpty(operator.get("inputs")));
                List<ExpectedOutput> expectedOutputs = PythonOperatorParser.readOutputPorts(PythonOperatorParser.getAsArrayOrEmpty(operator.get("outputs")));
                list.add(new PythonOperatorDescription(pyExt, opGroup, key, icon, bundle, function, connection, expectedInputs, expectedOutputs, parameters, PythonOperatorParser.addPorts(pyExt, expectedInputs, expectedOutputs)));
            }
            return list;
        }
        catch (RuntimeException e) {
            throw new PythonExtensionInvalidException(e);
        }
    }

    private static List<ExpectedParameter> readParameters(JsonArray params) {
        return StreamSupport.stream(params.spliterator(), true).map(JsonElement::getAsJsonObject).map(ExpectedParameter::new).collect(Collectors.toList());
    }

    private static Consumer<Operator> addPorts(PythonExtension pyExt, List<ExpectedInput> expectedInputs, List<ExpectedOutput> expectedOutputs) {
        return operator -> {
            InputPort createdPort;
            for (ExpectedInput input : expectedInputs) {
                createdPort = (InputPort)operator.getInputPorts().createPort(input.getName());
                createdPort.addPrecondition((Precondition)new SupplierSimplePrecondition(createdPort, () -> PythonOperatorTools.createMetaDataForDataClass(input.getDataClass(), input.isCollection(), pyExt.getSerializableDataClasses()), !input.isOptional()));
            }
            for (ExpectedOutput output : expectedOutputs) {
                createdPort = (OutputPort)operator.getOutputPorts().createPort(output.getName());
                Class<? extends IOObject> ioClass = PythonOperatorTools.getIOObjectClassForDataClass(output.getDataClass(), pyExt.getSerializableDataClasses().keySet());
                if (PythonInternalIOObject.class.isAssignableFrom(ioClass)) {
                    operator.getTransformer().addRule((MDTransformationRule)new GenerateNewMDRule((OutputPort)createdPort, new PythonInternalIOObjectMetaData(output.getDataClass()), (OutputPort)createdPort){
                        final /* synthetic */ OutputPort val$createdPort;
                        {
                            this.val$createdPort = outputPort;
                            super(arg0, arg1);
                        }

                        public void transformMD() {
                            InputPort targetPort;
                            Operator targetOp;
                            super.transformMD();
                            if (this.val$createdPort.isConnected() && (targetOp = (Operator)Optional.ofNullable((targetPort = this.val$createdPort.getOpposite()).getPorts().getOwner()).map(PortOwner::getOperator).orElse(null)) != null && !(targetOp instanceof PythonOperator) && !PythonOperatorChainTools.ALLOWED_ORCHESTRATORS.contains(targetOp.getClass())) {
                                this.val$createdPort.addError((MetaDataError)new MetaDataPythonInternalObjectError((Port)this.val$createdPort));
                            }
                        }
                    });
                    continue;
                }
                MetaData outputMd = PythonOperatorTools.createMetaDataForDataClass(output.getDataClass(), output.isCollection(), pyExt.getSerializableDataClasses());
                operator.getTransformer().addRule((MDTransformationRule)new GenerateNewMDRule((OutputPort)createdPort, outputMd));
            }
        };
    }

    private static ExpectedConnection readConnection(JsonElement connectionJson) {
        if (connectionJson == null || !connectionJson.isJsonObject()) {
            return null;
        }
        JsonObject connection = connectionJson.getAsJsonObject();
        return new ExpectedConnection(connection.get("name").getAsString(), connection.get("type").getAsString(), connection.get("optional").getAsBoolean());
    }

    private static List<ExpectedInput> readInputPorts(JsonArray ports) {
        ArrayList<ExpectedInput> list = new ArrayList<ExpectedInput>();
        for (JsonElement port : ports) {
            JsonObject portJson = port.getAsJsonObject();
            list.add(new ExpectedInput(portJson.get("name").getAsString(), portJson.get("type").getAsString(), portJson.get("optional").getAsBoolean(), PythonOperatorParser.getAsBoolean(portJson, "collection", false)));
        }
        return list;
    }

    private static List<ExpectedOutput> readOutputPorts(JsonArray ports) {
        ArrayList<ExpectedOutput> list = new ArrayList<ExpectedOutput>();
        for (JsonElement port : ports) {
            JsonObject portJson = port.getAsJsonObject();
            list.add(new ExpectedOutput(portJson.get("name").getAsString(), portJson.get("type").getAsString(), PythonOperatorParser.getAsBoolean(portJson, "collection", false)));
        }
        return list;
    }

    private static String getAsStringOrNull(JsonObject object, String member) {
        JsonElement element;
        if (object.has(member) && !(element = object.get(member)).isJsonNull()) {
            return element.getAsString();
        }
        return null;
    }

    private static boolean getAsBoolean(JsonObject object, String member, boolean defaultValue) {
        JsonElement element;
        if (object.has(member) && !(element = object.get(member)).isJsonNull()) {
            return element.getAsBoolean();
        }
        return defaultValue;
    }

    private static JsonArray getAsArrayOrEmpty(JsonElement potentialArray) {
        if (potentialArray != null && potentialArray.isJsonArray()) {
            return potentialArray.getAsJsonArray();
        }
        return new JsonArray();
    }

    private static /* synthetic */ PythonOperatorParser[] $values() {
        return new PythonOperatorParser[0];
    }

    static {
        $VALUES = PythonOperatorParser.$values();
    }
}

