/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.loader.model;

import com.altair.ai.pel.loader.model.ExpectedParameterCondition;
import com.altair.ai.pel.loader.model.annotation.ConditionalParameterAnnotation;
import com.altair.ai.pel.loader.model.annotation.ExpectedParameterAnnotation;
import com.altair.ai.pel.loader.model.annotation.SelectedColumnAnnotation;
import com.altair.ai.pel.loader.model.annotation.TextParameterAnnotation;
import com.altair.ai.pel.operator.PythonOperator;
import com.altair.ai.pel.python.exception.PythonExtensionInvalidException;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeAttributeSubset;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeEnumeration;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.ParameterTypeText;
import com.rapidminer.parameter.ParameterTypeTupel;
import com.rapidminer.parameter.conditions.AndParameterCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import com.rapidminer.tools.LogService;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class ExpectedParameter {
    private final String name;
    private final String type;
    private final String description;
    private final JsonElement defaultValue;
    private final boolean optional;
    private final JsonElement categoriesElement;
    private final List<ExpectedParameterAnnotation> annotations;
    private final List<ExpectedParameter> innerTypes = new ArrayList<ExpectedParameter>();

    public ExpectedParameter(JsonObject object) {
        this.name = object.get("name").getAsString();
        this.type = object.get("type").getAsString();
        this.description = object.get("description").getAsString();
        this.defaultValue = object.get("default").isJsonNull() ? null : object.get("default");
        this.optional = this.defaultValue != null || object.get("optional").getAsBoolean();
        this.categoriesElement = object.get("categories");
        this.annotations = this.parseAnnotations(object.get("annotations"));
        if (object.has("inner_types") && object.get("inner_types").isJsonArray()) {
            StreamSupport.stream(object.getAsJsonArray("inner_types").spliterator(), false).map(JsonElement::getAsJsonObject).map(ExpectedParameter::new).forEach(this.innerTypes::add);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExpectedParameter that = (ExpectedParameter)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hashCode(this.name);
    }

    public String toString() {
        return "PythonParameter{name='" + this.name + "', type='" + this.type + "', description='" + this.description + "', defaultValue=" + this.defaultValue + ", optional=" + this.optional + ", categoriesElement=" + this.categoriesElement + ", annotations=" + this.annotations + ", innerTypes=" + this.innerTypes + "}";
    }

    public ParameterType getAnnotatedParameterType(PythonOperator operator) {
        ParameterType parameterType;
        if (this.isAnnotatedWith(SelectedColumnAnnotation.class)) {
            SelectedColumnAnnotation selectedColumnAnnotation = this.getAnnotations(SelectedColumnAnnotation.class).findFirst().get();
            InputPort inputport = (InputPort)operator.getInputPorts().getPortByName(selectedColumnAnnotation.getInputKey());
            if (Objects.equals(this.type, "string")) {
                parameterType = new ParameterTypeAttribute(this.name, this.description, inputport, this.optional);
            } else if (Objects.equals(this.type, "list")) {
                parameterType = new ParameterTypeAttributeSubset(this.name, this.description, inputport, this.optional);
            } else {
                LogService.getRoot().log(Level.WARNING, String.format("Unsupported parameter type '%s' for SelectedColumnAnnotation", this.type));
                parameterType = this.getParameterType(operator);
            }
        } else if (this.isAnnotatedWith(TextParameterAnnotation.class)) {
            TextParameterAnnotation textParameterAnnotation = this.getAnnotations(TextParameterAnnotation.class).findFirst().get();
            parameterType = ExpectedParameter.configureParameter((ParameterType)new ParameterTypeText(this.name, this.description, textParameterAnnotation.getTextType()), this.defaultValue != null ? this.defaultValue.getAsString() : null, this.optional);
        } else {
            parameterType = this.getParameterType(operator);
        }
        if (this.isAnnotatedWith(ConditionalParameterAnnotation.class)) {
            ParameterCondition[] conditions = (ParameterCondition[])this.getAnnotations(ConditionalParameterAnnotation.class).map(ann -> new ExpectedParameterCondition(operator, ann.getParameterKey(), !this.optional, ann.getParameterValue(), ann.getComparatorType().equals("!="))).toArray(ParameterCondition[]::new);
            AndParameterCondition condition = new AndParameterCondition((ParameterHandler)operator, !this.optional, conditions);
            parameterType.registerDependencyCondition((ParameterCondition)condition);
        }
        return parameterType;
    }

    private ParameterType getParameterType(PythonOperator operator) {
        switch (this.type) {
            case "list": {
                ParameterType listType = this.innerTypes.get(0).getAnnotatedParameterType(operator);
                return ExpectedParameter.configureParameter((ParameterType)new ParameterTypeEnumeration(this.name, this.description, listType), null, this.optional);
            }
            case "tuple": {
                ParameterType[] tupleTypes = (ParameterType[])this.innerTypes.stream().map(param -> param.getAnnotatedParameterType(operator)).toArray(ParameterType[]::new);
                return ExpectedParameter.configureParameter((ParameterType)new ParameterTypeTupel(this.name, this.description, tupleTypes), null, this.optional);
            }
            case "dict": {
                ParameterType keyType = this.innerTypes.get(0).getAnnotatedParameterType(operator);
                ParameterType valueType = this.innerTypes.get(1).getAnnotatedParameterType(operator);
                return ExpectedParameter.configureParameter((ParameterType)new ParameterTypeList(this.name, this.description, keyType, valueType), null, this.optional);
            }
            case "integer": {
                return ExpectedParameter.configureParameter((ParameterType)new ParameterTypeInt(this.name, this.description, Integer.MIN_VALUE, Integer.MAX_VALUE), this.defaultValue != null ? Integer.valueOf(this.defaultValue.getAsInt()) : null, this.optional);
            }
            case "real": {
                return ExpectedParameter.configureParameter((ParameterType)new ParameterTypeDouble(this.name, this.description, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY), this.defaultValue != null ? Double.valueOf(this.defaultValue.getAsDouble()) : null, this.optional);
            }
            case "boolean": {
                return ExpectedParameter.configureParameter((ParameterType)new ParameterTypeBoolean(this.name, this.description, false), this.defaultValue != null ? Boolean.valueOf(this.defaultValue.getAsBoolean()) : null, this.optional);
            }
            case "category": {
                List categories = StreamSupport.stream(this.categoriesElement.getAsJsonArray().spliterator(), true).map(JsonElement::getAsString).collect(Collectors.toList());
                int index = this.defaultValue == null ? 0 : categories.indexOf(this.defaultValue.getAsString());
                return ExpectedParameter.configureParameter((ParameterType)new ParameterTypeCategory(this.name, this.description, (String[])categories.toArray(String[]::new), index), null, this.optional);
            }
        }
        return ExpectedParameter.configureParameter((ParameterType)new ParameterTypeString(this.name, this.description), this.defaultValue != null ? this.defaultValue.getAsString() : null, this.optional);
    }

    private List<ExpectedParameterAnnotation> parseAnnotations(JsonElement annotationsElement) {
        ArrayList<ExpectedParameterAnnotation> parsedAnnotations = new ArrayList<ExpectedParameterAnnotation>();
        if (annotationsElement == null || !annotationsElement.isJsonArray()) {
            return parsedAnnotations;
        }
        for (JsonElement annotationElement : annotationsElement.getAsJsonArray()) {
            if (annotationElement == null || !annotationElement.isJsonArray() || annotationElement.getAsJsonArray().isEmpty()) continue;
            JsonArray annotationsArray = annotationElement.getAsJsonArray();
            try {
                ExpectedParameterAnnotation annotation;
                switch (annotationsArray.get(0).getAsString()) {
                    case "SelectedColumnAnnotation": {
                        annotation = new SelectedColumnAnnotation(annotationsArray);
                        break;
                    }
                    case "ConditionalAnnotation": {
                        annotation = new ConditionalParameterAnnotation(annotationsArray);
                        break;
                    }
                    case "TextParameterAnnotation": {
                        annotation = new TextParameterAnnotation(annotationsArray);
                        break;
                    }
                    default: {
                        throw new PythonExtensionInvalidException(String.format("Unsupported parameter annotation type '%s'", annotationsArray.get(0).getAsString()));
                    }
                }
                parsedAnnotations.add(annotation);
            }
            catch (PythonExtensionInvalidException e) {
                LogService.getRoot().log(Level.WARNING, e::getMessage);
            }
        }
        return parsedAnnotations;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isAnnotatedWith(Class<? extends ExpectedParameterAnnotation> annotationType) {
        if (this.annotations == null) return false;
        if (!this.annotations.stream().anyMatch(annotationType::isInstance)) return false;
        return true;
    }

    private <A extends ExpectedParameterAnnotation> Stream<A> getAnnotations(Class<A> annotationType) {
        return this.annotations.stream().filter(annotationType::isInstance).map(annotationType::cast);
    }

    private static ParameterType configureParameter(ParameterType p, Object defaultValue, boolean optional) {
        if (defaultValue != null) {
            p.setDefaultValue(defaultValue);
        }
        p.setOptional(optional);
        p.setExpert(false);
        return p;
    }
}

