/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.loader.model;

import com.altair.ai.pel.operator.PythonOperator;
import com.rapidminer.io.process.XMLTools;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.ParameterCondition;
import com.rapidminer.tools.XMLException;
import java.util.Objects;
import org.w3c.dom.Element;

public class ExpectedParameterCondition
extends ParameterCondition {
    private static final String ELEMENT_CONDITION_VALUE = "ConditionValue";
    private static final String ELEMENT_NEGATION = "Negation";
    private final String conditionValue;
    private final boolean negation;

    public ExpectedParameterCondition(Element conditionElement) throws XMLException {
        super(conditionElement);
        this.conditionValue = String.valueOf(XMLTools.getTagContents((Element)conditionElement, (String)ELEMENT_CONDITION_VALUE, (boolean)true));
        this.negation = Boolean.parseBoolean(XMLTools.getTagContents((Element)conditionElement, (String)ELEMENT_NEGATION, (boolean)true));
    }

    public ExpectedParameterCondition(PythonOperator operator, String conditionParameter, boolean becomeMandatory, String conditionValue, boolean negation) {
        super((ParameterHandler)operator, conditionParameter, becomeMandatory);
        this.conditionValue = conditionValue;
        this.negation = negation;
    }

    public boolean isConditionFullfilled() {
        try {
            boolean match;
            ParameterType parameterType = ((PythonOperator)this.parameterHandler).getParameterType(this.conditionParameter);
            if (parameterType instanceof ParameterTypeBoolean) {
                match = this.parameterHandler.getParameterAsBoolean(this.conditionParameter) == Boolean.parseBoolean(this.conditionValue);
            } else if (parameterType instanceof ParameterTypeString) {
                String currentValue = this.parameterHandler.getParameterAsString(this.conditionParameter);
                match = Objects.equals(currentValue, this.conditionValue);
            } else if (parameterType instanceof ParameterTypeCategory) {
                String currentValue = ((ParameterTypeCategory)parameterType).getCategory(this.parameterHandler.getParameterAsInt(this.conditionParameter));
                match = Objects.equals(currentValue, this.conditionValue);
            } else {
                return false;
            }
            return match ^ this.negation;
        }
        catch (UndefinedParameterError e) {
            return this.conditionValue == null ^ this.negation;
        }
    }

    public String toString() {
        return "ExpectedParameterCondition{conditionValue='" + this.conditionValue + "', negation=" + this.negation + "}";
    }

    public void getDefinitionAsXML(Element element) {
        XMLTools.addTag((Element)element, (String)ELEMENT_CONDITION_VALUE, (String)this.conditionParameter);
        XMLTools.addTag((Element)element, (String)ELEMENT_NEGATION, (String)String.valueOf(this.negation));
    }
}

