/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.loader.model.annotation;

import com.altair.ai.pel.python.exception.PythonExtensionInvalidException;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.Objects;

public abstract class ExpectedParameterAnnotation {
    protected final JsonArray parameters;

    public ExpectedParameterAnnotation(JsonArray parameters) throws PythonExtensionInvalidException {
        if (parameters == null || parameters.size() != this.getParameterCount() + 1) {
            throw new PythonExtensionInvalidException("Invalid number of annotation parameters");
        }
        this.parameters = parameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExpectedParameterAnnotation that = (ExpectedParameterAnnotation)o;
        return Objects.equals(this.parameters, that.parameters);
    }

    public int hashCode() {
        return Objects.hashCode(this.parameters);
    }

    public String toString() {
        return "ExpectedParameterAnnotation{parameters=" + this.parameters + "}";
    }

    protected JsonElement getParameter(int index) {
        return this.parameters.get(index + 1);
    }

    protected abstract int getParameterCount();
}

