/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.miniforge;

import com.altair.ai.pel.miniforge.MiniforgeConfigModifier;
import com.altair.ai.pel.miniforge.MiniforgeStatus;
import com.altair.ai.pel.python.exception.MiniforgeException;
import com.altair.ai.pel.python.exception.PythonDistributionInstallationException;
import com.altair.ai.pel.python.listener.MiniforgeListener;
import com.altair.ai.pel.python.settings.PythonSDKSettings;
import com.altair.ai.pel.python.util.PythonDistributionTools;
import com.altair.ai.pel.util.ExternalProcess;
import com.altair.ai.pel.util.ExternalProcessBuilder;
import com.altair.ai.pel.util.ExternalProcessTools;
import com.altair.ai.pel.util.FileBackup;
import com.altair.ai.pel.util.FileTools;
import com.altair.ai.pel.util.OSArch;
import com.altair.ai.pel.util.OSTools;
import com.altair.ai.pel.util.WindowsRegistryHelper;
import com.rapidminer.gui.tools.VersionNumber;
import com.rapidminer.tools.FileUtils;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.SecurityTools;
import com.rapidminer.tools.SystemInfoUtilities;
import com.rapidminer.tools.TempFileTools;
import com.rapidminer.tools.ValidationUtilV2;
import com.sun.jna.platform.win32.Shell32Util;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;

public enum MiniforgeHandler {
    INSTANCE;

    public static final String ENVIRONMENT_KEY_CRYPTOGRAPHY_OPENSSL_NO_LEGACY = "CRYPTOGRAPHY_OPENSSL_NO_LEGACY";
    public static final String ENVIRONMENT_KEY_CONDA_ENVS_PATH = "CONDA_ENVS_PATH";
    public static final String ENVIRONMENT_KEY_HOME = "HOME";
    private static final String CONDA_REQUIRED_VERSION = "24.11.0";
    private static final String MINIFORGE_VERSION = "24.11.0-1";
    private static final String MINIFORGE_FILENAME_WINDOWS_X86_64;
    private static final String MINIFORGE_FILENAME_MACOS_ARM64;
    private static final String MINIFORGE_FILENAME_MACOS_X86_64;
    private static final String MINIFORGE_FILENAME_LINUX_ARM64;
    private static final String MINIFORGE_FILENAME_LINUX_PPC64LE;
    private static final String MINIFORGE_FILENAME_LINUX_X86_64;
    private static final String MINIFORGE_DOWNLOAD_URL_TEMPLATE = "https://github.com/conda-forge/miniforge/releases/download/%s/%s";
    private static final String MINIFORGE_RESOURCE_PARTH = "/com/altair/extension/resources/miniforge";
    private static final String CONFIG_KEY_SOLVER = "solver";
    private static final String CONFIG_VALUE_SOLVER_MAMBA = "libmamba";
    private static final String CONFIG_KEY_BLACKLIST = "denylist_channels";
    private static final String CONFIG_KEY_IGNORE_UNREACHABLE_CHANNELS = "allow_non_channel_urls";
    private static final String[] ANACONDA_CHANNELS;
    private final List<MiniforgeListener> listenerList = Collections.synchronizedList(new ArrayList());
    private final ExecutorService listenerNotificationService = Executors.newFixedThreadPool(1);
    private final Path installationDirectory;
    private MiniforgeStatus status = MiniforgeStatus.UNKNOWN;

    private MiniforgeHandler() {
        this.installationDirectory = PythonSDKSettings.getMiniforgeDir();
        this.setStatus(MiniforgeStatus.DISABLED);
    }

    public void addMiniforgeListener(MiniforgeListener listener) {
        this.listenerList.add((MiniforgeListener)ValidationUtilV2.requireNonNull((Object)listener, (String)"listener"));
        this.notifyListeners(Collections.singletonList(listener), this.status);
    }

    public void removeMiniforgeListener(MiniforgeListener listener) {
        this.listenerList.remove(ValidationUtilV2.requireNonNull((Object)listener, (String)"listener"));
    }

    public synchronized boolean isMiniforgeInstalled() throws MiniforgeException {
        try {
            if (!Files.isDirectory(this.installationDirectory, new LinkOption[0]) || FileUtils.isDirectoryEmpty((Path)this.installationDirectory)) {
                return false;
            }
            switch (OSTools.getOperatingSystem()) {
                case WINDOWS: {
                    if (Files.exists(this.installationDirectory.resolve("python.exe"), new LinkOption[0])) break;
                    return false;
                }
                default: {
                    if (Files.exists(this.installationDirectory.resolve("bin").resolve("python"), new LinkOption[0])) break;
                    return false;
                }
            }
            if (!Files.exists(this.getMiniforgeExecutable(), new LinkOption[0])) {
                return false;
            }
        }
        catch (IOException e) {
            throw new MiniforgeException("Failed to check Miniforge installation target folder", e);
        }
        if (!this.isCondaVersionHighEnough()) {
            LogService.getRoot().log(Level.INFO, "Miniforge already installed, but it is outdated. Replacing with newer version.");
            return false;
        }
        this.setStatus(MiniforgeStatus.NOT_YET_INITIALIZED);
        return true;
    }

    public synchronized void installMiniforge() throws MiniforgeException {
        block40: {
            String installerSHA256Resource;
            String fileName;
            this.setStatus(MiniforgeStatus.INSTALLING);
            try {
                if (Files.exists(this.installationDirectory, new LinkOption[0])) {
                    org.apache.commons.io.FileUtils.deleteQuietly((File)this.installationDirectory.toFile());
                }
                Files.createDirectories(this.installationDirectory.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                this.setStatus(MiniforgeStatus.ERROR);
                throw new MiniforgeException("Failed to prepare Miniforge installation", e);
            }
            Path resourcesFolderOnDisk = PythonSDKSettings.getPythonArchiveLookupDir();
            OSArch osArch = OSTools.getOperatingSystemArchitecture();
            ArrayList<Object> installCommands = new ArrayList<String>();
            Path shellScript = null;
            switch (OSTools.getOperatingSystem()) {
                case WINDOWS: {
                    if (osArch != OSArch.x86_64) {
                        this.setStatus(MiniforgeStatus.ERROR);
                        throw new MiniforgeException("Operating system architecture " + osArch + " not supported");
                    }
                    fileName = MINIFORGE_FILENAME_WINDOWS_X86_64;
                    installerSHA256Resource = "/com/altair/extension/resources/miniforge/windows/" + fileName;
                    installCommands.add("cmd.exe");
                    installCommands.add("/C");
                    installCommands.add("start");
                    installCommands.add("/wait");
                    installCommands.add("");
                    installCommands.add(resourcesFolderOnDisk.resolve(fileName).toAbsolutePath().toString());
                    installCommands.add("/S");
                    installCommands.add("/InstallationType=JustMe");
                    installCommands.add("/NoShortcuts=1");
                    installCommands.add("/NoRegistry=1");
                    installCommands.add("/NoScripts=1");
                    installCommands.add("/RegisterPython=0");
                    installCommands.add(String.format("/D=%s", FileTools.tryShorteningPath(this.installationDirectory, Path.of(System.getenv("LOCALAPPDATA"), new String[0]), "%LOCALAPPDATA%")));
                    break;
                }
                case OSX: {
                    if (osArch == OSArch.ARM64) {
                        fileName = MINIFORGE_FILENAME_MACOS_ARM64;
                    } else if (osArch == OSArch.x86_64) {
                        fileName = MINIFORGE_FILENAME_MACOS_X86_64;
                    } else {
                        this.setStatus(MiniforgeStatus.ERROR);
                        throw new MiniforgeException("Operating system architecture " + osArch + " not supported");
                    }
                    installerSHA256Resource = "/com/altair/extension/resources/miniforge/macos/" + fileName;
                    ArrayList<String> macOSCommands = new ArrayList<String>();
                    macOSCommands.add("ulimit");
                    macOSCommands.add("-n");
                    macOSCommands.add("1000000");
                    macOSCommands.add("&&");
                    macOSCommands.add(resourcesFolderOnDisk.resolve(fileName).toAbsolutePath().toString());
                    macOSCommands.add("-b");
                    macOSCommands.add("-p");
                    macOSCommands.add(this.installationDirectory.toAbsolutePath().toString());
                    try {
                        shellScript = PythonDistributionTools.formatPythonInvocationCommandsAndWriteToShellScript(macOSCommands, resourcesFolderOnDisk);
                    }
                    catch (IOException e) {
                        LogService.getRoot().log(Level.SEVERE, "Failed to create macOS installer shell script, falling back to direct installer invocation!", e);
                        installCommands = macOSCommands;
                    }
                    break;
                }
                default: {
                    if (osArch == OSArch.ARM64) {
                        fileName = MINIFORGE_FILENAME_LINUX_ARM64;
                    } else if (osArch == OSArch.PPC64LE) {
                        fileName = MINIFORGE_FILENAME_LINUX_PPC64LE;
                    } else if (osArch == OSArch.x86_64) {
                        fileName = MINIFORGE_FILENAME_LINUX_X86_64;
                    } else {
                        this.setStatus(MiniforgeStatus.ERROR);
                        throw new MiniforgeException("Operating system architecture " + osArch + " not supported");
                    }
                    installerSHA256Resource = "/com/altair/extension/resources/miniforge/linux/" + fileName;
                    installCommands.add(resourcesFolderOnDisk.resolve(fileName).toAbsolutePath().toString());
                    installCommands.add("-b");
                    installCommands.add("-p");
                    installCommands.add(this.installationDirectory.toAbsolutePath().toString());
                }
            }
            installerSHA256Resource = installerSHA256Resource + ".sha256";
            String downloadUrl = String.format(MINIFORGE_DOWNLOAD_URL_TEMPLATE, MINIFORGE_VERSION, fileName);
            Path miniforgeInstallerOnDisk = resourcesFolderOnDisk.resolve(fileName);
            try (InputStream sha256Stream = MiniforgeHandler.class.getResourceAsStream(installerSHA256Resource);){
                if (sha256Stream == null) {
                    this.setStatus(MiniforgeStatus.ERROR);
                    throw new PythonDistributionInstallationException("Cannot verify Miniforge installer, SHA256 signature not found", null);
                }
                String sha256Content = new String(sha256Stream.readAllBytes()).trim();
                if (StringUtils.trimToNull((String)sha256Content) == null) {
                    this.setStatus(MiniforgeStatus.ERROR);
                    throw new PythonDistributionInstallationException("Cannot verify Miniforge installer, SHA256 signature empty", null);
                }
                if (!sha256Content.endsWith(fileName)) {
                    this.setStatus(MiniforgeStatus.ERROR);
                    throw new PythonDistributionInstallationException("Cannot verify Miniforge installer, SHA256 signature does not match filename", null);
                }
                String[] sha256Split = sha256Content.split("\\s+");
                if (sha256Split.length != 2) {
                    this.setStatus(MiniforgeStatus.ERROR);
                    throw new PythonDistributionInstallationException("Cannot verify Miniforge installer, SHA256 signature content unexpected", null);
                }
                String expectedHash = sha256Split[0];
                if (Files.exists(miniforgeInstallerOnDisk, new LinkOption[0])) {
                    String hashOnDisk = new DigestUtils(DigestUtils.getSha256Digest()).digestAsHex(miniforgeInstallerOnDisk, new OpenOption[0]);
                    if (!expectedHash.equals(hashOnDisk)) {
                        if (PythonSDKSettings.isAirGapped()) {
                            this.setStatus(MiniforgeStatus.ERROR);
                            throw new PythonDistributionInstallationException("Miniforge installer has wrong SHA256 signature, cannot re-download due to air-gapped mode, aborting", null);
                        }
                        LogService.getRoot().log(Level.WARNING, "Miniforge installer has wrong SHA256 signature, re-downloading..");
                        this.downloadInstallerAndVerifyHash(downloadUrl, miniforgeInstallerOnDisk, expectedHash);
                    }
                } else {
                    if (PythonSDKSettings.isAirGapped()) {
                        this.setStatus(MiniforgeStatus.ERROR);
                        throw new PythonDistributionInstallationException(String.format("Miniforge installer not found at %s, cannot download due to air-gapped mode, aborting", miniforgeInstallerOnDisk.toAbsolutePath()), null);
                    }
                    LogService.getRoot().log(Level.INFO, "Downloading Miniforge installer..");
                    this.downloadInstallerAndVerifyHash(downloadUrl, miniforgeInstallerOnDisk, expectedHash);
                }
                long start = Instant.now().toEpochMilli();
                ArrayList<Object> installationCommands = shellScript != null ? List.of(shellScript.toAbsolutePath().toString()) : installCommands;
                ExternalProcess result = ExternalProcessBuilder.newBuilder().workingDir(resourcesFolderOnDisk).addEnvUnlessOperatingSystem(ENVIRONMENT_KEY_HOME, () -> PythonSDKSettings.getMiniforgeFakeHomeDir().toAbsolutePath().toString(), SystemInfoUtilities.OperatingSystem.WINDOWS).outputConsumer(s -> ExternalProcessTools.logShellOutput("Miniforge Installer", Level.FINER, s)).errorConsumer(err -> ExternalProcessTools.logShellOutput("Miniforge Installer", Level.WARNING, err)).id("Miniforge installer").command((String[])installationCommands.toArray(String[]::new)).startProcess();
                Process process = result.getProcessFuture().get(10L, TimeUnit.MINUTES);
                long durationInMS = Instant.now().toEpochMilli() - start;
                int exitCode = process.exitValue();
                if (exitCode == 0) {
                    if (!this.isMiniforgeInstalled()) {
                        this.setStatus(MiniforgeStatus.ERROR);
                        LogService.getRoot().log(Level.WARNING, "Failed to install Miniforge, content not there after installation");
                        throw new MiniforgeException("Failed to install Miniforge!");
                    }
                    LogService.getRoot().log(Level.INFO, () -> String.format("Successfully installed Miniforge in %ds.", durationInMS / 1000L));
                    break block40;
                }
                this.setStatus(MiniforgeStatus.ERROR);
                LogService.getRoot().log(Level.WARNING, () -> String.format("Failed to install Miniforge, exit code %d", exitCode));
                throw new MiniforgeException("Failed to install Miniforge!");
            }
            catch (ExecutionException e) {
                this.setStatus(MiniforgeStatus.ERROR);
                throw new MiniforgeException("Failed to install Miniforge!", e.getCause());
            }
            catch (Exception e) {
                this.setStatus(MiniforgeStatus.ERROR);
                throw new MiniforgeException("Failed to install Miniforge!", e);
            }
        }
    }

    public synchronized boolean isMiniforgeInitialized() throws MiniforgeException {
        boolean initialized;
        if (this.status == MiniforgeStatus.ERROR) {
            throw new MiniforgeException("Miniforge could not be installed, cannot check initialization status");
        }
        switch (OSTools.getOperatingSystem()) {
            case WINDOWS: {
                initialized = this.isMiniforgeInitializedWindows();
                break;
            }
            case OSX: {
                initialized = this.isMiniforgeInitializedMacOS();
                break;
            }
            default: {
                initialized = this.isMiniforgeInitializedUnix();
            }
        }
        if (initialized) {
            this.setStatus(MiniforgeStatus.READY);
        }
        return initialized;
    }

    public synchronized void initializeMiniforgeLocally() throws MiniforgeException {
        if (this.status == MiniforgeStatus.ERROR) {
            throw new MiniforgeException("Miniforge could not be installed, cannot initialize");
        }
        switch (OSTools.getOperatingSystem()) {
            case WINDOWS: {
                this.initMiniforgeLocallyWindows();
                break;
            }
            case OSX: {
                this.initMiniforgeLocallyMacOS();
                break;
            }
            default: {
                this.initMiniforgeLocallyUnix();
            }
        }
        for (String channel : ANACONDA_CHANNELS) {
            this.changeConfig(MiniforgeConfigModifier.APPEND, CONFIG_KEY_BLACKLIST, channel);
        }
        if (!this.isMiniforgeInitialized()) {
            throw new MiniforgeException("Miniforge could not be initialized");
        }
    }

    public void updateCondaConfig() throws MiniforgeException {
        this.changeConfig(MiniforgeConfigModifier.SET, CONFIG_KEY_SOLVER, CONFIG_VALUE_SOLVER_MAMBA);
        this.changeConfig(MiniforgeConfigModifier.SET, CONFIG_KEY_IGNORE_UNREACHABLE_CHANNELS, "True");
    }

    public void changeConfig(MiniforgeConfigModifier modifier, String ... args) throws MiniforgeException {
        SecurityTools.requireInternalPermission();
        ValidationUtilV2.requireNonNull((Object)((Object)modifier), (String)"modifier");
        ValidationUtilV2.requireNonNull((Object)args, (String)"args");
        try {
            String[] fullArgs = new String[args.length + 4];
            fullArgs[0] = this.getMiniforgeExecutable().toString();
            fullArgs[1] = "config";
            fullArgs[2] = "--system";
            fullArgs[3] = modifier.getArg();
            System.arraycopy(args, 0, fullArgs, 4, args.length);
            ExternalProcess result = ExternalProcessBuilder.newBuilder().workingDir(this.getMiniforgeExecutable().getParent()).addEnvUnlessOperatingSystem(ENVIRONMENT_KEY_HOME, () -> PythonSDKSettings.getMiniforgeFakeHomeDir().toAbsolutePath().toString(), SystemInfoUtilities.OperatingSystem.WINDOWS).outputConsumer(s -> ExternalProcessTools.logShellOutput("Miniforge config change", Level.FINER, s)).errorConsumer(err -> ExternalProcessTools.logShellOutput("Miniforge config change", Level.WARNING, err)).id("Miniforge Config Change").command(fullArgs).startProcess();
            Process process = result.getProcessFuture().get(10L, TimeUnit.SECONDS);
            int exitCode = process.exitValue();
            if (exitCode != 0) {
                throw new MiniforgeException("Miniforge config change failed: " + exitCode);
            }
            LogService.getRoot().log(Level.INFO, () -> String.format("Miniforge config change (%s) successful", Arrays.toString(args)));
        }
        catch (Exception e) {
            throw new MiniforgeException("Miniforge config change failed", e);
        }
    }

    public Path getInstallationDirectory() {
        return this.installationDirectory;
    }

    public Path getMiniforgeExecutable() {
        String executableName;
        String binDirectory;
        switch (OSTools.getOperatingSystem()) {
            case WINDOWS: {
                binDirectory = "condabin";
                executableName = "conda.bat";
                break;
            }
            default: {
                binDirectory = "bin";
                executableName = "conda";
            }
        }
        Path chosenExecutable = this.installationDirectory.resolve(binDirectory).resolve(executableName).toAbsolutePath();
        if (!Files.exists(chosenExecutable, new LinkOption[0])) {
            LogService.getRoot().log(Level.SEVERE, () -> String.format("Could not find Miniforge executable %s! Miniforge will not work!", executableName));
        }
        return chosenExecutable;
    }

    public MiniforgeStatus getStatus() {
        return this.status;
    }

    private void downloadInstallerAndVerifyHash(String downloadUrl, Path miniforgeInstallerOnDisk, String expectedHash) throws IOException, PythonDistributionInstallationException {
        try (ReadableByteChannel downloadChannel = Channels.newChannel(new URL(downloadUrl).openStream());
             FileOutputStream fileOutputStream = new FileOutputStream(miniforgeInstallerOnDisk.toFile());){
            fileOutputStream.getChannel().transferFrom(downloadChannel, 0L, Long.MAX_VALUE);
        }
        TempFileTools.registerCleanup((Path)miniforgeInstallerOnDisk);
        String hashOnDisk = new DigestUtils(DigestUtils.getSha256Digest()).digestAsHex(miniforgeInstallerOnDisk, new OpenOption[0]);
        if (!expectedHash.equals(hashOnDisk)) {
            this.setStatus(MiniforgeStatus.ERROR);
            throw new PythonDistributionInstallationException("Miniforge installer has wrong SHA256 signature after download, aborting", null);
        }
        switch (OSTools.getOperatingSystem()) {
            case OSX: 
            case UNIX: {
                Files.setPosixFilePermissions(miniforgeInstallerOnDisk, Set.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE));
                break;
            }
        }
    }

    private boolean isCondaVersionHighEnough() {
        try {
            CountDownLatch latch = new CountDownLatch(2);
            StringBuilder sb = new StringBuilder();
            ExternalProcess result = ExternalProcessBuilder.newBuilder().workingDir(this.getMiniforgeExecutable().getParent()).addEnvUnlessOperatingSystem(ENVIRONMENT_KEY_HOME, () -> PythonSDKSettings.getMiniforgeFakeHomeDir().toAbsolutePath().toString(), SystemInfoUtilities.OperatingSystem.WINDOWS).outputConsumer(s -> {
                sb.append((String)s);
                ExternalProcessTools.logShellOutput("Miniforge version check", Level.FINER, s);
            }).errorConsumer(err -> ExternalProcessTools.logShellOutput("Miniforge version check", Level.WARNING, err)).awaitOutputStreamsClosing(latch).id("Miniforge Version Check").command(this.getMiniforgeExecutable().toString(), "--version").startProcess();
            Process process = result.getProcessFuture().get(20L, TimeUnit.SECONDS);
            if (!latch.await(1L, TimeUnit.SECONDS)) {
                throw new TimeoutException();
            }
            String response = sb.toString().toLowerCase();
            int exitCode = process.exitValue();
            if (exitCode != 0) {
                LogService.getRoot().log(Level.WARNING, "Miniforge version check failed: " + exitCode);
                return false;
            }
            String curVerStr = response.replaceAll("[\\s*A-z]", "");
            VersionNumber curVer = new VersionNumber(curVerStr);
            VersionNumber reqVer = new VersionNumber(CONDA_REQUIRED_VERSION);
            return curVer.isAtLeast(reqVer);
        }
        catch (Exception e) {
            LogService.getRoot().log(Level.WARNING, "Failed to check Miniforge version", e);
            return false;
        }
    }

    private boolean isMiniforgeInitializedWindows() {
        try {
            ExternalProcess result = ExternalProcessBuilder.newBuilder().workingDir(this.getMiniforgeExecutable().getParent()).outputConsumer(s -> ExternalProcessTools.logShellOutput("Miniforge init check", Level.FINER, s)).errorConsumer(err -> ExternalProcessTools.logShellOutput("Miniforge init check", Level.WARNING, err)).id("Miniforge Init Check").command(this.getMiniforgeExecutable().toString(), "activate").startProcess();
            Process process = result.getProcessFuture().get(1L, TimeUnit.MINUTES);
            int exitCode = process.exitValue();
            if (exitCode != 0) {
                LogService.getRoot().log(Level.WARNING, "Miniforge init check failed: " + exitCode);
                return false;
            }
            return this.isMiniforgeInitializedUnix();
        }
        catch (Exception e) {
            LogService.getRoot().log(Level.WARNING, "Failed to check Miniforge initialization status", e);
            return false;
        }
    }

    private boolean isMiniforgeInitializedUnix() {
        try {
            CountDownLatch latch = new CountDownLatch(2);
            StringBuilder sb = new StringBuilder();
            ExternalProcess result = ExternalProcessBuilder.newBuilder().workingDir(this.getMiniforgeExecutable().getParent()).addEnvUnlessOperatingSystem(ENVIRONMENT_KEY_HOME, () -> PythonSDKSettings.getMiniforgeFakeHomeDir().toAbsolutePath().toString(), SystemInfoUtilities.OperatingSystem.WINDOWS).outputConsumer(s -> {
                sb.append((String)s);
                ExternalProcessTools.logShellOutput("Miniforge init check", Level.FINER, s);
            }).errorConsumer(err -> ExternalProcessTools.logShellOutput("Miniforge init check", Level.WARNING, err)).awaitOutputStreamsClosing(latch).id("Miniforge Init Check").command(this.getMiniforgeExecutable().toString(), "config", "--system", "--get", CONFIG_KEY_BLACKLIST).startProcess();
            Process process = result.getProcessFuture().get(20L, TimeUnit.SECONDS);
            if (!latch.await(1L, TimeUnit.SECONDS)) {
                throw new TimeoutException();
            }
            String response = sb.toString().toLowerCase();
            int exitCode = process.exitValue();
            if (exitCode != 0) {
                LogService.getRoot().log(Level.WARNING, "Miniforge init check failed: " + exitCode);
                return false;
            }
            return response.contains("anaconda");
        }
        catch (Exception e) {
            LogService.getRoot().log(Level.WARNING, "Failed to check Miniforge initialization status", e);
            return false;
        }
    }

    private boolean isMiniforgeInitializedMacOS() {
        return this.isMiniforgeInitializedUnix();
    }

    private void initMiniforgeLocallyWindows() throws MiniforgeException {
        WindowsRegistryHelper regHelper = new WindowsRegistryHelper();
        String prevRegValue = regHelper.readValue("Software\\Microsoft\\Command Processor", "AutoRun");
        FileBackup psProfileBackup = new FileBackup(Paths.get(Shell32Util.getFolderPath((int)5), "WindowsPowerShell", "profile.ps1"));
        try {
            LogService.getRoot().log(Level.FINE, () -> String.format("Backing up %s as it may get changed by Miniforge", psProfileBackup.getBackupTarget()));
            psProfileBackup.backupNow();
        }
        catch (Exception e) {
            LogService.getRoot().log(Level.WARNING, "Failed to backup USER_HOME/Documents/WindowsPowerShell/profile.ps1 file", e);
        }
        this.initMiniforge();
        try {
            regHelper.setValue("Software\\Microsoft\\Command Processor", "AutoRun", prevRegValue);
            psProfileBackup.restoreNowIfNeeded();
        }
        catch (Exception e) {
            LogService.getRoot().log(Level.WARNING, e, () -> String.format("Failed to restore state prior to Miniforge initialization, your system may now recognize %s as the primary Miniforge installation.", this.installationDirectory));
        }
    }

    private void initMiniforgeLocallyUnix() throws MiniforgeException {
        FileBackup bashProfileBackup = new FileBackup(Paths.get(System.getProperty("user.home"), ".bash_profile"));
        FileBackup bashRCUserBackup = new FileBackup(Paths.get(System.getProperty("user.home"), ".bashrc"));
        FileBackup bashRCBackup = new FileBackup(Paths.get("/root", ".bashrc"));
        FileBackup zshRCUserBackup = new FileBackup(Paths.get(System.getProperty("user.home"), ".zshrc"));
        HashSet<FileBackup> fileBackups = new HashSet<FileBackup>(4);
        fileBackups.add(bashProfileBackup);
        fileBackups.add(bashRCUserBackup);
        fileBackups.add(bashRCBackup);
        fileBackups.add(zshRCUserBackup);
        MiniforgeHandler.doBackup(fileBackups);
        this.initMiniforge();
        this.restoreBackup(fileBackups);
    }

    private void initMiniforgeLocallyMacOS() throws MiniforgeException {
        this.initMiniforgeLocallyUnix();
    }

    private static void doBackup(Set<FileBackup> fileBackups) {
        for (FileBackup backup : fileBackups) {
            try {
                LogService.getRoot().log(Level.FINE, () -> String.format("Backing up %s as it may get changed by Miniforge", backup.getBackupTarget()));
                backup.backupNow();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (Exception e) {
                LogService.getRoot().log(Level.WARNING, e, () -> String.format("Failed to backup %s file", backup.getBackupTarget().toString()));
            }
        }
    }

    private void restoreBackup(Set<FileBackup> fileBackups) {
        for (FileBackup backup : fileBackups) {
            try {
                backup.restoreNowIfNeeded();
            }
            catch (Exception e) {
                LogService.getRoot().log(Level.WARNING, e, () -> String.format("Failed to restore state (%s) prior to Miniforge initialization, your system may now recognize %s as the primary Miniforge installation.", backup.getBackupTarget(), this.installationDirectory));
            }
        }
    }

    private void initMiniforge() throws MiniforgeException {
        try {
            ExternalProcess result = ExternalProcessBuilder.newBuilder().workingDir(this.getMiniforgeExecutable().getParent()).addEnvUnlessOperatingSystem(ENVIRONMENT_KEY_HOME, () -> PythonSDKSettings.getMiniforgeFakeHomeDir().toAbsolutePath().toString(), SystemInfoUtilities.OperatingSystem.WINDOWS).outputConsumer(s -> ExternalProcessTools.logShellOutput("Miniforge init", Level.INFO, s)).errorConsumer(err -> ExternalProcessTools.logShellOutput("Miniforge init", Level.WARNING, err)).id("Miniforge Init").command(this.getMiniforgeExecutable().toString(), "init").startProcess();
            Process process = result.getProcessFuture().get(1L, TimeUnit.MINUTES);
            int exitCode = process.exitValue();
            if (exitCode != 0) {
                throw new MiniforgeException("Miniforge init failed: " + exitCode);
            }
            LogService.getRoot().log(Level.INFO, "Miniforge init successful");
        }
        catch (Exception e) {
            throw new MiniforgeException("Miniforge init failed", e);
        }
    }

    private void setStatus(MiniforgeStatus newStatus) {
        if (this.status != newStatus) {
            this.status = newStatus;
            this.notifyAllListeners(newStatus);
            LogService.getRoot().log(Level.FINE, () -> String.format("Miniforge is now in state: %s", new Object[]{newStatus}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyAllListeners(MiniforgeStatus newStatus) {
        List<MiniforgeListener> list = this.listenerList;
        synchronized (list) {
            this.notifyListeners(this.listenerList, newStatus);
        }
    }

    private void notifyListeners(List<MiniforgeListener> listenerList, MiniforgeStatus newStatus) {
        for (MiniforgeListener listener : listenerList) {
            this.notifyListener(() -> listener.miniforgeStatusChanged(newStatus));
        }
    }

    private void notifyListener(Runnable r) {
        try {
            this.listenerNotificationService.submit(r);
        }
        catch (RejectedExecutionException e) {
            LogService.getRoot().log(Level.WARNING, "Failed to notify listener about Miniforge event", e);
        }
    }

    static {
        MINIFORGE_FILENAME_WINDOWS_X86_64 = String.format("Miniforge3-%s-Windows-x86_64.exe", MINIFORGE_VERSION);
        MINIFORGE_FILENAME_MACOS_ARM64 = String.format("Miniforge3-%s-MacOSX-arm64.sh", MINIFORGE_VERSION);
        MINIFORGE_FILENAME_MACOS_X86_64 = String.format("Miniforge3-%s-MacOSX-x86_64.sh", MINIFORGE_VERSION);
        MINIFORGE_FILENAME_LINUX_ARM64 = String.format("Miniforge3-%s-Linux-aarch64.sh", MINIFORGE_VERSION);
        MINIFORGE_FILENAME_LINUX_PPC64LE = String.format("Miniforge3-%s-Linux-ppc64le.sh", MINIFORGE_VERSION);
        MINIFORGE_FILENAME_LINUX_X86_64 = String.format("Miniforge3-%s-Linux-x86_64.sh", MINIFORGE_VERSION);
        ANACONDA_CHANNELS = new String[]{"https://repo.anaconda.com/pkgs/main", "https://repo.anaconda.com/pkgs/r", "https://repo.anaconda.com/pkgs/msys2", "https://repo.anaconda.com/pkgs/pro", "https://anaconda.org/anaconda", "https://anaconda.org/r", "https://anaconda.org/msys2", "https://anaconda.org/anaconda-extras"};
    }
}

