/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.operator;

import com.altair.ai.pel.operator.PythonIOObject;
import com.altair.ai.pel.operator.SerializablePythonIOObject;
import com.altair.ai.pel.python.util.PythonOperatorTools;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.metadata.CompatibilityLevel;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.MetaDataError;
import com.rapidminer.operator.ports.metadata.SimpleMetaDataError;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public class PythonIOObjectMetaData
extends MetaData {
    private String dataClass;
    private Set<String> compatibleWith;

    public PythonIOObjectMetaData() {
    }

    public PythonIOObjectMetaData(PythonIOObject ioo, boolean shortened) {
        this(ioo.getDataClass(), ioo.compatibleDataClasses());
    }

    public PythonIOObjectMetaData(PythonIOObject ioo) {
        this(ioo.getDataClass(), ioo.compatibleDataClasses());
    }

    public PythonIOObjectMetaData(String dataClass, Set<String> compatibleWith) {
        super(SerializablePythonIOObject.class);
        this.dataClass = dataClass;
        this.compatibleWith = compatibleWith == null ? Collections.emptySet() : Set.copyOf(compatibleWith);
    }

    public Class<? extends IOObject> getObjectClass() {
        return SerializablePythonIOObject.class;
    }

    public String getTitleForDescription() {
        return String.format("%s (%s)", super.getTitleForDescription(), this.dataClass);
    }

    public Collection<MetaDataError> getErrorsForInput(InputPort inputPort, MetaData isData, CompatibilityLevel level) {
        PythonIOObjectMetaData pyIsData;
        if (isData == null) {
            return Collections.emptyList();
        }
        if (isData instanceof PythonIOObjectMetaData && (pyIsData = (PythonIOObjectMetaData)isData).isCompatibleWith(this.dataClass)) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new SimpleMetaDataError(isData instanceof PythonIOObjectMetaData ? ProcessSetupError.Severity.WARNING : ProcessSetupError.Severity.ERROR, (Port)inputPort, "expected", new Object[]{this.getTitleForDescription(), PythonOperatorTools.getTitleForDescription(isData)}));
    }

    public PythonIOObjectMetaData clone() {
        PythonIOObjectMetaData ioMD = (PythonIOObjectMetaData)super.clone();
        ioMD.dataClass = this.dataClass;
        ioMD.compatibleWith = this.compatibleWith;
        return ioMD;
    }

    public String getDataClass() {
        return this.dataClass;
    }

    public boolean isCompatibleWith(String dataClass) {
        return Objects.equals(this.dataClass, dataClass) || this.compatibleWith.contains(dataClass);
    }
}

