/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.operator;

import com.altair.ai.pel.distribution.PythonDistribution;
import com.altair.ai.pel.distribution.PythonDistributionHandler;
import com.altair.ai.pel.distribution.PythonDistributionReference;
import com.altair.ai.pel.distribution.PythonDistributionStatus;
import com.altair.ai.pel.operator.PythonOperator;
import com.altair.ai.pel.operator.PythonOperatorChain;
import com.altair.ai.pel.operator.PythonOperatorConnectionEncryptor;
import com.altair.ai.pel.operator.PythonOperatorContainer;
import com.altair.ai.pel.operator.SerializablePythonIOObject;
import com.altair.ai.pel.operator.wrapper.PythonFunctionCall;
import com.altair.ai.pel.operator.wrapper.PythonFunctionChain;
import com.altair.ai.pel.operator.wrapper.PythonFunctionChainBuilder;
import com.altair.ai.pel.operator.wrapper.PythonFunctionInput;
import com.altair.ai.pel.operator.wrapper.PythonFunctionOutput;
import com.altair.ai.pel.python.bridge.CommunicationMode;
import com.altair.ai.pel.python.bridge.DataExchangeMode;
import com.altair.ai.pel.python.bridge.PythonBridge;
import com.altair.ai.pel.python.exception.PythonDistributionNotReadyException;
import com.altair.ai.pel.python.exception.PythonDistributionUnsupportedException;
import com.altair.ai.pel.python.exception.PythonSDKException;
import com.altair.ai.pel.python.script.PythonInputCollectionProvider;
import com.altair.ai.pel.python.script.PythonInputProvider;
import com.altair.ai.pel.python.script.PythonOperatorScript;
import com.altair.ai.pel.python.script.PythonSourceProvider;
import com.altair.ai.pel.python.script.PythonStreamProvider;
import com.altair.ai.pel.python.script.result.ScriptOutput;
import com.altair.ai.pel.python.script.result.SubmissionResult;
import com.altair.ai.pel.python.settings.PythonDebugMode;
import com.altair.ai.pel.python.settings.PythonSDKSettings;
import com.altair.ai.pel.python.util.PythonDistributionTools;
import com.altair.ai.pel.python.util.PythonOperatorTools;
import com.altair.ai.pel.util.FileTools;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.rapidminer.Process;
import com.rapidminer.adaption.belt.AtPortConverter;
import com.rapidminer.adaption.belt.IOTable;
import com.rapidminer.belt.execution.Context;
import com.rapidminer.belt.execution.SequentialContext;
import com.rapidminer.operator.IOMultiplier;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.IOObjectCollection;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.nio.file.BufferedFileObject;
import com.rapidminer.operator.nio.file.FileObject;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.storage.hdf5.Hdf5TableReader;
import com.rapidminer.storage.hdf5.IOTableHdf5Writer;
import com.rapidminer.studio.internal.Resources;
import com.rapidminer.tools.FunctionWithThrowable;
import com.rapidminer.tools.IOTools;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.RandomGenerator;
import com.rapidminer.tools.TempFileTools;
import com.rapidminer.tools.ValidationUtilV2;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.tools.ant.filters.StringInputStream;

public final class PythonOperatorChainTools
extends Enum<PythonOperatorChainTools> {
    public static final String WRAPPER_OUTPUT_DIR = "outputs";
    public static final Set<Class<? extends Operator>> ALLOWED_ORCHESTRATORS;
    private static final ObjectMapper MAPPER;
    private static final Consumer<String> LOG_CONSUMER;
    private static final Consumer<String> ERR_CONSUMER;
    private static final Context sequentialContext;
    private static final /* synthetic */ PythonOperatorChainTools[] $VALUES;

    public static PythonOperatorChainTools[] values() {
        return (PythonOperatorChainTools[])$VALUES.clone();
    }

    public static PythonOperatorChainTools valueOf(String name) {
        return Enum.valueOf(PythonOperatorChainTools.class, name);
    }

    public static SubmissionResult runPythonWrapper(PythonOperatorChain pyChain, List<ScriptOutput> expectedOutputs) throws OperatorException {
        ValidationUtilV2.requireNonNull((Object)pyChain, (String)"pyChain");
        ValidationUtilV2.requireNonNull(expectedOutputs, (String)"expectedOutputs");
        try {
            boolean isRegistered;
            PythonDistribution pyDist = PythonDistributionTools.checkPythonDistributionForOverride(pyChain.getExtension().getPythonDist());
            boolean isRegistering = PythonDistributionHandler.INSTANCE.getDistributionStatus(pyDist) == PythonDistributionStatus.IN_REGISTRATION;
            boolean bl = isRegistered = PythonDistributionHandler.INSTANCE.getDistributionStatus(pyDist) == PythonDistributionStatus.REGISTERED;
            if (isRegistering) {
                throw new UserError((Operator)pyChain.getCurrentOperator(), "pel.operator.script_pydist_registering", new Object[]{pyDist.toDistributionString()});
            }
            if (!isRegistered) {
                throw new UserError((Operator)pyChain.getCurrentOperator(), "pel.operator.script_pydist_missing", new Object[]{pyDist.toDistributionString()});
            }
            PythonDistributionReference pyDistRef = PythonDistributionHandler.INSTANCE.getDistributionReference(pyDist);
            if (pyDistRef == null) {
                throw new PythonDistributionNotReadyException("Distribution not found", pyDist);
            }
            LogService.getRoot().log(PythonOperatorChainTools.getPythonOperatorLogLevel(), "Python: Running Python operator chain of size " + pyChain.getSize());
            CommunicationMode communicationMode = PythonOperatorChainTools.selectCommunicationMode(pyDistRef);
            DataExchangeMode dataExchangeMode = PythonOperatorChainTools.selectDataExchangeMode(pyDistRef);
            if (PythonOperatorChainTools.supportsProgressCallback(communicationMode)) {
                PythonOperatorTools.startProgressAnimation(pyChain.getCurrentOperator());
                pyChain.getPythonOperatorContainers().stream().map(PythonOperatorContainer::getPyOp).forEach(PythonOperatorTools::startRunningIndicator);
                pyChain.getOrchestrators().forEach(PythonOperatorTools::startRunningIndicator);
            } else {
                pyChain.getPythonOperatorContainers().stream().map(PythonOperatorContainer::getPyOp).forEach(PythonOperatorTools::startProgressAnimation);
                pyChain.getOrchestrators().forEach(PythonOperatorTools::startProgressAnimation);
            }
            PythonOperatorScript pyScript = new PythonOperatorScript(pyChain.getName(), PythonOperatorChainTools.createArgProvider(communicationMode, PythonOperatorConnectionEncryptor.getSharedSecret(pyChain)), PythonOperatorChainTools.createSourceProviders(communicationMode), PythonOperatorChainTools.createInputProvidersFunction(pyChain, dataExchangeMode), expectedOutputs, LOG_CONSUMER, ERR_CONSUMER, PythonOperatorChainTools.supportsProgressCallback(communicationMode) ? pyChain::completeCurrentOperator : null);
            return PythonBridge.INSTANCE.submitScript(pyDist, pyScript, communicationMode, dataExchangeMode, Resources.getConcurrencyContext((Operator)pyChain.getCurrentOperator()));
        }
        catch (PythonDistributionNotReadyException e) {
            throw new UserError((Operator)pyChain.getCurrentOperator(), (Throwable)e, "pel.operator.script_submission_error");
        }
        catch (PythonDistributionUnsupportedException e) {
            throw new UserError((Operator)pyChain.getCurrentOperator(), (Throwable)e, "pel.operator.script_pydist_unsupported", new Object[]{e.getDist().toDistributionString()});
        }
        catch (OperatorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UserError((Operator)pyChain.getCurrentOperator(), (Throwable)e, "pel.operator.script_prep_error");
        }
    }

    public static IOObject loadResultValueFromStream(PythonOperator pyOp, InputStream is, ScriptOutput scriptOutput, Class<? extends IOObject> ioType) throws UserError {
        ObjectLoaderFunction<IOObject> objectLoader;
        if (ioType.equals(IOTable.class)) {
            objectLoader = PythonOperatorChainTools::loadDataFromStream;
        } else if (ioType.equals(FileObject.class)) {
            objectLoader = PythonOperatorChainTools::loadFileFromStream;
        } else if (ioType.equals(SerializablePythonIOObject.class)) {
            objectLoader = PythonOperatorChainTools::loadPythonObjectFromStream;
        } else {
            LogService.getRoot().log(Level.SEVERE, () -> String.format("BUG: Unexpected data type at port: %s", new Object[]{scriptOutput.getDataType()}));
            return null;
        }
        if (scriptOutput.isCollection()) {
            return PythonOperatorChainTools.loadCollectionFromStream(pyOp, is, scriptOutput, objectLoader);
        }
        return objectLoader.apply(pyOp, is, scriptOutput);
    }

    public static PythonFunctionChain createPythonFunctionChain(PythonOperatorChain chain, Path workingDir, DataExchangeMode dataExchangeMode) {
        ValidationUtilV2.requireNonNull((Object)chain, (String)"chain");
        PythonFunctionChainBuilder chainBuilder = new PythonFunctionChainBuilder();
        for (PythonOperatorContainer pyOpContainer : chain.getPythonOperatorContainers()) {
            chainBuilder.addFunction(pyOpContainer.getPyFuncCall());
        }
        chainBuilder.setDataExchangeMode(dataExchangeMode);
        if (workingDir != null) {
            chainBuilder.addDataExchangeProperty("working_dir", workingDir.toAbsolutePath().toString());
        }
        chainBuilder.addEnvironmentProperty("initial_random_seed", String.valueOf(RandomGenerator.getRandomGenerator((Process)chain.getCurrentOperator().getProcess(), (int)-1).nextLong()));
        return chainBuilder.build();
    }

    public static boolean usesMacros(Operator pyOp) throws UndefinedParameterError {
        ValidationUtilV2.requireNonNull((Object)pyOp, (String)"pyOp");
        try {
            for (ParameterType parameterType : pyOp.getParameterTypes()) {
                String beforeMacros = pyOp.getParameters().getParameter(parameterType.getKey());
                String afterMacros = pyOp.getParameterAsString(parameterType.getKey());
                if (beforeMacros == null || beforeMacros.equals(afterMacros)) continue;
                return true;
            }
        }
        catch (UndefinedParameterError e) {
            e.setOperator(pyOp);
            throw e;
        }
        return false;
    }

    public static List<ScriptOutput> createScriptOutputs(PythonFunctionCall pyFuncCall) {
        ValidationUtilV2.requireNonNull((Object)pyFuncCall, (String)"pyFuncCall");
        ArrayList<ScriptOutput> outputs = new ArrayList<ScriptOutput>();
        for (PythonFunctionOutput argOut : pyFuncCall.getOutputs()) {
            outputs.add(new ScriptOutput(argOut.getName(), argOut.getTarget(), argOut.getDataType(), argOut.getDataClass(), argOut.isCollection()));
        }
        return outputs;
    }

    public static Level getPythonOperatorLogLevel() {
        switch (PythonSDKSettings.getDebugMode()) {
            case OPERATOR: 
            case ALL: {
                return Level.INFO;
            }
        }
        return Level.FINE;
    }

    public static Level getPythonScriptLogLevel() {
        switch (PythonSDKSettings.getDebugMode()) {
            case ALL: {
                return Level.INFO;
            }
        }
        return Level.FINE;
    }

    private static <T extends IOObject> IOObjectCollection<T> loadCollectionFromStream(PythonOperator pyOp, InputStream is, ScriptOutput scriptOutput, ObjectLoaderFunction<T> objectLoader) throws UserError {
        ValidationUtilV2.requireNonNull((Object)((Object)pyOp), (String)"pyOp");
        ValidationUtilV2.requireNonNull((Object)is, (String)"is");
        IOObjectCollection collection = new IOObjectCollection();
        try (ZipInputStream zis = new ZipInputStream(is);){
            while (zis.getNextEntry() != null) {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                zis.transferTo(buffer);
                T object = objectLoader.apply(pyOp, new ByteArrayInputStream(buffer.toByteArray()), scriptOutput);
                collection.add(object);
                zis.closeEntry();
            }
        }
        catch (IOException e) {
            throw new UserError((Operator)pyOp, (Throwable)e, "pel.operator.load_collection");
        }
        return collection;
    }

    private static IOTable loadDataFromStream(PythonOperator pyOp, InputStream is, ScriptOutput scriptOutput) throws UserError {
        ValidationUtilV2.requireNonNull((Object)((Object)pyOp), (String)"pyOp");
        ValidationUtilV2.requireNonNull((Object)is, (String)"is");
        Path tablePath = null;
        try {
            tablePath = TempFileTools.createTempFile((String)"pyscript_table", (String)".rmhdf5table");
            OutputStream os = Files.newOutputStream(tablePath, new OpenOption[0]);
            IOTools.copyStreamSynchronously((InputStream)is, (OutputStream)os, (boolean)true);
            IOTable iOTable = Hdf5TableReader.read((Path)tablePath, (Context)sequentialContext);
            return iOTable;
        }
        catch (Exception e) {
            throw new UserError((Operator)pyOp, (Throwable)e, "pel.operator.load_hdf5");
        }
        finally {
            if (tablePath != null) {
                FileUtils.deleteQuietly((File)tablePath.toFile());
            }
        }
    }

    private static FileObject loadFileFromStream(PythonOperator pyOp, InputStream is, ScriptOutput scriptOutput) throws UserError {
        ValidationUtilV2.requireNonNull((Object)((Object)pyOp), (String)"pyOp");
        ValidationUtilV2.requireNonNull((Object)is, (String)"is");
        try {
            return new BufferedFileObject(IOUtils.toByteArray((InputStream)is));
        }
        catch (Exception e) {
            throw new UserError((Operator)pyOp, (Throwable)e, "pel.operator.load_file");
        }
    }

    private static SerializablePythonIOObject loadPythonObjectFromStream(PythonOperator pyOp, InputStream is, ScriptOutput scriptOutput) throws UserError {
        ValidationUtilV2.requireNonNull((Object)((Object)pyOp), (String)"pyOp");
        ValidationUtilV2.requireNonNull((Object)is, (String)"is");
        try {
            return new SerializablePythonIOObject(scriptOutput.getDataClass(), pyOp.getPythonOperatorDescription().getExtension().getSerializableDataClasses().get(scriptOutput.getDataClass()), new String(is.readAllBytes(), StandardCharsets.UTF_8), pyOp.getPythonOperatorDescription().getExtension().getName(), pyOp.getPythonOperatorDescription().getProvider().getVersion());
        }
        catch (Exception e) {
            throw new UserError((Operator)pyOp, (Throwable)e, "pel.operator.load_file");
        }
    }

    private static FunctionWithThrowable<Path, List<String>, PythonSDKException> createArgProvider(CommunicationMode communicationMode, char[] sharedSecret) throws PythonSDKException {
        ArrayList<String> args = new ArrayList<String>();
        if (PythonSDKSettings.getDebugMode() == PythonDebugMode.ALL) {
            args.add("--verbose");
        }
        args.add("--temp-dir");
        args.add(FileTools.getTempDirectory().toAbsolutePath().toString());
        args.add("--secret");
        args.add(new String(sharedSecret));
        switch (communicationMode) {
            case WEB_SOCKET_V1: {
                args.add("--client");
                args.add("rmx_pel");
                args.add("--pw");
                args.add(UUID.randomUUID().toString());
                break;
            }
            case CMD_V1: {
                args.add("--file");
                args.add("./inputs/args.json");
                break;
            }
            default: {
                throw new PythonSDKException("BUG: Unknown OperationMode encountered: " + communicationMode);
            }
        }
        return workingDir -> new ArrayList(args);
    }

    private static FunctionWithThrowable<Path, List<PythonStreamProvider>, Exception> createSourceProviders(CommunicationMode communicationMode) {
        return inputsDir -> {
            ArrayList<PythonStreamProvider> sourceProviders = new ArrayList<PythonStreamProvider>();
            switch (communicationMode) {
                case WEB_SOCKET_V1: {
                    PythonOperatorChainTools.addSourcesForWebSocketV1(sourceProviders);
                    break;
                }
                case CMD_V1: {
                    PythonOperatorChainTools.addSourcesForCMDV1(sourceProviders);
                }
            }
            return sourceProviders;
        };
    }

    private static FunctionWithThrowable<Path, List<PythonStreamProvider>, Exception> createInputProvidersFunction(PythonOperatorChain pythonChain, DataExchangeMode dataExchangeMode) {
        return inputsDir -> {
            ArrayList<PythonStreamProvider> inputProviders = new ArrayList<PythonStreamProvider>();
            PythonFunctionChain pythonFunctionChain = PythonOperatorChainTools.createPythonFunctionChain(pythonChain, inputsDir.getParent(), dataExchangeMode);
            inputProviders.add(new PythonInputProvider("args.json", () -> new StringInputStream(MAPPER.writeValueAsString((Object)pythonFunctionChain))));
            for (PythonOperatorContainer pyOpContainer : pythonChain.getPythonOperatorContainers()) {
                PythonOperator pyOp = pyOpContainer.getPyOp();
                for (PythonFunctionInput functionInputs : pyOpContainer.getPyFuncCall().getInputs()) {
                    InputPort inPort = (InputPort)pyOp.getInputPorts().getPortByName(functionInputs.getName());
                    switch (functionInputs.getDataType()) {
                        case DATAFRAME: {
                            PythonOperatorChainTools.writeDataTableDirectly(pyOp, inPort, String.valueOf(functionInputs.getValue()), functionInputs.isCollection(), inputsDir);
                            break;
                        }
                        case FILE: {
                            inputProviders.add(PythonOperatorChainTools.getPythonStreamProvider(pyOp, inPort, String.valueOf(functionInputs.getValue()), functionInputs.isCollection(), FileObject.class, FileObject::openStream));
                            break;
                        }
                        case SERIALIZABLE_OBJECT: {
                            inputProviders.add(PythonOperatorChainTools.getPythonStreamProvider(pyOp, inPort, String.valueOf(functionInputs.getValue()), functionInputs.isCollection(), SerializablePythonIOObject.class, object -> new ByteArrayInputStream(object.getJson().getBytes(StandardCharsets.UTF_8))));
                            break;
                        }
                    }
                }
            }
            return inputProviders;
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeDataTableDirectly(PythonOperator pyOp, InputPort inPort, String inputName, boolean isCollection, Path inputsDir) throws IOException, UserError {
        block21: {
            if (isCollection) {
                IOObjectCollection collection = (IOObjectCollection)inPort.getDataAsOrNull(IOObjectCollection.class);
                PythonOperatorChainTools.checkInputPortValue(pyOp, inPort, collection, IOObjectCollection.class);
                Path tempFolder = inputsDir.resolve("temp_" + inputName.split("\\.")[0]);
                Files.createDirectories(tempFolder, new FileAttribute[0]);
                int counter = 0;
                try {
                    for (IOObject object : collection.getObjects()) {
                        IOTable table;
                        PythonOperatorChainTools.checkInputPortValue(pyOp, inPort, object, IOObject.class);
                        if (object instanceof IOTable) {
                            table = (IOTable)object;
                        } else if (AtPortConverter.isConvertible(object.getClass(), IOTable.class)) {
                            table = (IOTable)AtPortConverter.convert((IOObject)object, (Port)inPort);
                        } else {
                            throw new UserError((Operator)pyOp, "150", new Object[]{inPort.getRawData().getClass(), inPort.getName()});
                        }
                        new IOTableHdf5Writer(table).write(tempFolder.resolve(String.format("input_%d.rmhdf5table", counter++)));
                    }
                    try (ZipOutputStream zipOut = new ZipOutputStream(Files.newOutputStream(inputsDir.resolve(inputName), new OpenOption[0]));
                         DirectoryStream<Path> directoryStream = Files.newDirectoryStream(tempFolder);){
                        for (Path file : directoryStream) {
                            if (!Files.isRegularFile(file, new LinkOption[0])) continue;
                            ZipEntry zipEntry = new ZipEntry(file.getFileName().toString());
                            zipOut.putNextEntry(zipEntry);
                            Files.copy(file, zipOut);
                            zipOut.closeEntry();
                        }
                        break block21;
                    }
                }
                finally {
                    FileUtils.deleteQuietly((File)tempFolder.toFile());
                }
            }
            IOTable table = (IOTable)inPort.getDataAsOrNull(IOTable.class);
            PythonOperatorChainTools.checkInputPortValue(pyOp, inPort, table, IOTable.class);
            new IOTableHdf5Writer(table).write(inputsDir.resolve(inputName));
        }
    }

    private static <T extends IOObject> PythonStreamProvider getPythonStreamProvider(PythonOperator pyOp, InputPort inPort, String inputName, boolean isCollection, Class<T> type, ObjectWriterFunction<T> objectWriterFunction) throws UserError {
        if (isCollection) {
            IOObjectCollection collection = (IOObjectCollection)inPort.getDataAsOrNull(IOObjectCollection.class);
            PythonOperatorChainTools.checkInputPortValue(pyOp, inPort, collection, IOObjectCollection.class);
            ArrayList<Callable<InputStream>> isProviders = new ArrayList<Callable<InputStream>>();
            for (Object object : collection.getObjects()) {
                PythonOperatorChainTools.checkInputPortValue(pyOp, inPort, object, type);
                isProviders.add(() -> objectWriterFunction.apply((IOObject)type.cast(object)));
            }
            return new PythonInputCollectionProvider(inputName, isProviders);
        }
        IOObject object = inPort.getDataAsOrNull(type);
        PythonOperatorChainTools.checkInputPortValue(pyOp, inPort, object, type);
        return new PythonInputProvider(inputName, () -> objectWriterFunction.apply(object));
    }

    private static void checkInputPortValue(PythonOperator pyOp, InputPort inPort, Object value, Class<? extends IOObject> expectedType) throws UserError {
        if (!expectedType.isInstance(value)) {
            if (inPort.getRawData() == null) {
                throw new UserError((Operator)pyOp, "149", new Object[]{inPort.getName()});
            }
            throw new UserError((Operator)pyOp, "150", new Object[]{inPort.getRawData().getClass(), inPort.getName()});
        }
    }

    private static CommunicationMode selectCommunicationMode(PythonDistributionReference pyDistRef) throws PythonSDKException {
        CommunicationMode selectedMode;
        CommunicationMode override = PythonSDKSettings.getGlobalCommunicationModeOverride();
        if (override != null) {
            LogService.getRoot().log(Level.INFO, () -> String.format("Using global communication mode override: %s", new Object[]{override}));
            return override;
        }
        Set<CommunicationMode> supportedCommunicationModes = PythonDistributionTools.getSupportedCommunicationModes(pyDistRef.getSupportedCapabilities());
        if (supportedCommunicationModes.contains((Object)CommunicationMode.WEB_SOCKET_V1)) {
            selectedMode = CommunicationMode.WEB_SOCKET_V1;
        } else if (supportedCommunicationModes.contains((Object)CommunicationMode.CMD_V1)) {
            selectedMode = CommunicationMode.CMD_V1;
        } else {
            throw new PythonDistributionUnsupportedException("Python Distribution is not capable of any supported communication mode", pyDistRef.getDist());
        }
        LogService.getRoot().log(Level.FINE, () -> String.format("Using best communication mode: %s", new Object[]{selectedMode}));
        return selectedMode;
    }

    private static DataExchangeMode selectDataExchangeMode(PythonDistributionReference pyDistRef) throws PythonSDKException {
        DataExchangeMode selectedMode;
        DataExchangeMode override = PythonSDKSettings.getGlobalDataExchangeModeOverride();
        if (override != null) {
            LogService.getRoot().log(Level.INFO, () -> String.format("Using global data exchange mode override: %s", new Object[]{override}));
            return override;
        }
        Set<DataExchangeMode> supportedDataExchangeModes = PythonDistributionTools.getSupportedDataExchangeModes(pyDistRef);
        if (supportedDataExchangeModes.contains((Object)DataExchangeMode.FILE_SYSTEM)) {
            selectedMode = DataExchangeMode.FILE_SYSTEM;
        } else if (supportedDataExchangeModes.isEmpty()) {
            LogService.getRoot().log(Level.WARNING, () -> String.format("No supported data exchange modes found for %s, will use fallback LOCAL_FILES", pyDistRef.getDist().toDistributionString()));
            selectedMode = DataExchangeMode.FILE_SYSTEM;
        } else {
            throw new PythonSDKException("BUG: Unknown DataExchangeMode encountered: " + supportedDataExchangeModes);
        }
        LogService.getRoot().log(Level.FINE, () -> String.format("Using best data exchange mode: %s", new Object[]{selectedMode}));
        return selectedMode;
    }

    private static void addSourcesForWebSocketV1(List<PythonStreamProvider> list) {
        list.add(new PythonSourceProvider("start_ws_server.py", () -> PythonOperatorChainTools.class.getResourceAsStream("/com/altair/extension/resources/scripts/wrapper/v1/start_ws_server.py")));
        list.add(new PythonSourceProvider("pew/__init__.py", () -> PythonOperatorChainTools.class.getResourceAsStream("/com/altair/extension/resources/scripts/wrapper/v1/pew/__init__.py")));
        list.add(new PythonSourceProvider("pew/io/__init__.py", () -> PythonOperatorChainTools.class.getResourceAsStream("/com/altair/extension/resources/scripts/wrapper/v1/pew/io/__init__.py")));
        list.add(new PythonSourceProvider("pew/io/_types.py", () -> PythonOperatorChainTools.class.getResourceAsStream("/com/altair/extension/resources/scripts/wrapper/v1/pew/io/_types.py")));
        list.add(new PythonSourceProvider("pew/io/_crypto.py", () -> PythonOperatorChainTools.class.getResourceAsStream("/com/altair/extension/resources/scripts/wrapper/v1/pew/io/_crypto.py")));
        list.add(new PythonSourceProvider("pew/io/conversion.py", () -> PythonOperatorChainTools.class.getResourceAsStream("/com/altair/extension/resources/scripts/wrapper/v1/pew/io/conversion.py")));
        list.add(new PythonSourceProvider("pew/io/data_exchange.py", () -> PythonOperatorChainTools.class.getResourceAsStream("/com/altair/extension/resources/scripts/wrapper/v1/pew/io/data_exchange.py")));
        list.add(new PythonSourceProvider("pew/util/__init__.py", () -> PythonOperatorChainTools.class.getResourceAsStream("/com/altair/extension/resources/scripts/wrapper/v1/pew/util/__init__.py")));
        list.add(new PythonSourceProvider("pew/wrapper/__init__.py", () -> PythonOperatorChainTools.class.getResourceAsStream("/com/altair/extension/resources/scripts/wrapper/v1/pew/wrapper/__init__.py")));
        list.add(new PythonSourceProvider("pew/wrapper/wrapper.py", () -> PythonOperatorChainTools.class.getResourceAsStream("/com/altair/extension/resources/scripts/wrapper/v1/pew/wrapper/wrapper.py")));
        list.add(new PythonSourceProvider("pew/wrapper/wrapper_json_parser.py", () -> PythonOperatorChainTools.class.getResourceAsStream("/com/altair/extension/resources/scripts/wrapper/v1/pew/wrapper/wrapper_json_parser.py")));
        list.add(new PythonSourceProvider("pew/websocket/__init__.py", () -> PythonOperatorChainTools.class.getResourceAsStream("/com/altair/extension/resources/scripts/wrapper/v1/pew/websocket/__init__.py")));
        list.add(new PythonSourceProvider("pew/websocket/dto.py", () -> PythonOperatorChainTools.class.getResourceAsStream("/com/altair/extension/resources/scripts/wrapper/v1/pew/websocket/dto.py")));
        list.add(new PythonSourceProvider("pew/websocket/_core.py", () -> PythonOperatorChainTools.class.getResourceAsStream("/com/altair/extension/resources/scripts/wrapper/v1/pew/websocket/_core.py")));
        list.add(new PythonSourceProvider("pew/websocket/handler.py", () -> PythonOperatorChainTools.class.getResourceAsStream("/com/altair/extension/resources/scripts/wrapper/v1/pew/websocket/handler.py")));
        list.add(new PythonSourceProvider("pew/io/cache.py", () -> PythonOperatorChainTools.class.getResourceAsStream("/com/altair/extension/resources/scripts/wrapper/v1/pew/io/cache.py")));
    }

    private static void addSourcesForCMDV1(List<PythonStreamProvider> list) {
        list.add(new PythonSourceProvider("run.py", () -> PythonOperatorChainTools.class.getResourceAsStream("/com/altair/extension/resources/scripts/wrapper/v1/run.py")));
        list.add(new PythonSourceProvider("pew/__init__.py", () -> PythonOperatorChainTools.class.getResourceAsStream("/com/altair/extension/resources/scripts/wrapper/v1/pew/__init__.py")));
        list.add(new PythonSourceProvider("pew/io/__init__.py", () -> PythonOperatorChainTools.class.getResourceAsStream("/com/altair/extension/resources/scripts/wrapper/v1/pew/io/__init__.py")));
        list.add(new PythonSourceProvider("pew/io/_types.py", () -> PythonOperatorChainTools.class.getResourceAsStream("/com/altair/extension/resources/scripts/wrapper/v1/pew/io/_types.py")));
        list.add(new PythonSourceProvider("pew/io/_crypto.py", () -> PythonOperatorChainTools.class.getResourceAsStream("/com/altair/extension/resources/scripts/wrapper/v1/pew/io/_crypto.py")));
        list.add(new PythonSourceProvider("pew/io/conversion.py", () -> PythonOperatorChainTools.class.getResourceAsStream("/com/altair/extension/resources/scripts/wrapper/v1/pew/io/conversion.py")));
        list.add(new PythonSourceProvider("pew/io/data_exchange.py", () -> PythonOperatorChainTools.class.getResourceAsStream("/com/altair/extension/resources/scripts/wrapper/v1/pew/io/data_exchange.py")));
        list.add(new PythonSourceProvider("pew/util/__init__.py", () -> PythonOperatorChainTools.class.getResourceAsStream("/com/altair/extension/resources/scripts/wrapper/v1/pew/util/__init__.py")));
        list.add(new PythonSourceProvider("pew/wrapper/__init__.py", () -> PythonOperatorChainTools.class.getResourceAsStream("/com/altair/extension/resources/scripts/wrapper/v1/pew/wrapper/__init__.py")));
        list.add(new PythonSourceProvider("pew/wrapper/wrapper.py", () -> PythonOperatorChainTools.class.getResourceAsStream("/com/altair/extension/resources/scripts/wrapper/v1/pew/wrapper/wrapper.py")));
        list.add(new PythonSourceProvider("pew/wrapper/wrapper_json_parser.py", () -> PythonOperatorChainTools.class.getResourceAsStream("/com/altair/extension/resources/scripts/wrapper/v1/pew/wrapper/wrapper_json_parser.py")));
    }

    private static boolean supportsProgressCallback(CommunicationMode mode) {
        return mode != CommunicationMode.CMD_V1;
    }

    private static /* synthetic */ PythonOperatorChainTools[] $values() {
        return new PythonOperatorChainTools[0];
    }

    static {
        $VALUES = PythonOperatorChainTools.$values();
        ALLOWED_ORCHESTRATORS = new HashSet<Class<? extends Operator>>();
        MAPPER = new ObjectMapper();
        LOG_CONSUMER = s -> LogService.getRoot().log(PythonOperatorChainTools.getPythonScriptLogLevel(), "Python script: " + s);
        ERR_CONSUMER = s -> LogService.getRoot().log(Level.WARNING, "Python error: " + s);
        ALLOWED_ORCHESTRATORS.add(IOMultiplier.class);
        sequentialContext = new SequentialContext();
    }

    @FunctionalInterface
    public static interface ObjectLoaderFunction<T extends IOObject> {
        public T apply(PythonOperator var1, InputStream var2, ScriptOutput var3) throws UserError;
    }

    @FunctionalInterface
    public static interface ObjectWriterFunction<T extends IOObject> {
        public InputStream apply(T var1) throws OperatorException;
    }
}

