/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.operator;

import com.altair.ai.pel.distribution.PythonDistribution;
import com.altair.ai.pel.operator.PythonOperator;
import com.altair.ai.pel.operator.PythonOperatorChain;
import com.altair.ai.pel.operator.wrapper.PythonFunctionConnectionParam;
import com.rapidminer.connection.configuration.ConfigurationParameter;
import com.rapidminer.connection.valueprovider.handler.ValueProviderHandlerRegistry;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.tools.LogService;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class PythonOperatorConnectionEncryptor {
    private static final String ALGO = "AES/GCM/NoPadding";
    private static final int IV_LENGTH = 12;
    private static final int TAG_LENGTH = 128;
    private static final Map<PythonDistribution, char[]> secretMap = new HashMap<PythonDistribution, char[]>();

    public static List<PythonFunctionConnectionParam> getConnectionParameters(PythonOperator pyOp) throws OperatorException {
        Map map = ValueProviderHandlerRegistry.getInstance().injectValues(pyOp.getConnectionSelector().getConnection(), (Operator)pyOp, false);
        List<String> encryptedKeys = pyOp.getConnectionSelector().getConnection().getConfiguration().getKeyMap().entrySet().stream().filter(e -> ((ConfigurationParameter)e.getValue()).isEncrypted()).map(Map.Entry::getKey).collect(Collectors.toList());
        try {
            return PythonOperatorConnectionEncryptor.processConnectionParameters(map, encryptedKeys, PythonOperatorConnectionEncryptor.getSharedSecret(pyOp));
        }
        catch (GeneralSecurityException e2) {
            throw new OperatorException("Failed to encrypt connection parameters", (Throwable)e2);
        }
    }

    public static char[] getSharedSecret(PythonOperatorChain pyChain) {
        PythonDistribution pyDist = pyChain.getPythonDist();
        return PythonOperatorConnectionEncryptor.getSharedSecretSync(pyDist);
    }

    public static char[] getSharedSecret(PythonOperator pyOp) {
        PythonDistribution pyDist = pyOp.getPythonOperatorDescription().getExtension().getPythonDist();
        return PythonOperatorConnectionEncryptor.getSharedSecretSync(pyDist);
    }

    private static synchronized char[] getSharedSecretSync(PythonDistribution pyDist) {
        return secretMap.computeIfAbsent(pyDist, dist -> PythonOperatorConnectionEncryptor.generateSecret());
    }

    private static char[] generateSecret() {
        char[] secret;
        byte[] keyBytes = new byte[32];
        SecureRandom rnd = new SecureRandom();
        rnd.nextBytes(keyBytes);
        int abortCounter = 0;
        while ((secret = Base64.getUrlEncoder().encodeToString(keyBytes).toCharArray())[0] == '-' && abortCounter++ < 20) {
        }
        if (secret[0] == '-') {
            String failedSec = new String(secret);
            LogService.getRoot().log(Level.SEVERE, () -> String.format("BUG: Server communication secret still starts with leading dash (%s)!", failedSec));
            secret = "NO_SEC".toCharArray();
        }
        return secret;
    }

    private static List<PythonFunctionConnectionParam> processConnectionParameters(Map<String, String> plainMap, List<String> keysToEncrypt, char[] secret) throws GeneralSecurityException {
        SecretKeySpec keySpec = new SecretKeySpec(Base64.getUrlDecoder().decode(new String(secret)), "AES");
        SecureRandom rnd = new SecureRandom();
        Cipher cipher = Cipher.getInstance(ALGO);
        ArrayList<PythonFunctionConnectionParam> processedParams = new ArrayList<PythonFunctionConnectionParam>();
        for (Map.Entry<String, String> e : plainMap.entrySet()) {
            if (e.getValue() == null) continue;
            if (!keysToEncrypt.contains(e.getKey())) {
                processedParams.add(new PythonFunctionConnectionParam(e.getKey(), e.getValue(), false));
                continue;
            }
            byte[] iv = new byte[12];
            rnd.nextBytes(iv);
            GCMParameterSpec paramSpec = new GCMParameterSpec(128, iv);
            cipher.init(1, (Key)keySpec, paramSpec);
            byte[] cipherText = cipher.doFinal(e.getValue().getBytes(StandardCharsets.UTF_8));
            byte[] out = ByteBuffer.allocate(iv.length + cipherText.length).put(iv).put(cipherText).array();
            String b64 = Base64.getEncoder().encodeToString(out);
            processedParams.add(new PythonFunctionConnectionParam(e.getKey(), b64, true));
        }
        return processedParams;
    }
}

