/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.operator;

import com.altair.ai.pel.operator.PythonOperator;
import com.altair.ai.pel.python.script.result.ScriptOutput;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.tools.ConsumerWithThrowable;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ValidationUtilV2;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.logging.Level;

class PythonResultContainer {
    private final ScriptOutput scriptOutput;
    private final String opName;
    private final String portName;
    private final AtomicBoolean delivered = new AtomicBoolean(false);
    private final ConsumerWithThrowable<InputStream, UserError> consumer;

    PythonResultContainer(PythonOperator pyOP, ScriptOutput scriptOutput, OutputPort outputPort, ConsumerWithThrowable<InputStream, UserError> consumer) {
        this.scriptOutput = (ScriptOutput)ValidationUtilV2.requireNonNull((Object)scriptOutput, (String)"scriptOutput");
        this.opName = ((PythonOperator)((Object)ValidationUtilV2.requireNonNull((Object)((Object)pyOP), (String)"pyOp"))).getName();
        this.portName = ((OutputPort)ValidationUtilV2.requireNonNull((Object)outputPort, (String)"outputPort")).getName();
        this.consumer = (ConsumerWithThrowable)ValidationUtilV2.requireNonNull(consumer, (String)"consumer");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PythonResultContainer that = (PythonResultContainer)o;
        return Objects.equals(this.scriptOutput, that.scriptOutput) && Objects.equals(this.portName, that.portName) && Objects.equals(this.delivered.get(), that.delivered.get());
    }

    public int hashCode() {
        return Objects.hash(this.scriptOutput, this.portName, this.delivered);
    }

    ScriptOutput getScriptOutput() {
        return this.scriptOutput;
    }

    void deliverOutput() throws UserError {
        block11: {
            if (this.delivered.compareAndSet(false, true)) {
                try (InputStream is = Optional.ofNullable(this.scriptOutput.getOutput()).map(Supplier::get).orElse(null);){
                    if (is == null) {
                        LogService.getRoot().log(Level.WARNING, () -> String.format("Expected output at output port %s of operator %s was missing!", this.portName, this.opName));
                    } else {
                        this.consumer.acceptWithException((Object)is);
                    }
                }
                catch (Exception e) {
                    LogService.getRoot().log(Level.WARNING, e, () -> String.format("Error getting output at output port %s of operator %s", this.portName, this.opName));
                    if (!(e instanceof UserError)) break block11;
                    throw (UserError)e;
                }
            }
        }
    }
}

