/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.operator;

import com.altair.ai.pel.operator.PythonOperator;
import com.altair.ai.pel.operator.PythonResultContainer;
import com.altair.ai.pel.python.script.result.ScriptOutput;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.tools.ConsumerWithThrowable;
import com.rapidminer.tools.ValidationUtilV2;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

class PythonResultHandler {
    private PythonOperator pyOp;
    private final List<PythonResultContainer> pythonResults;
    private final AtomicBoolean delivered = new AtomicBoolean(false);

    PythonResultHandler(PythonOperator pyOp) {
        this.pyOp = (PythonOperator)((Object)ValidationUtilV2.requireNonNull((Object)((Object)pyOp), (String)"pyOp must not be null!"));
        this.pythonResults = new ArrayList<PythonResultContainer>();
    }

    void addConsumerForResult(OutputPort outputPort, ScriptOutput scriptOutput, ConsumerWithThrowable<InputStream, UserError> consumer) {
        PythonResultContainer resultContainer = new PythonResultContainer(this.pyOp, scriptOutput, outputPort, consumer);
        this.pythonResults.add(resultContainer);
    }

    List<ScriptOutput> getAllExpectedOutputs() {
        return this.pythonResults.stream().map(PythonResultContainer::getScriptOutput).collect(Collectors.toList());
    }

    void deliverOutputs() throws UserError {
        if (this.delivered.compareAndSet(false, true)) {
            if (this.pyOp.getConnectionSelector() != null) {
                this.pyOp.getConnectionSelector().passDataThrough();
            }
            for (PythonResultContainer resultContainer : this.pythonResults) {
                resultContainer.deliverOutput();
            }
        }
    }

    void cleanUp() {
        this.pyOp = null;
        this.pythonResults.clear();
    }
}

