/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.operator;

import com.altair.ai.pel.operator.PythonIOObject;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.util.StdConverter;
import com.rapidminer.operator.ResultObjectAdapter;
import com.rapidminer.repository.versioned.JsonStorableIOObject;
import com.rapidminer.tools.I18N;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class SerializablePythonIOObject
extends ResultObjectAdapter
implements PythonIOObject,
JsonStorableIOObject {
    private static final int MAX_RESULT_STRING_LENGTH = 10000;
    private final String pelVersion;
    private final String json;
    private final String dataClass;
    @JsonDeserialize(converter=ToUnmodifiableSet.class)
    private final Set<String> compatibleDataClasses;
    private final String extensionName;

    private SerializablePythonIOObject() {
        this(null, new HashSet<String>(), null, null, null);
    }

    public SerializablePythonIOObject(String dataClass, String json, String extensionName, String pelVersion) {
        this(dataClass, new HashSet<String>(), json, extensionName, pelVersion);
    }

    public SerializablePythonIOObject(String dataClass, Set<String> compatibleDataClasses, String json, String extensionName, String pelVersion) {
        this.dataClass = dataClass;
        this.compatibleDataClasses = compatibleDataClasses == null ? Collections.emptySet() : Set.copyOf(compatibleDataClasses);
        this.json = json;
        this.extensionName = extensionName;
        this.pelVersion = pelVersion;
    }

    public String getJson() {
        return this.json;
    }

    public String getName() {
        return this.getDataClass();
    }

    public String toString() {
        return "PythonIOObject (" + this.getDataClass() + ")";
    }

    public String toResultString() {
        if (this.json.length() > 10000) {
            return I18N.getGUIMessage((String)"gui.too_large_pyoo.result_string", (Object[])new Object[0]) + "\n" + this.json.substring(0, 10000) + "...";
        }
        return this.json;
    }

    @Override
    public String getDataClass() {
        return this.dataClass;
    }

    @Override
    public Set<String> compatibleDataClasses() {
        return this.compatibleDataClasses;
    }

    @Override
    public String getExtensionName() {
        return this.extensionName;
    }

    public String getPythonExtensionLoaderVersion() {
        return this.pelVersion;
    }

    private static final class ToUnmodifiableSet<T>
    extends StdConverter<Set<T>, Set<T>> {
        private ToUnmodifiableSet() {
        }

        public Set<T> convert(Set<T> value) {
            return Collections.unmodifiableSet(value);
        }
    }
}

