/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.operator.wrapper;

import com.altair.ai.pel.operator.wrapper.PythonFunctionCall;
import com.altair.ai.pel.operator.wrapper.PythonFunctionDataType;
import com.altair.ai.pel.operator.wrapper.PythonFunctionInput;
import com.altair.ai.pel.operator.wrapper.PythonFunctionOutput;
import com.altair.ai.pel.operator.wrapper.PythonFunctionSourceType;
import com.altair.ai.pel.operator.wrapper.PythonFunctionTargetType;
import com.rapidminer.tools.ValidationUtilV2;
import java.util.ArrayList;
import java.util.List;

public final class PythonFunctionCallBuilder {
    private final String function;
    private final String module;
    private final List<PythonFunctionInput> inputs = new ArrayList<PythonFunctionInput>();
    private final List<PythonFunctionOutput> outputs = new ArrayList<PythonFunctionOutput>();
    private final List<String> libZips;

    public PythonFunctionCallBuilder(String function, String module, List<String> libZips) {
        this.function = ValidationUtilV2.requireNonEmptyString((String)function, (String)"function");
        this.module = ValidationUtilV2.requireNonEmptyString((String)module, (String)"module");
        this.libZips = ValidationUtilV2.requireNonEmptyList(libZips, (String)"libZips");
    }

    public PythonFunctionCallBuilder addInput(String name, PythonFunctionSourceType source, PythonFunctionDataType dataType, Object value, boolean collection) {
        this.inputs.add(new PythonFunctionInput(name, source, dataType, value, collection));
        return this;
    }

    public PythonFunctionCallBuilder addOutput(String name, PythonFunctionTargetType target, PythonFunctionDataType dataType, String dataClass, boolean collection) {
        this.outputs.add(new PythonFunctionOutput(name, target, dataType, dataClass, collection));
        return this;
    }

    public PythonFunctionCall build() {
        return new PythonFunctionCall(this.function, this.module, this.inputs, this.outputs, this.libZips);
    }
}

