/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.operator.wrapper;

import com.altair.ai.pel.operator.wrapper.PythonDataExchange;
import com.altair.ai.pel.operator.wrapper.PythonFunctionCall;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class PythonFunctionChain {
    private final List<PythonFunctionCall> functions;
    private final PythonDataExchange dataExchange;
    private final Map<String, String> additionalFunctionArgs;
    private final Map<String, String> environmentProperties;

    PythonFunctionChain(List<PythonFunctionCall> functions, PythonDataExchange dataExchange, Map<String, String> additionalFunctionArgs, Map<String, String> environmentProperties) {
        this.functions = Collections.unmodifiableList(functions);
        this.dataExchange = dataExchange;
        this.additionalFunctionArgs = Collections.unmodifiableMap(additionalFunctionArgs);
        this.environmentProperties = Collections.unmodifiableMap(environmentProperties);
    }

    public List<PythonFunctionCall> getFunctions() {
        return this.functions;
    }

    @JsonProperty(value="lib_zips")
    public Set<String> getLibZips() {
        return this.getFunctions().stream().flatMap(f -> f.getLibZips().stream()).collect(Collectors.toSet());
    }

    @JsonProperty(value="data_exchange")
    public PythonDataExchange getDataExchange() {
        return this.dataExchange;
    }

    @JsonProperty(value="additional_func_args")
    public Map<String, String> getAdditionalFunctionArgs() {
        return this.additionalFunctionArgs;
    }

    @JsonProperty(value="environment")
    public Map<String, String> getEnvironmentProperties() {
        return this.environmentProperties;
    }

    public String toString() {
        return "PythonFunctionChain{functions=" + this.functions + ", dataExchange=" + this.dataExchange + ", additionalFunctionArgs=" + this.additionalFunctionArgs + ", environmentProperties=" + this.environmentProperties + "}";
    }
}

