/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.python.bridge;

import com.altair.ai.pel.distribution.PythonDistribution;
import com.altair.ai.pel.distribution.PythonDistributionHandler;
import com.altair.ai.pel.distribution.PythonDistributionReference;
import com.altair.ai.pel.miniforge.MiniforgeHandler;
import com.altair.ai.pel.python.bridge.CommunicationMode;
import com.altair.ai.pel.python.bridge.DataExchangeMode;
import com.altair.ai.pel.python.bridge.PythonBridgeStatus;
import com.altair.ai.pel.python.bridge.PythonScriptDelegator;
import com.altair.ai.pel.python.exception.PythonDistributionException;
import com.altair.ai.pel.python.exception.PythonDistributionNotReadyException;
import com.altair.ai.pel.python.exception.PythonDistributionNotRegisteredException;
import com.altair.ai.pel.python.exception.PythonSDKException;
import com.altair.ai.pel.python.exception.PythonScriptRunnerException;
import com.altair.ai.pel.python.listener.PythonBridgeListener;
import com.altair.ai.pel.python.script.PythonBaseScript;
import com.altair.ai.pel.python.script.result.SubmissionResult;
import com.altair.ai.pel.python.settings.PythonSDKSettings;
import com.rapidminer.core.concurrency.ConcurrencyContext;
import com.rapidminer.studio.concurrency.internal.SequentialConcurrencyContext;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.SecurityTools;
import com.rapidminer.tools.ShutdownHooks;
import com.rapidminer.tools.ValidationUtilV2;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;

public enum PythonBridge {
    INSTANCE;

    private final List<PythonBridgeListener> listenerList = Collections.synchronizedList(new ArrayList());
    private final ExecutorService listenerNotificationService = Executors.newFixedThreadPool(1);
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private volatile PythonBridgeStatus bridgeStatus = PythonBridgeStatus.NOT_READY;

    public synchronized void initialize() {
        if (this.initialized.compareAndSet(false, true)) {
            LogService.getRoot().log(Level.FINE, "Initializing Python bridge");
            try {
                if (!PythonSDKSettings.isInitialized()) {
                    PythonSDKSettings.updateSettings();
                }
            }
            catch (PythonSDKException e) {
                LogService.getRoot().log(Level.SEVERE, "Cannot setup Python Bridge, configuration is wrong", e);
                this.setBridgeStatus(PythonBridgeStatus.ERROR);
                return;
            }
            PythonScriptDelegator.INSTANCE.initialize();
            ShutdownHooks.addShutdownHook(this::shutdown);
            try {
                if (PythonSDKSettings.isMiniforgeEnabled()) {
                    if (!MiniforgeHandler.INSTANCE.isMiniforgeInstalled()) {
                        MiniforgeHandler.INSTANCE.installMiniforge();
                        MiniforgeHandler.INSTANCE.initializeMiniforgeLocally();
                    } else {
                        LogService.getRoot().log(Level.INFO, "Miniforge already installed, checking init status");
                        if (!MiniforgeHandler.INSTANCE.isMiniforgeInitialized()) {
                            MiniforgeHandler.INSTANCE.initializeMiniforgeLocally();
                        }
                    }
                    MiniforgeHandler.INSTANCE.updateCondaConfig();
                }
            }
            catch (Exception e) {
                LogService.getRoot().log(Level.SEVERE, "Failed to setup Miniforge, Python distributions may not be available!", e);
            }
            this.setBridgeStatus(PythonBridgeStatus.READY);
        }
    }

    public synchronized SubmissionResult submitScript(PythonDistribution pyDist, PythonBaseScript script, CommunicationMode communicationMode, DataExchangeMode dataExchangeMode) throws PythonDistributionException, PythonScriptRunnerException {
        return this.submitScript(pyDist, script, communicationMode, dataExchangeMode, (ConcurrencyContext)new SequentialConcurrencyContext());
    }

    public synchronized SubmissionResult submitScript(PythonDistribution pyDist, PythonBaseScript script, CommunicationMode communicationMode, DataExchangeMode dataExchangeMode, ConcurrencyContext concurrencyContext) throws PythonDistributionException, PythonScriptRunnerException {
        SecurityTools.requireInternalPermission();
        ValidationUtilV2.requireNonNull((Object)script, (String)"script");
        ValidationUtilV2.requireNonNull((Object)concurrencyContext, (String)"concurrencyContext");
        if (pyDist == null) {
            throw new PythonDistributionNotRegisteredException("No Python distribution selected!", null);
        }
        if (this.bridgeStatus == PythonBridgeStatus.NOT_READY || this.bridgeStatus == PythonBridgeStatus.ERROR) {
            throw new PythonDistributionNotReadyException("Python bridge not yet ready!", pyDist);
        }
        PythonDistributionReference distRef = PythonDistributionHandler.INSTANCE.getDistributionReference(pyDist);
        if (distRef == null) {
            throw new PythonDistributionNotReadyException("Distribution not found", pyDist);
        }
        return PythonScriptDelegator.INSTANCE.submitScript(distRef, script, communicationMode, dataExchangeMode, concurrencyContext);
    }

    public void addBridgeListener(PythonBridgeListener listener) {
        this.listenerList.add((PythonBridgeListener)ValidationUtilV2.requireNonNull((Object)listener, (String)"listener"));
        this.notifyListeners(Collections.singletonList(listener), this.bridgeStatus);
    }

    public void removeBridgeListener(PythonBridgeListener listener) {
        this.listenerList.remove(ValidationUtilV2.requireNonNull((Object)listener, (String)"listener"));
    }

    public void shutdown() {
        if (this.initialized.compareAndSet(true, false)) {
            this.setBridgeStatus(PythonBridgeStatus.NOT_READY);
        }
    }

    public PythonBridgeStatus getBridgeStatus() {
        return this.bridgeStatus;
    }

    private void setBridgeStatus(PythonBridgeStatus status) {
        if (this.bridgeStatus != status) {
            this.bridgeStatus = status;
            this.notifyAllListeners(status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyAllListeners(PythonBridgeStatus status) {
        List<PythonBridgeListener> list = this.listenerList;
        synchronized (list) {
            this.notifyListeners(this.listenerList, status);
        }
    }

    private void notifyListeners(List<PythonBridgeListener> listenerList, PythonBridgeStatus status) {
        block5: for (PythonBridgeListener listener : listenerList) {
            switch (status) {
                case READY: {
                    this.notifyListener(listener::bridgeReady);
                    continue block5;
                }
                case NOT_READY: {
                    this.notifyListener(listener::bridgeNotReady);
                    continue block5;
                }
                case ERROR: {
                    this.notifyListener(listener::bridgeError);
                    continue block5;
                }
            }
            LogService.getRoot().log(Level.WARNING, () -> String.format("The Python bridge BridgeStatus %s not handled, cannot notify listeners!", new Object[]{status}));
        }
    }

    private void notifyListener(Runnable r) {
        try {
            this.listenerNotificationService.submit(r);
        }
        catch (RejectedExecutionException e) {
            LogService.getRoot().log(Level.WARNING, "Failed to notify listener about Python bridge event", e);
        }
    }
}

