/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.python.bridge;

import com.altair.ai.pel.distribution.PythonDistributionReference;
import com.altair.ai.pel.python.bridge.CommunicationMode;
import com.altair.ai.pel.python.bridge.DataExchangeMode;
import com.altair.ai.pel.python.exception.PythonScriptRunnerException;
import com.altair.ai.pel.python.script.PythonBaseScript;
import com.altair.ai.pel.python.script.PythonScriptRunner;
import com.altair.ai.pel.python.script.PythonScriptRunnerFactory;
import com.altair.ai.pel.python.script.PythonScriptTask;
import com.altair.ai.pel.python.script.result.SubmissionResult;
import com.rapidminer.core.concurrency.ConcurrencyContext;
import com.rapidminer.core.concurrency.ExecutionStoppedException;
import com.rapidminer.tools.LogService;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.logging.Level;

enum PythonScriptDelegator {
    INSTANCE;

    private final AtomicBoolean initialized = new AtomicBoolean(false);

    synchronized void initialize() {
        if (this.initialized.compareAndSet(false, true)) {
            LogService.getRoot().log(Level.FINE, "Initializing Python distribution script runner");
        }
    }

    synchronized SubmissionResult submitScript(PythonDistributionReference distRef, PythonBaseScript script, CommunicationMode communicationMode, DataExchangeMode dataExchangeMode, ConcurrencyContext concurrencyContext) throws PythonScriptRunnerException {
        PythonScriptRunner scriptRunner = PythonScriptRunnerFactory.INSTANCE.createNewRunner(communicationMode, dataExchangeMode);
        Callable<Void> prepareRun = scriptRunner.prepareRun(distRef, script);
        Callable<Void> pyRun = scriptRunner.createRunner(distRef, script);
        Supplier<Callable<Void>> stopCallback = scriptRunner.createStopCallback();
        PythonScriptTask task = scriptRunner.getTask();
        Callable<Void> combinedCallable = () -> {
            try {
                prepareRun.call();
                pyRun.call();
            }
            catch (Exception e) {
                task.markException(e);
                task.completeScriptTaskAsync();
            }
            return null;
        };
        try {
            concurrencyContext.call(List.of(combinedCallable));
        }
        catch (ExecutionStoppedException e) {
            try {
                stopCallback.get().call();
            }
            catch (Exception ex) {
                task.markException(ex);
                task.completeScriptTaskAsync();
            }
        }
        catch (Exception e) {
            task.markException(e);
            task.completeScriptTaskAsync();
        }
        return new SubmissionResult(task.getCompletableFuture(), stopCallback);
    }
}

