/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.python.script;

import com.altair.ai.pel.distribution.PythonDistributionReference;
import com.altair.ai.pel.python.exception.PythonScriptRunnerException;
import com.altair.ai.pel.python.script.PythonBaseScript;
import com.altair.ai.pel.python.script.PythonScriptRunner;
import com.altair.ai.pel.python.script.result.ScriptOutput;
import com.altair.ai.pel.util.FileTools;
import com.rapidminer.tools.LogService;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import org.apache.commons.io.FileUtils;

abstract class AbstractScriptRunnerWithLocalFileTransfer
implements PythonScriptRunner {
    private static final Path ROOT_WORKING_DIR = FileTools.getTempDirectory();
    protected String scriptId;
    protected Path workingDir;
    protected Path inputsDir;
    protected Path outputsDir;

    AbstractScriptRunnerWithLocalFileTransfer() {
    }

    @Override
    public Callable<Void> prepareRun(PythonDistributionReference distRef, PythonBaseScript script) {
        return () -> {
            this.scriptId = script.getId();
            this.workingDir = ROOT_WORKING_DIR.resolve(script.getId());
            this.inputsDir = this.workingDir.resolve("inputs");
            this.outputsDir = this.workingDir.resolve("outputs");
            try {
                Files.createDirectories(this.workingDir, new FileAttribute[0]);
                Files.createDirectories(this.inputsDir, new FileAttribute[0]);
                Files.createDirectories(this.outputsDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new PythonScriptRunnerException("Failed to prepare data exchange directories", e);
            }
            return null;
        };
    }

    @Override
    public synchronized void cleanupRun() {
        File workingDirFolder = this.workingDir.toFile();
        if (workingDirFolder.exists()) {
            try {
                AccessController.doPrivileged(() -> {
                    FileUtils.deleteDirectory((File)workingDirFolder);
                    return null;
                });
            }
            catch (PrivilegedActionException e) {
                LogService.getRoot().log(Level.WARNING, e.getCause(), () -> "Failed to remove working dir for Python script " + this.scriptId);
            }
        }
    }

    protected void setResultOutputs(PythonBaseScript script) {
        for (ScriptOutput expectedOutput : script.getExpectedOutputs()) {
            expectedOutput.setOutput(() -> {
                try {
                    return Files.newInputStream(this.workingDir.resolve("outputs").resolve(expectedOutput.getName()), new OpenOption[0]);
                }
                catch (IOException e) {
                    LogService.getRoot().log(Level.SEVERE, e, () -> String.format("Failed to supply expected output %s", expectedOutput.getName()));
                    return null;
                }
            });
        }
    }
}

