/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.python.script;

import com.altair.ai.pel.python.exception.PythonSDKException;
import com.altair.ai.pel.python.script.PythonStreamProvider;
import com.altair.ai.pel.python.script.result.ScriptOutput;
import com.rapidminer.tools.FunctionWithThrowable;
import com.rapidminer.tools.ValidationUtilV2;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;

public abstract class PythonBaseScript {
    private static final String BLACKLISTED_REGEX = "[\\/\\\\\\:\\<\\>\\*\\?\\\"\\|]";
    private final String id;
    private final FunctionWithThrowable<Path, List<String>, PythonSDKException> argProvider;
    private final FunctionWithThrowable<Path, List<PythonStreamProvider>, Exception> sourceProviders;
    private final FunctionWithThrowable<Path, List<PythonStreamProvider>, Exception> inputProviders;
    private final List<ScriptOutput> expectedOutputs;
    private final Consumer<String> stdOutConsumer;
    private final Consumer<String> stdErrConsumer;

    protected PythonBaseScript(String idPrefix, FunctionWithThrowable<Path, List<String>, PythonSDKException> argProvider, FunctionWithThrowable<Path, List<PythonStreamProvider>, Exception> sourceProviders, FunctionWithThrowable<Path, List<PythonStreamProvider>, Exception> inputProviders, List<ScriptOutput> expectedOutputs, Consumer<String> stdOutConsumer, Consumer<String> stdErrConsumer) {
        Object fullId = ValidationUtilV2.requireNonEmptyString((String)idPrefix, (String)"idPrefix") + "_" + UUID.randomUUID();
        this.id = fullId = ((String)fullId).replaceAll(BLACKLISTED_REGEX, "_");
        this.argProvider = argProvider;
        this.sourceProviders = (FunctionWithThrowable)ValidationUtilV2.requireNonNull(sourceProviders, (String)"sourceProviders");
        this.inputProviders = (FunctionWithThrowable)ValidationUtilV2.requireNonNull(inputProviders, (String)"inputProviders");
        this.expectedOutputs = (List)ValidationUtilV2.requireNonNull(expectedOutputs, (String)"expectedOutputs");
        this.stdOutConsumer = stdOutConsumer;
        this.stdErrConsumer = stdErrConsumer;
    }

    public List<String> createArguments(Path workingDir) throws PythonSDKException {
        return this.argProvider != null ? (List)this.argProvider.applyWithException((Object)workingDir) : Collections.emptyList();
    }

    public List<PythonStreamProvider> createSourceProviders(Path inputsDir) throws Exception {
        return (List)this.sourceProviders.applyWithException((Object)inputsDir);
    }

    public List<PythonStreamProvider> createInputProviders(Path inputsDir) throws Exception {
        return (List)this.inputProviders.applyWithException((Object)inputsDir);
    }

    public List<ScriptOutput> getExpectedOutputs() {
        return this.expectedOutputs;
    }

    public Consumer<String> getStdOutConsumer() {
        return this.stdOutConsumer;
    }

    public Consumer<String> getStdErrConsumer() {
        return this.stdErrConsumer;
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return "PythonScript{id='" + this.id + "', expectedOutputs=" + this.expectedOutputs + "}";
    }
}

