/*
 * Decompiled with CFR 0.152.
 */
package com.altair.ai.pel.python.script;

import com.altair.ai.pel.python.script.PythonStreamProvider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public final class PythonInputCollectionProvider
implements PythonStreamProvider {
    private final String inputName;
    private final List<Callable<InputStream>> inputEntrySuppliers;

    public PythonInputCollectionProvider(String inputName, List<Callable<InputStream>> inputEntrySuppliers) {
        this.inputName = inputName;
        this.inputEntrySuppliers = inputEntrySuppliers;
    }

    @Override
    public String getContentName() {
        return this.inputName;
    }

    @Override
    public Callable<InputStream> getContentSupplier() {
        return () -> {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (ZipOutputStream zos = new ZipOutputStream(baos);){
                int inputCounter = 0;
                for (Callable<InputStream> inputEntrySupplier : this.inputEntrySuppliers) {
                    ZipEntry zipEntry = new ZipEntry(String.format("input_%d", inputCounter++));
                    zos.putNextEntry(zipEntry);
                    try (InputStream is = inputEntrySupplier.call();){
                        is.transferTo(zos);
                    }
                    zos.closeEntry();
                }
            }
            return new ByteArrayInputStream(baos.toByteArray());
        };
    }
}

